/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.ctf.core.event.io;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.eclipse.linuxtools.ctf.core.trace.CTFReaderException;

public final class BitBuffer {
    public static final int BIT_CHAR = 8;
    public static final int BIT_SHORT = 16;
    public static final int BIT_INT = 32;
    public static final int BIT_FLOAT = 32;
    public static final int BIT_LONG = 64;
    private ByteBuffer fBuffer;
    private long fPosition;
    private ByteOrder fByteOrder;

    public BitBuffer() {
        this(null, ByteOrder.BIG_ENDIAN);
    }

    public BitBuffer(ByteBuffer buf) {
        this(buf, ByteOrder.BIG_ENDIAN);
    }

    public BitBuffer(ByteBuffer buf, ByteOrder order) {
        this.setByteBuffer(buf);
        this.setByteOrder(order);
        this.resetPosition();
    }

    private void resetPosition() {
        this.fPosition = 0L;
    }

    public int getInt() throws CTFReaderException {
        return this.getInt(32, true);
    }

    public long getLong() throws CTFReaderException {
        return this.get(64, true);
    }

    public long get(int length, boolean signed) throws CTFReaderException {
        if (length > 64) {
            throw new CTFReaderException("Cannot read a long longer than 64 bits. Rquested: " + length);
        }
        if (length > 32) {
            long retVal;
            int highShift = length - 32;
            long a = this.getInt();
            long b = this.getInt(highShift, false);
            long l = retVal = this.fByteOrder == ByteOrder.BIG_ENDIAN ? a << highShift | b : (b &= (1L << highShift) - 1L) << 32 | (a &= 0xFFFFFFFFL);
            if (signed) {
                int signExtendBits = 64 - length;
                retVal = retVal << signExtendBits >> signExtendBits;
            }
            return retVal;
        }
        long retVal = this.getInt(length, signed);
        return signed ? retVal : retVal & 0xFFFFFFFFL;
    }

    private int getInt(int length, boolean signed) throws CTFReaderException {
        if (length == 0) {
            return 0;
        }
        if (!this.canRead(length)) {
            throw new CTFReaderException("Cannot read the integer, the buffer does not have enough remaining space. Requested:" + length);
        }
        int val = 0;
        boolean gotIt = false;
        if ((this.fPosition & 7L) == 0L) {
            switch (length) {
                case 8: {
                    val = this.fBuffer.get((int)(this.fPosition / 8L));
                    if (!signed) {
                        val &= 0xFF;
                    }
                    gotIt = true;
                    break;
                }
                case 16: {
                    val = this.fBuffer.getShort((int)(this.fPosition / 8L));
                    if (!signed) {
                        val &= 0xFFFF;
                    }
                    gotIt = true;
                    break;
                }
                case 32: {
                    val = this.fBuffer.getInt((int)(this.fPosition / 8L));
                    gotIt = true;
                    break;
                }
            }
        }
        if (!gotIt) {
            val = this.fByteOrder == ByteOrder.LITTLE_ENDIAN ? this.getIntLE(this.fPosition, length, signed) : this.getIntBE(this.fPosition, length, signed);
        }
        this.fPosition += (long)length;
        return val;
    }

    private int getIntBE(long index, int length, boolean signed) {
        int lshift;
        int cmask;
        int mask;
        boolean isNeg;
        assert (length > 0 && length <= 32);
        long end = index + (long)length;
        int startByte = (int)(index / 8L);
        int endByte = (int)((end + 7L) / 8L);
        int value = 0;
        int currByte = startByte;
        int cache = this.fBuffer.get(currByte) & 0xFF;
        boolean bl = isNeg = (cache & 1 << (int)(8L - index % 8L - 1L)) != 0;
        if (signed && isNeg) {
            value = -1;
        }
        if (startByte == endByte - 1) {
            int cmask2 = cache >>> (int)((8L - end % 8L) % 8L);
            if (length % 8 > 0) {
                int mask2 = ~(-1 << length);
                cmask2 &= mask2;
            }
            value <<= length;
            return value |= cmask2;
        }
        int cshift = (int)(index % 8L);
        if (cshift > 0) {
            mask = ~(-1 << 8 - cshift);
            cmask = cache & mask;
            lshift = 8 - cshift;
            value <<= lshift;
            value |= cmask;
            ++currByte;
        }
        while (currByte < endByte - 1) {
            value <<= 8;
            value |= this.fBuffer.get(currByte) & 0xFF;
            ++currByte;
        }
        lshift = (int)(end % 8L);
        if (lshift > 0) {
            mask = ~(-1 << lshift);
            cmask = this.fBuffer.get(currByte) & 0xFF;
            cmask >>>= 8 - lshift;
            value <<= lshift;
            value |= (cmask &= mask);
        } else {
            value <<= 8;
            value |= this.fBuffer.get(currByte) & 0xFF;
        }
        return value;
    }

    private int getIntLE(long index, int length, boolean signed) {
        int cmask;
        int mask;
        boolean isNeg;
        assert (length > 0 && length <= 32);
        long end = index + (long)length;
        int startByte = (int)(index / 8L);
        int endByte = (int)((end + 7L) / 8L);
        int value = 0;
        int currByte = endByte - 1;
        int cache = this.fBuffer.get(currByte) & 0xFF;
        int mod = (int)(end % 8L);
        int lshift = mod > 0 ? mod : 8;
        boolean bl = isNeg = (cache & 1 << lshift - 1) != 0;
        if (signed && isNeg) {
            value = -1;
        }
        if (startByte == endByte - 1) {
            int cmask2 = cache >>> (int)(index % 8L);
            if (length % 8 > 0) {
                int mask2 = ~(-1 << length);
                cmask2 &= mask2;
            }
            value <<= length;
            return value |= cmask2;
        }
        int cshift = (int)(end % 8L);
        if (cshift > 0) {
            mask = ~(-1 << cshift);
            cmask = cache & mask;
            value <<= cshift;
            value |= cmask;
            --currByte;
        }
        while (currByte >= startByte + 1) {
            value <<= 8;
            value |= this.fBuffer.get(currByte) & 0xFF;
            --currByte;
        }
        lshift = (int)(index % 8L);
        if (lshift > 0) {
            mask = ~(-1 << 8 - lshift);
            cmask = this.fBuffer.get(currByte) & 0xFF;
            cmask >>>= lshift;
            value <<= 8 - lshift;
            value |= (cmask &= mask);
        } else {
            value <<= 8;
            value |= this.fBuffer.get(currByte) & 0xFF;
        }
        return value;
    }

    public void putInt(int value) throws CTFReaderException {
        this.putInt(32, value);
    }

    public void putInt(int length, int value) throws CTFReaderException {
        long curPos = this.fPosition;
        if (!this.canRead(length)) {
            throw new CTFReaderException("Cannot write to bitbuffer, insufficient space. Requested: " + length);
        }
        if (length == 0) {
            return;
        }
        if (this.fByteOrder == ByteOrder.LITTLE_ENDIAN) {
            this.putIntLE(curPos, length, value);
        } else {
            this.putIntBE(curPos, length, value);
        }
        this.fPosition += (long)length;
    }

    private void putIntBE(long index, int length, int value) {
        int b;
        int cmask;
        int mask;
        assert (length > 0 && length <= 32);
        long end = index + (long)length;
        int startByte = (int)(index / 8L);
        int endByte = (int)((end + 7L) / 8L);
        int correctedValue = value;
        if (length < 32) {
            correctedValue &= ~(-1 << length);
        }
        if (startByte == endByte - 1) {
            int lshift = (int)((8L - end % 8L) % 8L);
            int mask2 = ~(-1 << lshift);
            if (index % 8L > 0L) {
                mask2 |= -1 << (int)(8L - index % 8L);
            }
            int cmask2 = correctedValue << lshift;
            int b2 = this.fBuffer.get(startByte) & 0xFF;
            this.fBuffer.put(startByte, (byte)(b2 & mask2 | (cmask2 &= ~mask2)));
            return;
        }
        int currByte = endByte - 1;
        int cshift = (int)(end % 8L);
        if (cshift > 0) {
            int lshift = 8 - cshift;
            mask = ~(-1 << lshift);
            cmask = correctedValue << lshift;
            b = this.fBuffer.get(currByte) & 0xFF;
            this.fBuffer.put(currByte, (byte)(b & mask | (cmask &= ~mask)));
            correctedValue >>>= cshift;
            --currByte;
        }
        while (currByte >= startByte + 1) {
            this.fBuffer.put(currByte, (byte)correctedValue);
            correctedValue >>>= 8;
            --currByte;
        }
        if (index % 8L > 0L) {
            mask = -1 << (int)(8L - index % 8L);
            cmask = correctedValue & ~mask;
            b = this.fBuffer.get(currByte) & 0xFF;
            this.fBuffer.put(currByte, (byte)(b & mask | cmask));
        } else {
            this.fBuffer.put(currByte, (byte)correctedValue);
        }
    }

    private void putIntLE(long index, int length, int value) {
        int b;
        int cmask;
        int mask;
        assert (length > 0 && length <= 32);
        long end = index + (long)length;
        int startByte = (int)(index / 8L);
        int endByte = (int)((end + 7L) / 8L);
        int correctedValue = value;
        if (length < 32) {
            correctedValue &= ~(-1 << length);
        }
        if (startByte == endByte - 1) {
            int lshift = (int)(index % 8L);
            int mask2 = ~(-1 << lshift);
            if (end % 8L > 0L) {
                mask2 |= -1 << (int)(end % 8L);
            }
            int cmask2 = correctedValue << lshift;
            int b2 = this.fBuffer.get(startByte) & 0xFF;
            this.fBuffer.put(startByte, (byte)(b2 & mask2 | (cmask2 &= ~mask2)));
            return;
        }
        int currByte = startByte;
        int cshift = (int)(index % 8L);
        if (cshift > 0) {
            mask = ~(-1 << cshift);
            cmask = correctedValue << cshift;
            b = this.fBuffer.get(currByte) & 0xFF;
            this.fBuffer.put(currByte, (byte)(b & mask | (cmask &= ~mask)));
            correctedValue >>>= 8 - cshift;
            ++currByte;
        }
        while (currByte < endByte - 1) {
            this.fBuffer.put(currByte, (byte)correctedValue);
            correctedValue >>>= 8;
            ++currByte;
        }
        if (end % 8L > 0L) {
            mask = -1 << (int)(end % 8L);
            cmask = correctedValue & ~mask;
            b = this.fBuffer.get(currByte) & 0xFF;
            this.fBuffer.put(currByte, (byte)(b & mask | cmask));
        } else {
            this.fBuffer.put(currByte, (byte)correctedValue);
        }
    }

    public boolean canRead(int length) {
        if (this.fBuffer == null) {
            return false;
        }
        return this.fPosition + (long)length <= (long)this.fBuffer.capacity() * 8L;
    }

    public void setByteOrder(ByteOrder order) {
        this.fByteOrder = order;
        if (this.fBuffer != null) {
            this.fBuffer.order(order);
        }
    }

    public ByteOrder getByteOrder() {
        return this.fByteOrder;
    }

    public void position(long newPosition) throws CTFReaderException {
        if (this.fBuffer != null && newPosition / 8L > (long)this.fBuffer.capacity()) {
            throw new CTFReaderException("Out of bounds exception on a position move, attempting to access position: " + newPosition);
        }
        this.fPosition = newPosition;
    }

    public long position() {
        return this.fPosition;
    }

    public void setByteBuffer(ByteBuffer buf) {
        this.fBuffer = buf;
        if (buf != null) {
            this.fBuffer.order(this.fByteOrder);
        }
        this.clear();
    }

    public ByteBuffer getByteBuffer() {
        return this.fBuffer;
    }

    public void clear() {
        this.resetPosition();
        if (this.fBuffer == null) {
            return;
        }
        this.fBuffer.clear();
    }
}

