/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.ctf.core.event.types;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Multimap;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.linuxtools.ctf.core.event.io.BitBuffer;
import org.eclipse.linuxtools.ctf.core.event.scope.IDefinitionScope;
import org.eclipse.linuxtools.ctf.core.event.types.ArrayDefinition;
import org.eclipse.linuxtools.ctf.core.event.types.Declaration;
import org.eclipse.linuxtools.ctf.core.event.types.Definition;
import org.eclipse.linuxtools.ctf.core.event.types.IDeclaration;
import org.eclipse.linuxtools.ctf.core.event.types.IntegerDeclaration;
import org.eclipse.linuxtools.ctf.core.trace.CTFReaderException;

public class ArrayDeclaration
extends Declaration {
    private final int fLength;
    private final IDeclaration fElemType;
    private final Multimap<String, String> fChildrenNames = ArrayListMultimap.create();

    public ArrayDeclaration(int length, IDeclaration elemType) {
        this.fLength = length;
        this.fElemType = elemType;
    }

    public IDeclaration getElementType() {
        return this.fElemType;
    }

    public int getLength() {
        return this.fLength;
    }

    public boolean isString() {
        IntegerDeclaration elemInt;
        return this.fElemType instanceof IntegerDeclaration && (elemInt = (IntegerDeclaration)this.fElemType).isCharacter();
    }

    @Override
    public long getAlignment() {
        return this.getElementType().getAlignment();
    }

    @Override
    public ArrayDefinition createDefinition(IDefinitionScope definitionScope, @NonNull String fieldName, BitBuffer input) throws CTFReaderException {
        this.alignRead(input);
        List<Definition> definitions = this.read(input, definitionScope, fieldName);
        return new ArrayDefinition(this, definitionScope, fieldName, definitions);
    }

    public String toString() {
        return "[declaration] array[" + Integer.toHexString(this.hashCode()) + ']';
    }

    @NonNull
    private List<Definition> read(@NonNull BitBuffer input, IDefinitionScope definitionScope, String fieldName) throws CTFReaderException {
        ImmutableList.Builder definitions = new ImmutableList.Builder();
        if (!this.fChildrenNames.containsKey((Object)fieldName)) {
            int i = 0;
            while (i < this.fLength) {
                this.fChildrenNames.put((Object)fieldName, (Object)(String.valueOf(fieldName) + '[' + i + ']'));
                ++i;
            }
        }
        List elemNames = (List)this.fChildrenNames.get((Object)fieldName);
        int i = 0;
        while (i < this.fLength) {
            String name = (String)elemNames.get(i);
            if (name == null) {
                throw new IllegalStateException();
            }
            definitions.add((Object)this.fElemType.createDefinition(definitionScope, name, input));
            ++i;
        }
        ImmutableList ret = definitions.build();
        return ret;
    }

    @Override
    public int getMaximumSize() {
        long val = (long)this.fLength * (long)this.fElemType.getMaximumSize();
        return (int)Math.min(Integer.MAX_VALUE, val);
    }
}

