/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.ctf.core.event.types;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import java.util.List;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.linuxtools.ctf.core.event.scope.IDefinitionScope;
import org.eclipse.linuxtools.ctf.core.event.types.ArrayDeclaration;
import org.eclipse.linuxtools.ctf.core.event.types.Definition;
import org.eclipse.linuxtools.ctf.core.event.types.IntegerDefinition;

@NonNullByDefault
public final class ArrayDefinition
extends Definition {
    private final ImmutableList<Definition> fDefinitions;

    public ArrayDefinition(ArrayDeclaration declaration, @Nullable IDefinitionScope definitionScope, String fieldName, List<Definition> definitions) {
        super(declaration, definitionScope, fieldName);
        ImmutableList list;
        this.fDefinitions = list = ImmutableList.copyOf(definitions);
    }

    public List<Definition> getDefinitions() {
        return this.fDefinitions;
    }

    @Nullable
    public Definition getElem(int i) {
        if (i > this.fDefinitions.size()) {
            return null;
        }
        return (Definition)this.fDefinitions.get(i);
    }

    @Override
    public ArrayDeclaration getDeclaration() {
        return (ArrayDeclaration)super.getDeclaration();
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        if (this.getDeclaration().isString()) {
            for (Definition def : this.fDefinitions) {
                IntegerDefinition character = (IntegerDefinition)def;
                if (character.getValue() != 0L) {
                    b.append(character.toString());
                    continue;
                }
                break;
            }
        } else {
            b.append('[');
            Joiner joiner = Joiner.on((String)", ").skipNulls();
            b.append(joiner.join(this.fDefinitions));
            b.append(']');
        }
        String ret = b.toString();
        return ret;
    }
}

