/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.ctf.core.event.types;

import java.nio.ByteOrder;
import org.eclipse.linuxtools.ctf.core.event.io.BitBuffer;
import org.eclipse.linuxtools.ctf.core.event.scope.IDefinitionScope;
import org.eclipse.linuxtools.ctf.core.event.types.Declaration;
import org.eclipse.linuxtools.ctf.core.event.types.FloatDefinition;
import org.eclipse.linuxtools.ctf.core.trace.CTFReaderException;

public final class FloatDeclaration
extends Declaration {
    private final int fMantissa;
    private final int fExponent;
    private final ByteOrder fByteOrder;
    private final long fAlignement;

    public FloatDeclaration(int exponent, int mantissa, ByteOrder byteOrder, long alignment) {
        this.fMantissa = mantissa;
        this.fExponent = exponent;
        this.fByteOrder = byteOrder;
        this.fAlignement = Math.max(alignment, 1L);
    }

    public int getMantissa() {
        return this.fMantissa;
    }

    public int getExponent() {
        return this.fExponent;
    }

    public ByteOrder getByteOrder() {
        return this.fByteOrder;
    }

    @Override
    public long getAlignment() {
        return this.fAlignement;
    }

    @Override
    public int getMaximumSize() {
        return this.fMantissa + this.fExponent + 1;
    }

    @Override
    public FloatDefinition createDefinition(IDefinitionScope definitionScope, String fieldName, BitBuffer input) throws CTFReaderException {
        this.alignRead(input);
        double value = this.read(input);
        return new FloatDefinition(this, definitionScope, fieldName, value);
    }

    public String toString() {
        return "[declaration] float[" + Integer.toHexString(this.hashCode()) + ']';
    }

    private double read(BitBuffer input) throws CTFReaderException {
        this.alignRead(input);
        int exp = this.getExponent();
        int mant = this.getMantissa();
        double value = Double.NaN;
        if (exp + mant == 32) {
            value = FloatDeclaration.readRawFloat32(input, mant, exp);
        } else if (exp + mant == 64) {
            value = FloatDeclaration.readRawFloat64(input, mant, exp);
        }
        return value;
    }

    private static double readRawFloat32(BitBuffer input, int manBits, int expBits) throws CTFReaderException {
        long temp = input.get(32, false);
        return FloatDeclaration.createFloat(temp, manBits - 1, expBits);
    }

    private static double readRawFloat64(BitBuffer input, int manBits, int expBits) throws CTFReaderException {
        long temp = input.get(64, false);
        return FloatDeclaration.createFloat(temp, manBits - 1, expBits);
    }

    private static double createFloat(long rawValue, int manBits, int expBits) {
        long manShift = 1L << manBits;
        long manMask = manShift - 1L;
        long expMask = (1L << expBits) - 1L;
        int exp = (int)(rawValue >> manBits & expMask) + 1;
        long man = rawValue & manMask;
        int offsetExponent = exp - (1 << expBits - 1);
        double expPow = Math.pow(2.0, offsetExponent);
        double ret = (float)man * 1.0f;
        ret /= (double)manShift;
        ret += 1.0;
        return ret *= expPow;
    }
}

