/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.ctf.core.trace;

import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.ByteOrder;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.UUID;
import org.eclipse.linuxtools.ctf.core.event.CTFCallsite;
import org.eclipse.linuxtools.ctf.core.event.CTFClock;
import org.eclipse.linuxtools.ctf.core.event.IEventDeclaration;
import org.eclipse.linuxtools.ctf.core.event.io.BitBuffer;
import org.eclipse.linuxtools.ctf.core.event.scope.IDefinitionScope;
import org.eclipse.linuxtools.ctf.core.event.scope.LexicalScope;
import org.eclipse.linuxtools.ctf.core.event.types.ArrayDefinition;
import org.eclipse.linuxtools.ctf.core.event.types.Definition;
import org.eclipse.linuxtools.ctf.core.event.types.IntegerDefinition;
import org.eclipse.linuxtools.ctf.core.event.types.StructDeclaration;
import org.eclipse.linuxtools.ctf.core.event.types.StructDefinition;
import org.eclipse.linuxtools.ctf.core.trace.CTFReaderException;
import org.eclipse.linuxtools.ctf.core.trace.CTFStream;
import org.eclipse.linuxtools.ctf.core.trace.CTFStreamInput;
import org.eclipse.linuxtools.ctf.core.trace.Metadata;
import org.eclipse.linuxtools.ctf.core.trace.MetadataComparator;
import org.eclipse.linuxtools.ctf.core.trace.MetadataFileFilter;
import org.eclipse.linuxtools.ctf.core.trace.Utils;
import org.eclipse.linuxtools.internal.ctf.core.event.CTFCallsiteComparator;
import org.eclipse.linuxtools.internal.ctf.core.event.metadata.exceptions.ParseException;

public class CTFTrace
implements IDefinitionScope,
AutoCloseable {
    private final File fPath;
    private Long fMajor;
    private Long fMinor;
    private UUID fUuid;
    private ByteOrder fByteOrder;
    private StructDeclaration fPacketHeaderDecl = null;
    private CTFClock fSingleClock;
    private StructDefinition fPacketHeaderDef;
    private final Map<Long, CTFStream> fStreams = new HashMap<Long, CTFStream>();
    private final Map<String, String> fEnvironment = new HashMap<String, String>();
    private final Map<String, CTFClock> fClocks = new HashMap<String, CTFClock>();
    private final List<FileInputStream> fFileInputStreams = new LinkedList<FileInputStream>();
    private static final FileFilter METADATA_FILE_FILTER = new MetadataFileFilter();
    private static final Comparator<File> METADATA_COMPARATOR = new MetadataComparator();
    private CTFCallsiteComparator fCtfCallsiteComparator = new CTFCallsiteComparator();
    private Map<String, TreeSet<CTFCallsite>> fCallsitesByName = new HashMap<String, TreeSet<CTFCallsite>>();
    private TreeSet<CTFCallsite> fCallsitesByIP = new TreeSet();

    public String toString() {
        return "CTFTrace [path=" + this.fPath + ", major=" + this.fMajor + ", minor=" + this.fMinor + ", uuid=" + this.fUuid + "]";
    }

    public CTFTrace(String path) throws CTFReaderException {
        this(new File(path));
    }

    public CTFTrace(File path) throws CTFReaderException {
        this.fPath = path;
        Metadata metadata = new Metadata(this);
        if (!this.fPath.exists()) {
            throw new CTFReaderException("Trace (" + path.getPath() + ") doesn't exist. Deleted or moved?");
        }
        if (!this.fPath.isDirectory()) {
            throw new CTFReaderException("Path must be a valid directory");
        }
        metadata.parseFile();
        this.init(path);
    }

    public CTFTrace() {
        this.fPath = null;
    }

    private void init(File path) throws CTFReaderException {
        File[] files = path.listFiles(METADATA_FILE_FILTER);
        Arrays.sort(files, METADATA_COMPARATOR);
        File[] fileArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File streamFile = fileArray[n2];
            this.openStreamInput(streamFile);
            ++n2;
        }
        for (CTFStream stream : this.getStreams()) {
            Set<CTFStreamInput> inputs = stream.getStreamInputs();
            for (CTFStreamInput s : inputs) {
                this.addStream(s);
            }
        }
    }

    @Override
    public void close() {
        for (FileInputStream fis : this.fFileInputStreams) {
            if (fis == null) continue;
            try {
                fis.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public Map<Long, IEventDeclaration> getEvents(Long streamId) {
        return this.fStreams.get(streamId).getEvents();
    }

    public IEventDeclaration getEventType(long streamId, long id) {
        return this.getEvents(streamId).get(id);
    }

    public CTFStream getStream(Long id) {
        return this.fStreams.get(id);
    }

    public int nbStreams() {
        return this.fStreams.size();
    }

    public void setMajor(long major) {
        this.fMajor = major;
    }

    public void setMinor(long minor) {
        this.fMinor = minor;
    }

    public void setUUID(UUID uuid) {
        this.fUuid = uuid;
    }

    public void setByteOrder(ByteOrder byteOrder) {
        this.fByteOrder = byteOrder;
    }

    public void setPacketHeader(StructDeclaration packetHeader) {
        this.fPacketHeaderDecl = packetHeader;
    }

    public boolean majorIsSet() {
        return this.fMajor != null;
    }

    public boolean minorIsSet() {
        return this.fMinor != null;
    }

    public boolean uuidIsSet() {
        return this.fUuid != null;
    }

    public boolean byteOrderIsSet() {
        return this.fByteOrder != null;
    }

    public boolean packetHeaderIsSet() {
        return this.fPacketHeaderDecl != null;
    }

    public UUID getUUID() {
        return this.fUuid;
    }

    public long getMajor() {
        return this.fMajor;
    }

    public long getMinor() {
        return this.fMinor;
    }

    public final ByteOrder getByteOrder() {
        return this.fByteOrder;
    }

    public StructDeclaration getPacketHeader() {
        return this.fPacketHeaderDecl;
    }

    public File getTraceDirectory() {
        return this.fPath;
    }

    public Iterable<CTFStream> getStreams() {
        return this.fStreams.values();
    }

    public String getPath() {
        return this.fPath != null ? this.fPath.getPath() : "";
    }

    @Override
    public LexicalScope getScopePath() {
        return LexicalScope.TRACE;
    }

    private void addStream(CTFStreamInput s) {
        for (Map.Entry<Long, IEventDeclaration> pairs : s.getStream().getEvents().entrySet()) {
            Long eventNum = pairs.getKey();
            IEventDeclaration eventDec = pairs.getValue();
            this.getEvents(s.getStream().getId()).put(eventNum, eventDec);
        }
        s.setupIndex();
    }

    private CTFStream openStreamInput(File streamFile) throws CTFReaderException {
        CTFStream stream;
        MappedByteBuffer byteBuffer;
        if (!streamFile.canRead()) {
            throw new CTFReaderException("Unreadable file : " + streamFile.getPath());
        }
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(streamFile);
            this.fFileInputStreams.add(fis);
            FileChannel fc = fis.getChannel();
            byteBuffer = fc.map(FileChannel.MapMode.READ_ONLY, 0L, (int)Math.min(fc.size(), 4096L));
        }
        catch (IOException e) {
            if (fis != null) {
                this.fFileInputStreams.remove(fis);
            }
            throw new CTFReaderException(e);
        }
        BitBuffer streamBitBuffer = new BitBuffer(byteBuffer, this.getByteOrder());
        if (this.fPacketHeaderDecl != null) {
            UUID otheruuid;
            this.fPacketHeaderDef = this.fPacketHeaderDecl.createDefinition(null, LexicalScope.PACKET_HEADER.getName(), streamBitBuffer);
            IntegerDefinition magicDef = (IntegerDefinition)this.fPacketHeaderDef.lookupDefinition("magic");
            int magic = (int)magicDef.getValue();
            if (magic != -1040441407) {
                throw new CTFReaderException("CTF magic mismatch");
            }
            Definition lookupDefinition = this.fPacketHeaderDef.lookupDefinition("uuid");
            ArrayDefinition uuidDef = (ArrayDefinition)lookupDefinition;
            if (uuidDef != null && !this.fUuid.equals(otheruuid = Utils.getUUIDfromDefinition(uuidDef))) {
                throw new CTFReaderException("UUID mismatch");
            }
            Definition streamIDDef = this.fPacketHeaderDef.lookupDefinition("stream_id");
            if (streamIDDef instanceof IntegerDefinition) {
                long streamID = ((IntegerDefinition)streamIDDef).getValue();
                stream = this.fStreams.get(streamID);
            } else {
                stream = this.fStreams.get(null);
            }
        } else {
            stream = this.fStreams.get(null);
        }
        if (stream == null) {
            throw new CTFReaderException("Unexpected end of stream");
        }
        stream.addInput(new CTFStreamInput(stream, streamFile));
        return stream;
    }

    @Override
    public Definition lookupDefinition(String lookupPath) {
        if (lookupPath.equals("trace.packet.header")) {
            return this.fPacketHeaderDef;
        }
        return null;
    }

    public void addStreamFile(File streamFile) throws CTFReaderException {
        this.openStreamInput(streamFile);
    }

    public void addStream(CTFStream stream) throws ParseException {
        if (this.fStreams.get(null) != null) {
            throw new ParseException("Stream without id with multiple streams");
        }
        if (stream.getId() == null && this.fStreams.size() != 0) {
            throw new ParseException("Stream without id with multiple streams");
        }
        CTFStream existingStream = this.fStreams.get(stream.getId());
        if (existingStream != null) {
            throw new ParseException("Stream id already exists");
        }
        this.fStreams.put(stream.getId(), stream);
    }

    public Map<String, String> getEnvironment() {
        return Collections.unmodifiableMap(this.fEnvironment);
    }

    public void addEnvironmentVar(String varName, String varValue) {
        this.fEnvironment.put(varName, varValue);
    }

    public void addClock(String nameValue, CTFClock ctfClock) {
        this.fClocks.put(nameValue, ctfClock);
    }

    public CTFClock getClock(String name) {
        return this.fClocks.get(name);
    }

    public final CTFClock getClock() {
        if (this.fClocks.size() == 1) {
            this.fSingleClock = this.fClocks.get(this.fClocks.keySet().iterator().next());
            return this.fSingleClock;
        }
        return null;
    }

    public final long getOffset() {
        if (this.getClock() == null) {
            return 0L;
        }
        return this.fSingleClock.getClockOffset();
    }

    private double getTimeScale() {
        if (this.getClock() == null) {
            return 1.0;
        }
        return this.fSingleClock.getClockScale();
    }

    public long getCurrentStartTime() {
        long currentStart = Long.MAX_VALUE;
        for (CTFStream stream : this.fStreams.values()) {
            for (CTFStreamInput si : stream.getStreamInputs()) {
                currentStart = Math.min(currentStart, si.getIndex().getEntries().get(0).getTimestampBegin());
            }
        }
        return this.timestampCyclesToNanos(currentStart);
    }

    public long getCurrentEndTime() {
        long currentEnd = Long.MIN_VALUE;
        for (CTFStream stream : this.fStreams.values()) {
            for (CTFStreamInput si : stream.getStreamInputs()) {
                currentEnd = Math.max(currentEnd, si.getTimestampEnd());
            }
        }
        return this.timestampCyclesToNanos(currentEnd);
    }

    private boolean clockNeedsScale() {
        if (this.getClock() == null) {
            return false;
        }
        return this.fSingleClock.isClockScaled();
    }

    private double getInverseTimeScale() {
        if (this.getClock() == null) {
            return 1.0;
        }
        return this.fSingleClock.getClockAntiScale();
    }

    public long timestampCyclesToNanos(long cycles) {
        long retVal = cycles + this.getOffset();
        if (this.clockNeedsScale()) {
            retVal = (long)((double)retVal * this.getTimeScale());
        }
        return retVal;
    }

    public long timestampNanoToCycles(long nanos) {
        long retVal = this.clockNeedsScale() ? (long)((double)nanos * this.getInverseTimeScale()) : nanos;
        return retVal - this.getOffset();
    }

    public void addCallsite(String eventName, String funcName, long ip, String fileName, long lineNumber) {
        CTFCallsite cs = new CTFCallsite(eventName, funcName, ip, fileName, lineNumber);
        TreeSet<CTFCallsite> csl = this.fCallsitesByName.get(eventName);
        if (csl == null) {
            csl = new TreeSet<CTFCallsite>(this.fCtfCallsiteComparator);
            this.fCallsitesByName.put(eventName, csl);
        }
        csl.add(cs);
        this.fCallsitesByIP.add(cs);
    }

    public TreeSet<CTFCallsite> getCallsiteCandidates(String eventName) {
        TreeSet<CTFCallsite> retVal = this.fCallsitesByName.get(eventName);
        if (retVal == null) {
            retVal = new TreeSet<CTFCallsite>(this.fCtfCallsiteComparator);
        }
        return retVal;
    }

    public CTFCallsite getCallsite(String eventName) {
        TreeSet<CTFCallsite> callsites = this.fCallsitesByName.get(eventName);
        if (callsites != null) {
            return callsites.first();
        }
        return null;
    }

    public CTFCallsite getCallsite(long ip) {
        CTFCallsite cs = new CTFCallsite(null, null, ip, null, 0L);
        return this.fCallsitesByIP.ceiling(cs);
    }

    public CTFCallsite getCallsite(String eventName, long ip) {
        TreeSet<CTFCallsite> candidates = this.fCallsitesByName.get(eventName);
        if (candidates == null) {
            return null;
        }
        CTFCallsite dummyCs = new CTFCallsite(null, null, ip, null, -1L);
        CTFCallsite callsite = candidates.ceiling(dummyCs);
        if (callsite == null) {
            return candidates.floor(dummyCs);
        }
        return callsite;
    }

    public void addStream(long id, File streamFile) throws CTFReaderException {
        CTFStream stream = null;
        if (this.fStreams.containsKey(id)) {
            stream = this.fStreams.get(id);
        } else {
            stream = new CTFStream(this);
            this.fStreams.put(id, stream);
        }
        stream.addInput(new CTFStreamInput(stream, streamFile));
    }
}

