/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.ctf.core.trace;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import java.util.UUID;
import org.antlr.runtime.ANTLRReaderStream;
import org.antlr.runtime.CharStream;
import org.antlr.runtime.CommonTokenStream;
import org.antlr.runtime.RecognitionException;
import org.antlr.runtime.TokenSource;
import org.antlr.runtime.TokenStream;
import org.antlr.runtime.tree.CommonTree;
import org.antlr.runtime.tree.RewriteCardinalityException;
import org.eclipse.linuxtools.ctf.core.trace.CTFReaderException;
import org.eclipse.linuxtools.ctf.core.trace.CTFTrace;
import org.eclipse.linuxtools.ctf.core.trace.Utils;
import org.eclipse.linuxtools.ctf.parser.CTFLexer;
import org.eclipse.linuxtools.ctf.parser.CTFParser;
import org.eclipse.linuxtools.internal.ctf.core.event.metadata.IOStructGen;
import org.eclipse.linuxtools.internal.ctf.core.event.metadata.exceptions.CtfAntlrException;
import org.eclipse.linuxtools.internal.ctf.core.event.metadata.exceptions.ParseException;

public class Metadata {
    private static final String METADATA_FILENAME = "metadata";
    private static final int METADATA_PACKET_HEADER_SIZE = 37;
    private ByteOrder detectedByteOrder = null;
    private final CTFTrace trace;
    private IOStructGen fTreeParser;

    public Metadata(CTFTrace trace) {
        this.trace = trace;
    }

    public Metadata() {
        this.trace = new CTFTrace();
    }

    public ByteOrder getDetectedByteOrder() {
        return this.detectedByteOrder;
    }

    public CTFTrace getTrace() {
        return this.trace;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void parseFile() throws CTFReaderException {
        try {
            Throwable throwable = null;
            Object var2_6 = null;
            try {
                FileInputStream fis = new FileInputStream(this.getMetadataPath());
                try {
                    block22: {
                        FileChannel metadataFileChannel = fis.getChannel();
                        try {
                            try (Reader metadataTextInput = this.isPacketBased(metadataFileChannel) ? this.readBinaryMetaData(metadataFileChannel) : new FileReader(this.getMetadataPath());){
                                this.readMetaDataText(metadataTextInput);
                            }
                            if (metadataFileChannel == null) break block22;
                        }
                        catch (Throwable throwable2) {
                            if (throwable == null) {
                                throwable = throwable2;
                            } else if (throwable != throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            if (metadataFileChannel == null) throw throwable;
                            metadataFileChannel.close();
                            throw throwable;
                        }
                        metadataFileChannel.close();
                    }
                    if (fis == null) return;
                }
                catch (Throwable throwable3) {
                    if (throwable == null) {
                        throwable = throwable3;
                    } else if (throwable != throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    if (fis == null) throw throwable;
                    fis.close();
                    throw throwable;
                }
                fis.close();
                return;
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                    throw throwable;
                }
                if (throwable == throwable4) throw throwable;
                throwable.addSuppressed(throwable4);
                throw throwable;
            }
        }
        catch (FileNotFoundException e) {
            throw new CTFReaderException("Cannot find metadata file!");
        }
        catch (IOException | ParseException e) {
            throw new CTFReaderException(e);
        }
        catch (RecognitionException | RewriteCardinalityException e) {
            throw new CtfAntlrException((Exception)e);
        }
    }

    private Reader readBinaryMetaData(FileChannel metadataFileChannel) throws CTFReaderException {
        StringBuffer metadataText = new StringBuffer();
        MetadataPacketHeader packetHeader = this.readMetadataPacket(metadataFileChannel, metadataText);
        while (packetHeader != null) {
            packetHeader = this.readMetadataPacket(metadataFileChannel, metadataText);
        }
        return new StringReader(metadataText.toString());
    }

    public void parseText(String data) throws CTFReaderException {
        StringReader metadataTextInput = new StringReader(data);
        try {
            this.readMetaDataText(metadataTextInput);
        }
        catch (IOException | ParseException e) {
            throw new CTFReaderException(e);
        }
        catch (RecognitionException | RewriteCardinalityException e) {
            throw new CtfAntlrException((Exception)e);
        }
    }

    private void readMetaDataText(Reader metadataTextInput) throws IOException, RecognitionException, ParseException {
        CommonTree tree = Metadata.createAST(metadataTextInput);
        this.fTreeParser = new IOStructGen(tree, this.trace);
        this.fTreeParser.generate();
    }

    public void parseTextFragment(String dataFragment) throws CTFReaderException {
        StringReader metadataTextInput = new StringReader(dataFragment);
        try {
            this.readMetaDataTextFragment(metadataTextInput);
        }
        catch (IOException | ParseException e) {
            throw new CTFReaderException(e);
        }
        catch (RecognitionException | RewriteCardinalityException e) {
            throw new CtfAntlrException((Exception)e);
        }
    }

    private void readMetaDataTextFragment(Reader metadataTextInput) throws IOException, RecognitionException, ParseException {
        CommonTree tree = Metadata.createAST(metadataTextInput);
        this.fTreeParser.setTree(tree);
        this.fTreeParser.generateFragment();
    }

    private static CommonTree createAST(Reader metadataTextInput) throws IOException, RecognitionException {
        ANTLRReaderStream antlrStream = new ANTLRReaderStream(metadataTextInput);
        CTFLexer ctfLexer = new CTFLexer((CharStream)antlrStream);
        CommonTokenStream tokens = new CommonTokenStream((TokenSource)ctfLexer);
        CTFParser ctfParser = new CTFParser((TokenStream)tokens, false);
        CTFParser.parse_return pr = ctfParser.parse();
        return pr.getTree();
    }

    private boolean isPacketBased(FileChannel metadataFileChannel) throws CTFReaderException {
        ByteBuffer magicByteBuffer = ByteBuffer.allocate(4);
        try {
            metadataFileChannel.read(magicByteBuffer, 0L);
        }
        catch (IOException e) {
            throw new CTFReaderException("Unable to read metadata file channel.", e);
        }
        int magic = magicByteBuffer.getInt(0);
        if (1976638807 == magic) {
            this.detectedByteOrder = ByteOrder.BIG_ENDIAN;
            return true;
        }
        magicByteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        magic = magicByteBuffer.getInt(0);
        if (1976638807 == magic) {
            this.detectedByteOrder = ByteOrder.LITTLE_ENDIAN;
            return true;
        }
        return false;
    }

    private String getMetadataPath() {
        if (this.trace.getTraceDirectory() == null) {
            return new String();
        }
        return String.valueOf(this.trace.getTraceDirectory().getPath()) + Utils.SEPARATOR + METADATA_FILENAME;
    }

    private MetadataPacketHeader readMetadataPacket(FileChannel metadataFileChannel, StringBuffer metadataText) throws CTFReaderException {
        int nbBytesRead;
        ByteBuffer headerByteBuffer;
        block11: {
            headerByteBuffer = ByteBuffer.allocate(37);
            try {
                nbBytesRead = metadataFileChannel.read(headerByteBuffer);
                if (nbBytesRead >= 0) break block11;
                return null;
            }
            catch (IOException e) {
                throw new CTFReaderException("Error reading the metadata header.", e);
            }
        }
        if (nbBytesRead != 37) {
            throw new CTFReaderException("Error reading the metadata header.");
        }
        headerByteBuffer.position(0);
        headerByteBuffer.order(this.detectedByteOrder);
        MetadataPacketHeader header = new MetadataPacketHeader(headerByteBuffer);
        if (!header.isMagicValid()) {
            throw new CTFReaderException("TSDL magic number does not match");
        }
        if (!this.trace.uuidIsSet()) {
            this.trace.setUUID(header.getUuid());
        } else if (!this.trace.getUUID().equals(header.getUuid())) {
            throw new CTFReaderException("UUID mismatch");
        }
        int payloadSize = header.getContentSize() / 8 - 37;
        if (payloadSize < 0) {
            throw new CTFReaderException("Invalid metadata packet payload size.");
        }
        int skipSize = (header.getPacketSize() - header.getContentSize()) / 8;
        ByteBuffer payloadByteBuffer = ByteBuffer.allocateDirect(payloadSize + skipSize);
        try {
            metadataFileChannel.read(payloadByteBuffer);
        }
        catch (IOException e) {
            throw new CTFReaderException("Error reading metadata packet payload.", e);
        }
        payloadByteBuffer.rewind();
        byte[] payloadByteArray = new byte[payloadByteBuffer.remaining()];
        payloadByteBuffer.get(payloadByteArray, 0, payloadSize);
        String str = new String(payloadByteArray, 0, payloadSize);
        metadataText.append(str);
        return header;
    }

    private static class MetadataPacketHeader {
        private final int fMagic;
        private final UUID fUuid;
        private final int fChecksum;
        private final int fContentSize;
        private final int fPacketSize;
        private final byte fCompressionScheme;
        private final byte fEncryptionScheme;
        private final byte fChecksumScheme;
        private final byte fCtfMajorVersion;
        private final byte fCtfMinorVersion;

        public MetadataPacketHeader(ByteBuffer headerByteBuffer) {
            this.fMagic = headerByteBuffer.getInt();
            byte[] uuidBytes = new byte[16];
            headerByteBuffer.get(uuidBytes);
            this.fUuid = Utils.makeUUID(uuidBytes);
            this.fChecksum = headerByteBuffer.getInt();
            this.fContentSize = headerByteBuffer.getInt();
            this.fPacketSize = headerByteBuffer.getInt();
            this.fCompressionScheme = headerByteBuffer.get();
            this.fEncryptionScheme = headerByteBuffer.get();
            this.fChecksumScheme = headerByteBuffer.get();
            this.fCtfMajorVersion = headerByteBuffer.get();
            this.fCtfMinorVersion = headerByteBuffer.get();
        }

        public boolean isMagicValid() {
            return this.fMagic == 1976638807;
        }

        public UUID getUuid() {
            return this.fUuid;
        }

        public int getContentSize() {
            return this.fContentSize;
        }

        public int getPacketSize() {
            return this.fPacketSize;
        }

        public String toString() {
            return "MetadataPacketHeader [magic=0x" + Integer.toHexString(this.fMagic) + ", uuid=" + this.fUuid.toString() + ", checksum=" + this.fChecksum + ", contentSize=" + this.fContentSize + ", packetSize=" + this.fPacketSize + ", compressionScheme=" + this.fCompressionScheme + ", encryptionScheme=" + this.fEncryptionScheme + ", checksumScheme=" + this.fChecksumScheme + ", ctfMajorVersion=" + this.fCtfMajorVersion + ", ctfMinorVersion=" + this.fCtfMinorVersion + ']';
        }
    }
}

