/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.ctf.core.trace;

import java.util.UUID;
import org.eclipse.linuxtools.ctf.core.event.types.ArrayDefinition;
import org.eclipse.linuxtools.ctf.core.event.types.IntegerDefinition;
import org.eclipse.linuxtools.ctf.core.trace.CTFReaderException;

public final class Utils {
    public static final int CTF_MAGIC = -1040441407;
    public static final int TSDL_MAGIC = 1976638807;
    public static final int TSDL_MAGIC_LEN = 4;
    public static final String SEPARATOR = System.getProperty("file.separator");
    public static final int UUID_LEN = 16;

    private Utils() {
    }

    public static int unsignedCompare(long left, long right) {
        long a = left + Long.MIN_VALUE;
        long b = right + Long.MIN_VALUE;
        if (a < b) {
            return -1;
        }
        if (a > b) {
            return 1;
        }
        return 0;
    }

    public static UUID getUUIDfromDefinition(ArrayDefinition uuidDef) throws CTFReaderException {
        byte[] uuidArray = new byte[16];
        int i = 0;
        while (i < uuidArray.length) {
            IntegerDefinition uuidByteDef = (IntegerDefinition)uuidDef.getElem(i);
            if (uuidByteDef == null) {
                throw new CTFReaderException("UUID incomplete, only " + i + " bytes available");
            }
            uuidArray[i] = (byte)uuidByteDef.getValue();
            ++i;
        }
        UUID uuid = Utils.makeUUID(uuidArray);
        return uuid;
    }

    public static UUID makeUUID(byte[] bytes) {
        long high = 0L;
        long low = 0L;
        assert (bytes.length == 16);
        int i = 0;
        while (i < 8) {
            low = low << 8 | (long)(bytes[i + 8] & 0xFF);
            high = high << 8 | (long)(bytes[i] & 0xFF);
            ++i;
        }
        UUID uuid = new UUID(high, low);
        return uuid;
    }
}

