/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.tmf.analysis.xml.core.module;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.linuxtools.internal.tmf.analysis.xml.core.Activator;
import org.eclipse.linuxtools.tmf.analysis.xml.core.module.Messages;
import org.eclipse.osgi.util.NLS;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class XmlUtils {
    private static final String XML_DIRECTORY = "xml_files";
    private static final String XSD = "xmlDefinition.xsd";

    private XmlUtils() {
    }

    public static IPath getXmlFilesPath() {
        IPath path = Activator.getDefault().getStateLocation();
        File dir = (path = path.addTrailingSeparator().append(XML_DIRECTORY)).toFile();
        if (!dir.exists() || !dir.isDirectory()) {
            dir.mkdirs();
        }
        return path;
    }

    public static IStatus xmlValidate(File xmlFile) {
        URL url = XmlUtils.class.getResource(XSD);
        SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        StreamSource xmlSource = new StreamSource(xmlFile);
        try {
            Schema schema = schemaFactory.newSchema(url);
            Validator validator = schema.newValidator();
            validator.validate(xmlSource);
        }
        catch (SAXParseException e) {
            String error = NLS.bind((String)Messages.XmlUtils_XmlParseError, (Object)e.getLineNumber(), (Object)e.getLocalizedMessage());
            Activator.logError(error);
            return new Status(4, "org.eclipse.linuxtools.tmf.analysis.xml.core", error, (Throwable)e);
        }
        catch (SAXException e) {
            String error = NLS.bind((String)Messages.XmlUtils_XmlValidationError, (Object)e.getLocalizedMessage());
            Activator.logError(error);
            return new Status(4, "org.eclipse.linuxtools.tmf.analysis.xml.core", error, (Throwable)e);
        }
        catch (IOException e) {
            String error = Messages.XmlUtils_XmlValidateError;
            Activator.logError("IO exception occurred", e);
            return new Status(4, "org.eclipse.linuxtools.tmf.analysis.xml.core", error, (Throwable)e);
        }
        return Status.OK_STATUS;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static IStatus addXmlFile(File fromFile) {
        File toFile = XmlUtils.getXmlFilesPath().addTrailingSeparator().append(fromFile.getName()).toFile();
        try {
            if (!toFile.exists()) {
                toFile.createNewFile();
            }
        }
        catch (IOException e) {
            String error2 = Messages.XmlUtils_ErrorCopyingFile;
            Activator.logError(error2, e);
            return new Status(4, "org.eclipse.linuxtools.tmf.analysis.xml.core", error2, (Throwable)e);
        }
        try {
            Throwable e = null;
            Object error2 = null;
            try {
                FileInputStream fis = new FileInputStream(fromFile);
                try {
                    block29: {
                        FileOutputStream fos = new FileOutputStream(toFile);
                        try {
                            block28: {
                                FileChannel source = fis.getChannel();
                                try {
                                    try (FileChannel destination = fos.getChannel();){
                                        destination.transferFrom(source, 0L, source.size());
                                    }
                                    if (source == null) break block28;
                                }
                                catch (Throwable error2) {
                                    if (e == null) {
                                        e = error2;
                                    } else if (e != error2) {
                                        e.addSuppressed(error2);
                                    }
                                    if (source == null) throw e;
                                    source.close();
                                    throw e;
                                }
                                source.close();
                            }
                            if (fos == null) break block29;
                        }
                        catch (Throwable error2) {
                            if (e == null) {
                                e = error2;
                            } else if (e != error2) {
                                e.addSuppressed(error2);
                            }
                            if (fos == null) throw e;
                            fos.close();
                            throw e;
                        }
                        fos.close();
                    }
                    if (fis == null) return Status.OK_STATUS;
                }
                catch (Throwable error2) {
                    if (e == null) {
                        e = error2;
                    } else if (e != error2) {
                        e.addSuppressed(error2);
                    }
                    if (fis == null) throw e;
                    fis.close();
                    throw e;
                }
                fis.close();
                return Status.OK_STATUS;
            }
            catch (Throwable error2) {
                if (e == null) {
                    e = error2;
                    throw e;
                }
                if (e == error2) throw e;
                e.addSuppressed(error2);
                throw e;
            }
        }
        catch (IOException e) {
            String error = Messages.XmlUtils_ErrorCopyingFile;
            Activator.logError(error, e);
            return new Status(4, "org.eclipse.linuxtools.tmf.analysis.xml.core", error, (Throwable)e);
        }
    }

    public static List<Element> getChildElements(Element parent) {
        NodeList childNodes = parent.getChildNodes();
        ArrayList<Element> childElements = new ArrayList<Element>();
        int index = 0;
        while (index < childNodes.getLength()) {
            if (childNodes.item(index).getNodeType() == 1) {
                childElements.add((Element)childNodes.item(index));
            }
            ++index;
        }
        return childElements;
    }

    public static List<Element> getChildElements(Element parent, String elementTag) {
        NodeList nodes = parent.getElementsByTagName(elementTag);
        ArrayList<Element> childElements = new ArrayList<Element>();
        int i = 0;
        while (i < nodes.getLength()) {
            Element node = (Element)nodes.item(i);
            if (node.getParentNode().equals(parent)) {
                childElements.add(node);
            }
            ++i;
        }
        return childElements;
    }

    public static Element getElementInFile(String filePath, @NonNull String elementType, @NonNull String elementId) {
        if (filePath == null) {
            return null;
        }
        Path path = new Path(filePath);
        File file = path.toFile();
        if (!(file != null && file.exists() && file.isFile() && XmlUtils.xmlValidate(file).isOK())) {
            return null;
        }
        try {
            DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
            Document doc = dBuilder.parse(file);
            doc.getDocumentElement().normalize();
            NodeList nodes = doc.getElementsByTagName(elementType);
            Element foundNode = null;
            int i = 0;
            while (i < nodes.getLength()) {
                Element node = (Element)nodes.item(i);
                String id = node.getAttribute("id");
                if (id.equals(elementId)) {
                    foundNode = node;
                }
                ++i;
            }
            return foundNode;
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            return null;
        }
    }
}

