/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.debug.core.pdi.request;

import org.eclipse.osgi.util.NLS;
import org.eclipse.ptp.debug.core.TaskSet;
import org.eclipse.ptp.debug.core.pdi.IPDIDebugger;
import org.eclipse.ptp.debug.core.pdi.PDIException;
import org.eclipse.ptp.debug.core.pdi.model.aif.IAIF;
import org.eclipse.ptp.debug.core.pdi.request.IPDIEvaluatePartialExpressionRequest;
import org.eclipse.ptp.internal.debug.core.pdi.messages.Messages;
import org.eclipse.ptp.internal.debug.core.pdi.request.AbstractEventResultRequest;

public abstract class AbstractEvaluatePartialExpressionRequest
extends AbstractEventResultRequest
implements IPDIEvaluatePartialExpressionRequest {
    private final String fExpr;
    private final String fExprId;
    private boolean fListChildren = false;

    public AbstractEvaluatePartialExpressionRequest(TaskSet tasks, String expr, String exprId, boolean listChildren) {
        super(tasks);
        this.fExpr = expr;
        this.fExprId = exprId;
        this.fListChildren = listChildren;
    }

    @Override
    public void doExecute(IPDIDebugger debugger) throws PDIException {
        debugger.evaluatePartialExpression(this.tasks, this.fExpr, this.fExprId, this.fListChildren, false);
    }

    @Override
    public String getName() {
        return Messages.AbstractEvaluatePartialExpressionRequest_0;
    }

    @Override
    public IAIF getPartialAIF(TaskSet qTasks) throws PDIException {
        this.waitUntilCompleted(qTasks);
        Object obj = this.getResult(qTasks);
        if (obj instanceof Object[]) {
            Object[] returnValues = (Object[])obj;
            return (IAIF)returnValues[1];
        }
        throw new PDIException(qTasks, NLS.bind((String)Messages.AbstractEvaluatePartialExpressionRequest_1, (Object)this.fExpr));
    }

    @Override
    public String getId(TaskSet qTasks) throws PDIException {
        this.waitUntilCompleted(qTasks);
        Object obj = this.getResult(qTasks);
        if (obj instanceof Object[]) {
            Object[] returnValues = (Object[])obj;
            return (String)returnValues[0];
        }
        throw new PDIException(qTasks, NLS.bind((String)Messages.AbstractEvaluatePartialExpressionRequest_2, (Object)this.fExprId));
    }

    @Override
    public String toString() {
        return NLS.bind((String)Messages.AbstractEvaluatePartialExpressionRequest_3, (Object[])new Object[]{this.getName(), this.getTasks(), this.fExpr, this.fExprId, this.fListChildren, false});
    }
}

