/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.synchronize;

import java.net.URISyntaxException;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.egit.core.synchronize.dto.GitSynchronizeData;
import org.eclipse.egit.core.synchronize.dto.GitSynchronizeDataSet;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.egit.ui.internal.credentials.EGitCredentialsProvider;
import org.eclipse.egit.ui.internal.fetch.FetchOperationUI;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.StoredConfig;
import org.eclipse.jgit.transport.RemoteConfig;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

class SynchronizeFetchJob
extends WorkspaceJob {
    private final int timeout;
    private final GitSynchronizeDataSet gsdSet;

    SynchronizeFetchJob(GitSynchronizeDataSet gsdSet) {
        super(UIText.SynchronizeFetchJob_JobName);
        this.gsdSet = gsdSet;
        this.timeout = Activator.getDefault().getPreferenceStore().getInt("remote_connection_timeout");
    }

    public IStatus runInWorkspace(IProgressMonitor monitor) {
        monitor.beginTask(UIText.SynchronizeFetchJob_TaskName, this.gsdSet.size());
        for (GitSynchronizeData gsd : this.gsdSet) {
            RemoteConfig config;
            Repository repo = gsd.getRepository();
            StoredConfig repoConfig = repo.getConfig();
            String remoteName = gsd.getDstRemoteName();
            if (remoteName == null) continue;
            monitor.subTask(NLS.bind((String)UIText.SynchronizeFetchJob_SubTaskName, (Object)remoteName));
            try {
                config = new RemoteConfig((Config)repoConfig, remoteName);
            }
            catch (URISyntaxException e) {
                Activator.logError(e.getMessage(), e);
                continue;
            }
            FetchOperationUI fetchOperationUI = new FetchOperationUI(repo, config, this.timeout, false);
            fetchOperationUI.setCredentialsProvider(new EGitCredentialsProvider());
            SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor);
            try {
                fetchOperationUI.execute((IProgressMonitor)subMonitor);
                gsd.updateRevs();
            }
            catch (Exception e) {
                this.showInformationDialog(remoteName);
                Activator.logError(e.getMessage(), e);
            }
            monitor.worked(1);
        }
        monitor.done();
        return Status.OK_STATUS;
    }

    private void showInformationDialog(final String remoteName) {
        final Display display = PlatformUI.getWorkbench().getDisplay();
        display.syncExec(new Runnable(){

            public void run() {
                MessageDialog.openInformation((Shell)display.getActiveShell(), (String)NLS.bind((String)UIText.SynchronizeFetchJob_FetchFailedTitle, (Object)remoteName), (String)NLS.bind((String)UIText.SynchronizeFetchJob_FetchFailedMessage, (Object)UIText.GitPreferenceRoot_fetchBeforeSynchronization));
            }
        });
    }
}

