/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.rdt.core.serviceproviders;

import org.eclipse.ptp.internal.rdt.core.callhierarchy.ICallHierarchyService;
import org.eclipse.ptp.internal.rdt.core.callhierarchy.RemoteCallHierarchyService;
import org.eclipse.ptp.internal.rdt.core.includebrowser.IIncludeBrowserService;
import org.eclipse.ptp.internal.rdt.core.includebrowser.RemoteIncludeBrowserService;
import org.eclipse.ptp.internal.rdt.core.index.IIndexLifecycleService;
import org.eclipse.ptp.internal.rdt.core.index.RemoteIndexLifecycleService;
import org.eclipse.ptp.internal.rdt.core.model.IModelBuilderService;
import org.eclipse.ptp.internal.rdt.core.model.RemoteModelBuilderService;
import org.eclipse.ptp.internal.rdt.core.typehierarchy.ITypeHierarchyService;
import org.eclipse.ptp.internal.rdt.core.typehierarchy.RemoteTypeHierarchyService;
import org.eclipse.ptp.rdt.core.messages.Messages;
import org.eclipse.ptp.rdt.core.serviceproviders.IIndexServiceProvider;
import org.eclipse.ptp.services.core.ServiceProvider;
import org.eclipse.rse.core.model.IHost;
import org.eclipse.rse.core.subsystems.IConnectorService;

public abstract class AbstractRemoteCIndexServiceProvider
extends ServiceProvider
implements IIndexServiceProvider {
    protected boolean fIsConfigured;
    protected IHost fHost;
    protected IConnectorService fConnectorService;
    protected IIndexLifecycleService fIndexLifecycleService;
    protected ICallHierarchyService fCallHierarchyService;
    protected ITypeHierarchyService fTypeHierarchyService;
    protected IIncludeBrowserService fIncludeBrowserService;
    protected IModelBuilderService fModelBuilderService;
    protected String indexLocation;
    public static final String ID = "org.eclipse.ptp.rdt.core.RemoteCIndexServiceProvider";
    public static final String NAME = Messages.RemoteCIndexServiceProvider_0;
    public static final String SERVICE_ID = "org.eclipse.ptp.rdt.core.CIndexingService";
    public static final String HOST_NAME_KEY = "host-name";
    public static final String INDEX_LOCATION_KEY = "index-location";

    @Override
    public synchronized ICallHierarchyService getCallHierarchyService() {
        if (!this.isConfigured()) {
            return null;
        }
        if (this.fCallHierarchyService == null) {
            this.fCallHierarchyService = new RemoteCallHierarchyService(this.fConnectorService);
        }
        return this.fCallHierarchyService;
    }

    public IHost getHost() {
        return this.fHost;
    }

    @Override
    public synchronized IIncludeBrowserService getIncludeBrowserService() {
        if (!this.isConfigured()) {
            return null;
        }
        if (this.fIncludeBrowserService == null) {
            this.fIncludeBrowserService = new RemoteIncludeBrowserService(this.fConnectorService);
        }
        return this.fIncludeBrowserService;
    }

    @Override
    public synchronized IIndexLifecycleService getIndexLifeCycleService() {
        if (!this.isConfigured()) {
            return null;
        }
        if (this.fIndexLifecycleService == null) {
            this.fIndexLifecycleService = new RemoteIndexLifecycleService(this.fConnectorService);
        }
        return this.fIndexLifecycleService;
    }

    @Override
    public synchronized IModelBuilderService getModelBuilderService() {
        if (!this.isConfigured()) {
            return null;
        }
        if (this.fModelBuilderService == null) {
            this.fModelBuilderService = new RemoteModelBuilderService(this.fConnectorService);
        }
        return this.fModelBuilderService;
    }

    @Override
    public synchronized ITypeHierarchyService getTypeHierarchyService() {
        if (!this.isConfigured()) {
            return null;
        }
        if (this.fTypeHierarchyService == null) {
            this.fTypeHierarchyService = new RemoteTypeHierarchyService(this.fConnectorService);
        }
        return this.fTypeHierarchyService;
    }

    public boolean isConfigured() {
        return this.fIsConfigured;
    }

    public void setConfigured(boolean isConfigured) {
        this.fIsConfigured = isConfigured;
    }

    public void setConnection(IHost host, IConnectorService connectorService) {
        this.fHost = host;
        this.fConnectorService = connectorService;
        this.setHostName(host.getAliasName());
        this.setConfigured(true);
    }

    public void setHostName(String hostName) {
        this.putString(HOST_NAME_KEY, hostName);
    }

    public String getHostName() {
        return this.getString(HOST_NAME_KEY, null);
    }

    @Override
    public void setIndexLocation(String path) {
        this.putString(INDEX_LOCATION_KEY, path);
    }

    @Override
    public String getIndexLocation() {
        return this.getString(INDEX_LOCATION_KEY, null);
    }
}

