/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.oprofile.core;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.linuxtools.internal.oprofile.core.OpcontrolException;
import org.eclipse.linuxtools.internal.oprofile.core.OprofileCorePlugin;
import org.eclipse.linuxtools.internal.oprofile.core.OprofileProperties;
import org.eclipse.linuxtools.internal.oprofile.core.daemon.OpEvent;
import org.eclipse.linuxtools.internal.oprofile.core.daemon.OpInfo;
import org.eclipse.linuxtools.internal.oprofile.core.model.OpModelImage;
import org.eclipse.linuxtools.internal.oprofile.core.model.OpModelSession;
import org.eclipse.linuxtools.profiling.launch.IRemoteFileProxy;
import org.eclipse.linuxtools.profiling.launch.RemoteProxyManager;
import org.eclipse.linuxtools.tools.launch.core.factory.RuntimeProcessFactory;

public class Oprofile {
    private static final String[] OPROFILE_CPU_TYPE_FILES = new String[]{"/dev/oprofile/cpu_type", "/proc/sys/dev/oprofile/cpu_type"};
    private static OpInfo info;

    static {
        Oprofile.initializeOprofileModule();
    }

    private static void initializeOprofileModule() {
        if (!Oprofile.isKernelModuleLoaded()) {
            Oprofile.initializeOprofile();
        }
        if (Oprofile.isKernelModuleLoaded()) {
            Oprofile.initializeOprofileCore();
        }
    }

    private static boolean isKernelModuleLoaded() {
        IRemoteFileProxy proxy = null;
        try {
            proxy = RemoteProxyManager.getInstance().getFileProxy(OprofileProject.getProject());
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        int i = 0;
        while (i < OPROFILE_CPU_TYPE_FILES.length) {
            IFileStore f = proxy.getResource(OPROFILE_CPU_TYPE_FILES[i]);
            if (f.fetchInfo().exists()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private static void initializeOprofile() {
        if (OprofileProject.getProfilingBinary().equals("opcontrol")) {
            try {
                OprofileCorePlugin.getDefault().getOpcontrolProvider().initModule();
            }
            catch (OpcontrolException opcontrolException) {
                // empty catch block
            }
        }
    }

    private static void initializeOprofileCore() {
        info = OpInfo.getInfo();
        if (info == null) {
            throw new ExceptionInInitializerError(OprofileProperties.getString("fatal.opinfoNotParsed"));
        }
    }

    public static int getNumberOfCounters() {
        if (!Oprofile.isKernelModuleLoaded() && OprofileProject.getProfilingBinary().equals("opcontrol")) {
            return 0;
        }
        try {
            Process p = RuntimeProcessFactory.getFactory().exec(new String[]{"operf", "--version"}, OprofileProject.getProject());
            if (p == null) {
                return 0;
            }
        }
        catch (IOException e) {
            return 0;
        }
        return info.getNrCounters();
    }

    public static double getCpuFrequency() {
        return info.getCPUSpeed();
    }

    public static OpEvent[] getEvents(int num) {
        return info.getEvents(num);
    }

    public static String getDefaultSamplesDirectory() {
        return info.getDefault("sample-dir");
    }

    public static String getLogFile() {
        return info.getDefault("log-file");
    }

    public static boolean getTimerMode() {
        if (OprofileProject.getProfilingBinary().equals("operf")) {
            return false;
        }
        return info.getTimerMode();
    }

    public static Boolean checkEvent(int ctr, String event, int um) {
        int[] validResult = new int[1];
        try {
            IRunnableWithProgress opxml = OprofileCorePlugin.getDefault().getOpxmlProvider().checkEvents(ctr, event, um, validResult);
            opxml.run(null);
        }
        catch (InterruptedException | InvocationTargetException exception) {
            // empty catch block
        }
        if (validResult[0] == 1) {
            return true;
        }
        return false;
    }

    public static OpModelSession[] getSessions() {
        OpModelSession[] events = null;
        ArrayList<OpModelSession> sessionList = new ArrayList<OpModelSession>();
        try {
            IRunnableWithProgress opxml = OprofileCorePlugin.getDefault().getOpxmlProvider().sessions(sessionList);
            opxml.run(null);
            events = new OpModelSession[sessionList.size()];
            sessionList.toArray(events);
        }
        catch (InterruptedException | InvocationTargetException exception) {
            // empty catch block
        }
        return events;
    }

    public static OpModelImage getModelData(String eventName, String sessionName) {
        OpModelImage image = new OpModelImage();
        try {
            IRunnableWithProgress opxml = OprofileCorePlugin.getDefault().getOpxmlProvider().modelData(eventName, sessionName, image);
            opxml.run(null);
        }
        catch (InterruptedException | InvocationTargetException exception) {
            // empty catch block
        }
        return image;
    }

    public static void updateInfo() {
        info = OpInfo.getInfo();
    }

    public static class OprofileProject {
        private static IProject project;
        public static final String OPERF_BINARY = "operf";
        public static final String OPCONTROL_BINARY = "opcontrol";
        private static String binary;
        public static final String OPERF_DATA = "oprofile_data";

        static {
            binary = OPCONTROL_BINARY;
        }

        public static void setProject(IProject project) {
            OprofileProject.project = project;
        }

        public static IProject getProject() {
            return project;
        }

        public static void setProfilingBinary(String binary) {
            OprofileProject.binary = binary;
        }

        public static String getProfilingBinary() {
            return binary;
        }
    }
}

