/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.intro.universal.contentdetect;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.Platform;
import org.eclipse.ui.internal.intro.universal.contentdetect.ContentDetectHelper;
import org.eclipse.ui.intro.IntroContentDetector;

public class ContentDetector
extends IntroContentDetector {
    private static Set newContributors;
    private static boolean detectorCalled;

    static {
        detectorCalled = false;
    }

    public boolean isNewContentAvailable() {
        block6: {
            HashSet<String> contributors;
            ContentDetectHelper helper;
            block7: {
                block5: {
                    detectorCalled = true;
                    if (newContributors == null || newContributors.isEmpty()) break block5;
                    return true;
                }
                try {
                    IExtension[] extensions = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.ui.intro.configExtension").getExtensions();
                    int numIntroExtensions = extensions.length;
                    helper = new ContentDetectHelper();
                    int previous = helper.getExtensionCount();
                    if (numIntroExtensions == previous) break block6;
                    helper.saveExtensionCount(numIntroExtensions);
                    contributors = new HashSet<String>();
                    int i = 0;
                    while (i < extensions.length) {
                        contributors.add(extensions[i].getContributor().getName());
                        ++i;
                    }
                    if (numIntroExtensions <= previous || previous == -1) break block7;
                    Set previousContributors = helper.getContributors();
                    newContributors = helper.findNewContributors(contributors, previousContributors);
                    helper.saveContributors(contributors);
                    return true;
                }
                catch (Exception exception) {
                    return false;
                }
            }
            helper.saveContributors(contributors);
        }
        newContributors = new HashSet();
        return false;
    }

    public static Set getNewContributors() {
        if (!detectorCalled) {
            detectorCalled = true;
            new ContentDetector().isNewContentAvailable();
        }
        return newContributors;
    }

    public static boolean isNew(String contributionId) {
        if (!detectorCalled) {
            detectorCalled = true;
            new ContentDetector().isNewContentAvailable();
        }
        return newContributors != null && newContributors.contains(contributionId);
    }
}

