/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.tmf.core.analysis;

import org.eclipse.linuxtools.tmf.core.analysis.IAnalysisModule;
import org.eclipse.linuxtools.tmf.core.analysis.IAnalysisOutput;
import org.eclipse.linuxtools.tmf.core.analysis.ITmfNewAnalysisModuleListener;

public class TmfNewAnalysisOutputListener
implements ITmfNewAnalysisModuleListener {
    private final String fAnalysisId;
    private final Class<? extends IAnalysisModule> fAnalysisModuleClass;
    private final IAnalysisOutput fOutput;

    public TmfNewAnalysisOutputListener(IAnalysisOutput output, String analysisId, Class<? extends IAnalysisModule> moduleClass) {
        this.fOutput = output;
        this.fAnalysisId = analysisId;
        this.fAnalysisModuleClass = moduleClass;
    }

    @Override
    public void moduleCreated(IAnalysisModule module) {
        if (this.fAnalysisId != null) {
            if (module.getId().equals(this.fAnalysisId)) {
                module.registerOutput(this.fOutput);
            }
        } else if (this.fAnalysisModuleClass != null && this.fAnalysisModuleClass.isAssignableFrom(module.getClass())) {
            module.registerOutput(this.fOutput);
        }
    }
}

