/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.tmf.core.project.model;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.linuxtools.tmf.core.project.model.TmfTraceType;
import org.eclipse.linuxtools.tmf.core.trace.ITmfTrace;
import org.eclipse.linuxtools.tmf.core.trace.TraceValidationStatus;

public class TraceTypeHelper {
    private final String fName;
    private final String fCategoryName;
    private final String fCanonicalName;
    private final TmfTraceType.TraceElementType fElementType;
    @NonNull
    private final ITmfTrace fTrace;
    private final boolean fIsDirectory;

    public TraceTypeHelper(String canonicalName, String categoryName, String name, @NonNull ITmfTrace trace, boolean isDir, TmfTraceType.TraceElementType elementType) {
        this.fName = name;
        this.fCategoryName = categoryName;
        this.fCanonicalName = canonicalName;
        this.fTrace = trace;
        this.fIsDirectory = isDir;
        this.fElementType = elementType;
    }

    public String getName() {
        return this.fName;
    }

    public String getCategoryName() {
        return this.fCategoryName;
    }

    public String getCanonicalName() {
        return this.fCanonicalName;
    }

    public IStatus validate(String path) {
        return this.fTrace.validate(null, path);
    }

    public int validateWithConfidence(String path) {
        int result = -1;
        IStatus status = this.fTrace.validate(null, path);
        if (status.isOK()) {
            result = 0;
            if (status instanceof TraceValidationStatus) {
                result = ((TraceValidationStatus)status).getConfidence();
            }
        }
        return result;
    }

    public ITmfTrace getTrace() {
        return this.fTrace;
    }

    public boolean isExperimentType() {
        return this.fElementType == TmfTraceType.TraceElementType.EXPERIMENT;
    }

    public Class<? extends ITmfTrace> getTraceClass() {
        return this.fTrace.getClass();
    }

    public boolean isDirectoryTraceType() {
        return this.fIsDirectory;
    }

    public String toString() {
        return this.fName;
    }
}

