/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.tmf.core.trace.indexer.checkpoint;

import java.nio.ByteBuffer;
import org.eclipse.linuxtools.tmf.core.timestamp.ITmfTimestamp;
import org.eclipse.linuxtools.tmf.core.timestamp.TmfTimestamp;
import org.eclipse.linuxtools.tmf.core.trace.indexer.checkpoint.ITmfCheckpoint;
import org.eclipse.linuxtools.tmf.core.trace.location.ITmfLocation;

public class TmfCheckpoint
implements ITmfCheckpoint {
    private final ITmfLocation fLocation;
    private final ITmfTimestamp fTimestamp;
    private final long fCheckpointRank;

    public TmfCheckpoint(ITmfTimestamp timestamp, ITmfLocation location, long checkpointRank) {
        this.fTimestamp = timestamp;
        this.fLocation = location;
        this.fCheckpointRank = checkpointRank;
    }

    public TmfCheckpoint(ITmfTimestamp timestamp, ITmfLocation location, ByteBuffer bufferIn) {
        this.fTimestamp = timestamp;
        this.fLocation = location;
        this.fCheckpointRank = bufferIn.getLong();
    }

    public TmfCheckpoint(TmfCheckpoint other) {
        if (other == null) {
            throw new IllegalArgumentException();
        }
        this.fTimestamp = other.fTimestamp;
        this.fLocation = other.fLocation;
        this.fCheckpointRank = other.fCheckpointRank;
    }

    @Override
    public ITmfTimestamp getTimestamp() {
        return this.fTimestamp;
    }

    @Override
    public ITmfLocation getLocation() {
        return this.fLocation;
    }

    @Override
    public int compareTo(ITmfCheckpoint other) {
        int comp = 0;
        if (this.fTimestamp != null && other.getTimestamp() != null && (comp = this.fTimestamp.compareTo(other.getTimestamp(), false)) != 0) {
            return comp;
        }
        if (this.fLocation == null && other.getLocation() == null) {
            return 0;
        }
        if (this.fLocation != null && other.getLocation() == null) {
            return 1;
        }
        if (this.fLocation == null && other.getLocation() != null) {
            return -1;
        }
        Comparable<?> location1 = this.getLocation().getLocationInfo();
        Comparable<?> location2 = other.getLocation().getLocationInfo();
        return location1.compareTo(location2);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.fLocation == null ? 0 : this.fLocation.hashCode());
        result = 31 * result + (this.fTimestamp == null ? 0 : this.fTimestamp.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TmfCheckpoint)) {
            return false;
        }
        TmfCheckpoint other = (TmfCheckpoint)obj;
        if (this.fLocation == null ? other.fLocation != null : !this.fLocation.equals(other.fLocation)) {
            return false;
        }
        return !(this.fTimestamp == null ? other.fTimestamp != null : !this.fTimestamp.equals(other.fTimestamp));
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + " [fLocation=" + this.fLocation + ", fTimestamp=" + this.fTimestamp + ", fCheckpointRank=" + this.fCheckpointRank + "]";
    }

    @Override
    public void serialize(ByteBuffer bufferOut) {
        this.fLocation.serialize(bufferOut);
        TmfTimestamp t = new TmfTimestamp(this.fTimestamp);
        t.serialize(bufferOut);
        bufferOut.putLong(this.fCheckpointRank);
    }

    @Override
    public long getCheckpointRank() {
        return this.fCheckpointRank;
    }
}

