/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.tmf.core.trace.text;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.linuxtools.internal.tmf.core.Activator;
import org.eclipse.linuxtools.tmf.core.event.ITmfEvent;
import org.eclipse.linuxtools.tmf.core.event.TmfEvent;
import org.eclipse.linuxtools.tmf.core.exceptions.TmfTraceException;
import org.eclipse.linuxtools.tmf.core.io.BufferedRandomAccessFile;
import org.eclipse.linuxtools.tmf.core.timestamp.TmfTimestamp;
import org.eclipse.linuxtools.tmf.core.trace.ITmfContext;
import org.eclipse.linuxtools.tmf.core.trace.ITmfEventParser;
import org.eclipse.linuxtools.tmf.core.trace.TmfTrace;
import org.eclipse.linuxtools.tmf.core.trace.TraceValidationStatus;
import org.eclipse.linuxtools.tmf.core.trace.indexer.ITmfPersistentlyIndexable;
import org.eclipse.linuxtools.tmf.core.trace.indexer.ITmfTraceIndexer;
import org.eclipse.linuxtools.tmf.core.trace.indexer.TmfBTreeTraceIndexer;
import org.eclipse.linuxtools.tmf.core.trace.indexer.checkpoint.TmfCheckpoint;
import org.eclipse.linuxtools.tmf.core.trace.location.ITmfLocation;
import org.eclipse.linuxtools.tmf.core.trace.location.TmfLongLocation;
import org.eclipse.linuxtools.tmf.core.trace.text.TextTraceContext;
import org.eclipse.linuxtools.tmf.core.trace.text.TextTraceEvent;

public abstract class TextTrace<T extends TextTraceEvent>
extends TmfTrace
implements ITmfEventParser,
ITmfPersistentlyIndexable {
    private static final TmfLongLocation NULL_LOCATION = new TmfLongLocation(-1L);
    private static final int MAX_LINES = 100;
    private static final int MAX_CONFIDENCE = 100;
    protected static final String SEPARATOR = " | ";
    protected BufferedRandomAccessFile fFile;
    private static int fCheckpointSize = -1;

    @Override
    public IStatus validate(IProject project, String path) {
        File file = new File(path);
        if (!file.exists()) {
            return new Status(4, "org.eclipse.linuxtools.tmf.core", "File not found: " + path);
        }
        if (!file.isFile()) {
            return new Status(4, "org.eclipse.linuxtools.tmf.core", "Not a file. It's a directory: " + path);
        }
        int confidence = 0;
        try {
            Throwable throwable = null;
            Object var6_8 = null;
            try (BufferedRandomAccessFile rafile = new BufferedRandomAccessFile(path, "r");){
                int lineCount = 0;
                int matches = 0;
                String line = rafile.getNextLine();
                while (line != null && lineCount++ < 100) {
                    Matcher matcher = this.getFirstLinePattern().matcher(line);
                    if (matcher.matches()) {
                        ++matches;
                    }
                    confidence = 100 * matches / lineCount;
                    line = rafile.getNextLine();
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            Activator.logError("Error validating file: " + path, e);
            return new Status(4, "org.eclipse.linuxtools.tmf.core", "IOException validating file: " + path, (Throwable)e);
        }
        return new TraceValidationStatus(confidence, "org.eclipse.linuxtools.tmf.core");
    }

    @Override
    public void initTrace(IResource resource, String path, Class<? extends ITmfEvent> type) throws TmfTraceException {
        super.initTrace(resource, path, type);
        try {
            this.fFile = new BufferedRandomAccessFile(this.getPath(), "r");
        }
        catch (IOException e) {
            throw new TmfTraceException(e.getMessage(), e);
        }
    }

    @Override
    public synchronized void dispose() {
        super.dispose();
        if (this.fFile != null) {
            try {
                try {
                    this.fFile.close();
                }
                catch (IOException iOException) {
                    this.fFile = null;
                }
            }
            finally {
                this.fFile = null;
            }
        }
    }

    @Override
    public synchronized TextTraceContext seekEvent(ITmfLocation location) {
        TextTraceContext context = new TextTraceContext(NULL_LOCATION, -1L);
        if (NULL_LOCATION.equals(location) || this.fFile == null) {
            return context;
        }
        try {
            if (location == null) {
                this.fFile.seek(0L);
            } else if (location.getLocationInfo() instanceof Long) {
                this.fFile.seek((Long)location.getLocationInfo());
            }
            long rawPos = this.fFile.getFilePointer();
            String line = this.fFile.getNextLine();
            while (line != null) {
                Matcher matcher = this.getFirstLinePattern().matcher(line);
                if (matcher.matches()) {
                    this.setupContext(context, rawPos, line, matcher);
                    return context;
                }
                rawPos = this.fFile.getFilePointer();
                line = this.fFile.getNextLine();
            }
            return context;
        }
        catch (IOException e) {
            Activator.logError("Error seeking file: " + this.getPath(), e);
            return context;
        }
    }

    private void setupContext(TextTraceContext context, long rawPos, String line, Matcher matcher) throws IOException {
        context.setLocation(new TmfLongLocation(rawPos));
        context.firstLineMatcher = matcher;
        context.firstLine = line;
        context.nextLineLocation = this.fFile.getFilePointer();
    }

    @Override
    public synchronized TextTraceContext seekEvent(double ratio) {
        if (this.fFile == null) {
            return new TextTraceContext(NULL_LOCATION, -1L);
        }
        try {
            long pos = (long)(ratio * (double)this.fFile.length());
            while (pos > 0L) {
                this.fFile.seek(pos - 1L);
                if (this.fFile.read() == 10) break;
                --pos;
            }
            TmfLongLocation location = new TmfLongLocation((Long)pos);
            TextTraceContext context = this.seekEvent(location);
            context.setRank(-1L);
            return context;
        }
        catch (IOException e) {
            Activator.logError("Error seeking file: " + this.getPath(), e);
            return new TextTraceContext(NULL_LOCATION, -1L);
        }
    }

    @Override
    public double getLocationRatio(ITmfLocation location) {
        long length;
        block5: {
            if (this.fFile == null) {
                return 0.0;
            }
            length = this.fFile.length();
            if (length != 0L) break block5;
            return 0.0;
        }
        try {
            if (location.getLocationInfo() instanceof Long) {
                return (double)((Long)location.getLocationInfo()).longValue() / (double)length;
            }
        }
        catch (IOException e) {
            Activator.logError("Error reading file: " + this.getPath(), e);
        }
        return 0.0;
    }

    @Override
    public ITmfLocation getCurrentLocation() {
        return null;
    }

    @Override
    public TextTraceEvent parseEvent(ITmfContext tmfContext) {
        TextTraceContext context = this.seekEvent(tmfContext.getLocation());
        return this.parse(context);
    }

    public synchronized T getNext(ITmfContext context) {
        if (!(context instanceof TextTraceContext)) {
            throw new IllegalArgumentException();
        }
        TextTraceContext savedContext = new TextTraceContext(context.getLocation(), context.getRank());
        T event = this.parse((TextTraceContext)context);
        if (event != null) {
            this.updateAttributes(savedContext, ((TmfEvent)event).getTimestamp());
            context.increaseRank();
        }
        return event;
    }

    protected synchronized T parse(TextTraceContext tmfContext) {
        if (this.fFile == null) {
            return null;
        }
        TextTraceContext context = tmfContext;
        if (context.getLocation() == null || !(context.getLocation().getLocationInfo() instanceof Long) || NULL_LOCATION.equals(context.getLocation())) {
            return null;
        }
        T event = this.parseFirstLine(context.firstLineMatcher, context.firstLine);
        try {
            if (this.fFile.getFilePointer() != context.nextLineLocation) {
                this.fFile.seek(context.nextLineLocation);
            }
            long rawPos = this.fFile.getFilePointer();
            String line = this.fFile.getNextLine();
            while (line != null) {
                Matcher matcher = this.getFirstLinePattern().matcher(line);
                if (matcher.matches()) {
                    this.setupContext(context, rawPos, line, matcher);
                    return event;
                }
                this.parseNextLine(event, line);
                rawPos = this.fFile.getFilePointer();
                line = this.fFile.getNextLine();
            }
        }
        catch (IOException e) {
            Activator.logError("Error reading file: " + this.getPath(), e);
        }
        context.setLocation(NULL_LOCATION);
        return event;
    }

    protected abstract Pattern getFirstLinePattern();

    protected abstract T parseFirstLine(Matcher var1, String var2);

    protected abstract void parseNextLine(T var1, String var2);

    protected static String replaceQuotes(String input) {
        String out = input.replaceAll("^\"|(\"\\s*)$", "");
        return out;
    }

    protected static String replaceBrackets(String input) {
        String out = input.replaceAll("^\\{|(\\}\\s*)$", "");
        return out;
    }

    @Override
    public synchronized int getCheckpointSize() {
        if (fCheckpointSize == -1) {
            TmfCheckpoint c = new TmfCheckpoint(TmfTimestamp.ZERO, (ITmfLocation)new TmfLongLocation(0L), 0L);
            ByteBuffer b = ByteBuffer.allocate(1024);
            b.clear();
            c.serialize(b);
            fCheckpointSize = b.position();
        }
        return fCheckpointSize;
    }

    @Override
    protected ITmfTraceIndexer createIndexer(int interval) {
        return new TmfBTreeTraceIndexer(this, interval);
    }

    @Override
    public ITmfLocation restoreLocation(ByteBuffer bufferIn) {
        return new TmfLongLocation(bufferIn);
    }
}

