/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.themes;

import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import org.eclipse.e4.ui.internal.css.swt.definition.IThemeElementDefinitionOverridable;
import org.eclipse.e4.ui.internal.css.swt.definition.IThemesExtension;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.themes.ColorDefinition;
import org.eclipse.ui.internal.themes.FontDefinition;
import org.eclipse.ui.internal.themes.Theme;

public class ThemesExtension
implements IThemesExtension {
    public static final String DEFAULT_CATEGORY_ID = "org.eclipse.ui.themes.CssTheme";
    private String description;
    private List<IThemeElementDefinitionOverridable<?>> definitions = new ArrayList();

    public void addFontDefinition(String symbolicName) {
        FontDefinition definition = new FontDefinition(this.formatDefaultName(FontDefinition.class, symbolicName), symbolicName, null, null, DEFAULT_CATEGORY_ID, true, this.getDefaultDescription());
        definition.appendState(2);
        this.definitions.add((IThemeElementDefinitionOverridable<?>)definition);
    }

    public void addColorDefinition(String symbolicName) {
        ColorDefinition definition = new ColorDefinition(this.formatDefaultName(ColorDefinition.class, symbolicName), symbolicName, null, null, DEFAULT_CATEGORY_ID, true, this.getDefaultDescription(), this.getPluginId());
        definition.appendState(2);
        this.definitions.add((IThemeElementDefinitionOverridable<?>)definition);
    }

    private String getPluginId() {
        return WorkbenchPlugin.getDefault().getBundle().getSymbolicName();
    }

    public List<IThemeElementDefinitionOverridable<?>> getDefinitions() {
        return this.definitions;
    }

    private String formatDefaultName(Class<?> cls, String symbolicName) {
        return String.format("%s #%s", cls.getSimpleName(), symbolicName);
    }

    public String getDefaultDescription() {
        if (this.description == null) {
            ResourceBundle resourceBundle = ResourceBundle.getBundle(Theme.class.getName());
            this.description = resourceBundle.getString("Added.by.css.desc");
        }
        return this.description;
    }
}

