/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.rpm.ui.editor.parser;

import org.eclipse.linuxtools.rpm.ui.editor.parser.Specfile;
import org.eclipse.linuxtools.rpm.ui.editor.parser.SpecfileElement;
import org.eclipse.linuxtools.rpm.ui.editor.parser.SpecfilePackage;

public class SpecfileTag
extends SpecfileElement {
    private TagType tagType;
    private String stringValue;
    private int intValue;
    private SpecfilePackage parent;

    public SpecfileTag() {
    }

    public SpecfileTag(String name, String value, Specfile specfile, SpecfilePackage parentPackage) {
        this.setName(name);
        this.stringValue = value;
        this.tagType = TagType.STRING;
        super.setSpecfile(specfile);
        this.parent = parentPackage;
    }

    public SpecfileTag(String name, int value, Specfile specfile, SpecfilePackage parentPackage) {
        this.setName(name);
        this.intValue = value;
        this.tagType = TagType.INT;
        super.setSpecfile(specfile);
        this.parent = parentPackage;
    }

    public String getStringValue() {
        if (this.tagType == TagType.INT) {
            return Integer.toString(this.intValue);
        }
        return this.resolve(this.stringValue);
    }

    public void setValue(String value) {
        this.tagType = TagType.STRING;
        this.stringValue = value;
    }

    public int getIntValue() {
        return this.intValue;
    }

    public void setValue(int value) {
        this.tagType = TagType.INT;
        this.intValue = value;
    }

    public SpecfilePackage getParent() {
        return this.parent;
    }

    public void setParent(SpecfilePackage parent) {
        this.parent = parent;
    }

    @Override
    public String toString() {
        if (this.tagType == TagType.INT) {
            return String.valueOf(this.getName()) + ": " + this.getIntValue();
        }
        String tagValue = this.getStringValue();
        if (tagValue != null && tagValue.length() > 0 && tagValue.indexOf(37) > 0) {
            return String.valueOf(this.getName()) + ": " + super.resolve(tagValue);
        }
        return String.valueOf(this.getName()) + ": " + this.getStringValue();
    }

    public TagType getTagType() {
        return this.tagType;
    }

    public static enum TagType {
        INT,
        STRING;

    }
}

