/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.tmf.ui.project.handlers;

import com.google.common.collect.Multimap;
import com.google.common.collect.TreeMultimap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.linuxtools.internal.tmf.ui.Activator;
import org.eclipse.linuxtools.internal.tmf.ui.project.dialogs.SelectSupplementaryResourcesDialog;
import org.eclipse.linuxtools.tmf.ui.project.model.TmfCommonProjectElement;
import org.eclipse.linuxtools.tmf.ui.project.model.TmfExperimentElement;
import org.eclipse.linuxtools.tmf.ui.project.model.TmfTraceElement;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;

public class DeleteTraceSupplementaryFilesHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window == null) {
            return null;
        }
        ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        if (!(selection instanceof IStructuredSelection)) {
            return null;
        }
        TreeMultimap resourceMap = TreeMultimap.create((Comparator)new ElementComparator(), (Comparator)new ResourceComparator());
        for (Object element : (IStructuredSelection)selection) {
            IResource resource;
            int n;
            IResource[] iResourceArray;
            if (element instanceof TmfTraceElement) {
                TmfTraceElement trace = (TmfTraceElement)element;
                trace = trace.getElementUnderTraceFolder();
                iResourceArray = trace.getSupplementaryResources();
                n = iResourceArray.length;
                int n2 = 0;
                while (n2 < n) {
                    resource = iResourceArray[n2];
                    resourceMap.put((Object)trace, (Object)resource);
                    ++n2;
                }
                continue;
            }
            if (!(element instanceof TmfExperimentElement)) continue;
            TmfExperimentElement experiment = (TmfExperimentElement)element;
            iResourceArray = experiment.getSupplementaryResources();
            n = iResourceArray.length;
            int n3 = 0;
            while (n3 < n) {
                resource = iResourceArray[n3];
                resourceMap.put((Object)experiment, (Object)resource);
                ++n3;
            }
            for (TmfTraceElement trace : experiment.getTraces()) {
                trace = trace.getElementUnderTraceFolder();
                IResource[] iResourceArray2 = trace.getSupplementaryResources();
                int n4 = iResourceArray2.length;
                int n5 = 0;
                while (n5 < n4) {
                    IResource resource2 = iResourceArray2[n5];
                    resourceMap.put((Object)trace, (Object)resource2);
                    ++n5;
                }
            }
        }
        SelectSupplementaryResourcesDialog dialog = new SelectSupplementaryResourcesDialog(window.getShell(), (Multimap<TmfCommonProjectElement, IResource>)resourceMap);
        if (dialog.open() != 0) {
            return null;
        }
        HashSet<IProject> projectsToRefresh = new HashSet<IProject>();
        List<IResource> allResourcesToDelete = Arrays.asList(dialog.getResources());
        for (TmfCommonProjectElement element : resourceMap.keySet()) {
            ArrayList traceResourcesToDelete = new ArrayList(resourceMap.get((Object)element));
            traceResourcesToDelete.retainAll(allResourcesToDelete);
            if (traceResourcesToDelete.isEmpty()) continue;
            element.closeEditors();
            element.deleteSupplementaryResources(traceResourcesToDelete.toArray(new IResource[0]));
            projectsToRefresh.add(element.getProject().getResource());
        }
        for (IProject project : projectsToRefresh) {
            try {
                project.refreshLocal(2, null);
            }
            catch (CoreException e) {
                Activator.getDefault().logError("Error refreshing project " + project, e);
            }
        }
        return null;
    }

    private class ElementComparator
    implements Comparator<TmfCommonProjectElement> {
        private ElementComparator() {
        }

        @Override
        public int compare(TmfCommonProjectElement e1, TmfCommonProjectElement e2) {
            return e1.getPath().toString().compareTo(e2.getPath().toString());
        }
    }

    private class ResourceComparator
    implements Comparator<IResource> {
        private ResourceComparator() {
        }

        @Override
        public int compare(IResource r1, IResource r2) {
            return r1.getFullPath().toString().compareTo(r2.getFullPath().toString());
        }
    }
}

