/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.tmf.ui.project.wizards.importtrace;

import java.io.File;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.operation.ModalContext;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.linuxtools.internal.tmf.ui.Activator;
import org.eclipse.linuxtools.internal.tmf.ui.project.wizards.importtrace.Messages;
import org.eclipse.linuxtools.internal.tmf.ui.project.wizards.importtrace.ResourceTreeAndListGroup;
import org.eclipse.linuxtools.tmf.core.TmfCommonConstants;
import org.eclipse.linuxtools.tmf.core.project.model.TmfTraceImportException;
import org.eclipse.linuxtools.tmf.core.project.model.TmfTraceType;
import org.eclipse.linuxtools.tmf.core.project.model.TraceTypeHelper;
import org.eclipse.linuxtools.tmf.ui.project.model.TmfProjectElement;
import org.eclipse.linuxtools.tmf.ui.project.model.TmfProjectRegistry;
import org.eclipse.linuxtools.tmf.ui.project.model.TmfTraceElement;
import org.eclipse.linuxtools.tmf.ui.project.model.TmfTraceFolder;
import org.eclipse.linuxtools.tmf.ui.project.model.TmfTraceTypeUIUtils;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.dialogs.FileSystemElement;
import org.eclipse.ui.dialogs.IOverwriteQuery;
import org.eclipse.ui.dialogs.WizardResourceImportPage;
import org.eclipse.ui.internal.ide.DialogUtil;
import org.eclipse.ui.internal.ide.dialogs.IElementFilter;
import org.eclipse.ui.model.AdaptableList;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.model.WorkbenchViewerComparator;
import org.eclipse.ui.wizards.datatransfer.FileSystemStructureProvider;
import org.eclipse.ui.wizards.datatransfer.IImportStructureProvider;
import org.eclipse.ui.wizards.datatransfer.ImportOperation;

public class ImportTraceWizardPage
extends WizardResourceImportPage {
    private static final String IMPORT_WIZARD_PAGE = "ImportTraceWizardPage";
    private static final String IMPORT_WIZARD_ROOT_DIRECTORY_ID = "ImportTraceWizardPage.import_root_directory_id";
    private static final String IMPORT_WIZARD_IMPORT_UNRECOGNIZED_ID = "ImportTraceWizardPage.import_unrecognized_traces_id";
    private static final String IMPORT_WIZARD_PRESERVE_FOLDERS_ID = "ImportTraceWizardPage.import_preserve_folders_id";
    private static final String SEPARATOR = ":";
    private static final String AUTO_DETECT = Messages.ImportTraceWizard_AutoDetection;
    private IFolder fTargetFolder;
    private TmfTraceFolder fTraceFolderElement;
    private Boolean fIsDestinationChanged = false;
    private Combo fTraceTypes;
    private Button fImportUnrecognizedButton;
    private Button fOverwriteExistingResourcesCheckbox;
    private Button fCreateLinksInWorkspaceButton;
    private Button fPreserveFolderStructureButton;
    private boolean entryChanged = false;
    protected Combo directoryNameField;
    protected Button directoryBrowseButton;
    private ResourceTreeAndListGroup fSelectionGroup;

    protected ImportTraceWizardPage(String name, IStructuredSelection selection) {
        super(name, selection);
    }

    protected void createFileSelectionGroup(Composite parent) {
        this.fSelectionGroup = new ResourceTreeAndListGroup(parent, new FileSystemElement("Dummy", null, true), this.getFolderProvider(), (ILabelProvider)new WorkbenchLabelProvider(), (IStructuredContentProvider)this.getFileProvider(), (ILabelProvider)new WorkbenchLabelProvider(), 0, DialogUtil.inRegularFontMode((Composite)parent));
        ICheckStateListener listener = new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                ImportTraceWizardPage.this.updateWidgetEnablements();
            }
        };
        WorkbenchViewerComparator comparator = new WorkbenchViewerComparator();
        this.fSelectionGroup.setTreeComparator((ViewerComparator)comparator);
        this.fSelectionGroup.setListComparator((ViewerComparator)comparator);
        this.fSelectionGroup.addCheckStateListener(listener);
    }

    public ImportTraceWizardPage(IWorkbench workbench, IStructuredSelection selection) {
        this(IMPORT_WIZARD_PAGE, selection);
        TmfProjectElement projectElement2;
        IProject project;
        this.setTitle(Messages.ImportTraceWizard_FileSystemTitle);
        this.setDescription(Messages.ImportTraceWizard_ImportTrace);
        IFolder traceFolder = null;
        Object element = selection.getFirstElement();
        if (element instanceof TmfTraceFolder) {
            this.fTraceFolderElement = (TmfTraceFolder)element;
            traceFolder = this.fTraceFolderElement.getResource();
        } else if (element instanceof IProject) {
            project = (IProject)element;
            try {
                if (project.hasNature("org.eclipse.linuxtools.tmf.project.nature")) {
                    projectElement2 = TmfProjectRegistry.getProject(project, true);
                    this.fTraceFolderElement = projectElement2.getTracesFolder();
                    traceFolder = project.getFolder("Traces");
                }
            }
            catch (CoreException projectElement2) {
                // empty catch block
            }
        }
        if (traceFolder == null) {
            project = TmfProjectRegistry.createProject(TmfCommonConstants.DEFAULT_TRACE_PROJECT_NAME, null, (IProgressMonitor)new NullProgressMonitor());
            projectElement2 = TmfProjectRegistry.getProject(project, true);
            this.fTraceFolderElement = projectElement2.getTracesFolder();
            traceFolder = project.getFolder("Traces");
        }
        if (traceFolder != null) {
            this.fTargetFolder = traceFolder;
            String path = traceFolder.getFullPath().toString();
            this.setContainerFieldValue(path);
        }
    }

    protected void createSourceGroup(Composite parent) {
        this.createDirectorySelectionGroup(parent);
        this.createFileSelectionGroup(parent);
        this.createTraceTypeGroup(parent);
        this.validateSourceGroup();
    }

    protected ITreeContentProvider getFileProvider() {
        return new WorkbenchContentProvider(){

            public Object[] getChildren(Object object) {
                if (object instanceof TraceFileSystemElement) {
                    TraceFileSystemElement element = (TraceFileSystemElement)((Object)object);
                    return element.getFiles().getChildren((Object)element);
                }
                return new Object[0];
            }
        };
    }

    protected ITreeContentProvider getFolderProvider() {
        return new WorkbenchContentProvider(){

            public Object[] getChildren(Object o) {
                if (o instanceof TraceFileSystemElement) {
                    TraceFileSystemElement element = (TraceFileSystemElement)((Object)o);
                    return element.getFolders().getChildren();
                }
                return new Object[0];
            }

            public boolean hasChildren(Object o) {
                if (o instanceof TraceFileSystemElement) {
                    TraceFileSystemElement element = (TraceFileSystemElement)((Object)o);
                    if (element.isPopulated()) {
                        return this.getChildren((Object)element).length > 0;
                    }
                    return true;
                }
                return false;
            }
        };
    }

    protected void createDirectorySelectionGroup(Composite parent) {
        Composite directoryContainerGroup = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        directoryContainerGroup.setLayout((Layout)layout);
        directoryContainerGroup.setFont(parent.getFont());
        directoryContainerGroup.setLayoutData((Object)new GridData(4, 4, true, false));
        Label groupLabel = new Label(directoryContainerGroup, 0);
        groupLabel.setText(Messages.ImportTraceWizard_DirectoryLocation);
        groupLabel.setFont(parent.getFont());
        this.directoryNameField = new Combo(directoryContainerGroup, 2048);
        GridData data = new GridData(4, 4, true, false);
        data.widthHint = 250;
        this.directoryNameField.setLayoutData((Object)data);
        this.directoryNameField.setFont(parent.getFont());
        this.directoryNameField.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ImportTraceWizardPage.this.updateFromSourceField();
            }
        });
        this.directoryNameField.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
                if (e.character == '\r') {
                    ImportTraceWizardPage.this.entryChanged = false;
                    ImportTraceWizardPage.this.updateFromSourceField();
                }
            }

            public void keyReleased(KeyEvent e) {
            }
        });
        this.directoryNameField.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
            }

            public void focusLost(FocusEvent e) {
                if (ImportTraceWizardPage.this.entryChanged) {
                    ImportTraceWizardPage.this.entryChanged = false;
                    ImportTraceWizardPage.this.updateFromSourceField();
                }
            }
        });
        this.directoryNameField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ImportTraceWizardPage.this.entryChanged = true;
            }
        });
        this.directoryBrowseButton = new Button(directoryContainerGroup, 8);
        this.directoryBrowseButton.setText(Messages.ImportTraceWizard_BrowseButton);
        this.directoryBrowseButton.addListener(13, (Listener)this);
        this.directoryBrowseButton.setLayoutData((Object)new GridData(4, 4, false, false));
        this.directoryBrowseButton.setFont(parent.getFont());
        this.setButtonLayoutData(this.directoryBrowseButton);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleEvent(Event event) {
        if (event.widget == this.directoryBrowseButton) {
            this.handleSourceDirectoryBrowseButtonPressed();
        }
        Boolean bl = this.fIsDestinationChanged;
        synchronized (bl) {
            if (!this.fIsDestinationChanged.booleanValue()) {
                event.display.asyncExec(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        Boolean bl = ImportTraceWizardPage.this.fIsDestinationChanged;
                        synchronized (bl) {
                            ImportTraceWizardPage.this.fIsDestinationChanged = true;
                            String path = ImportTraceWizardPage.this.fTargetFolder.getFullPath().toString();
                            ImportTraceWizardPage.this.setContainerFieldValue(path);
                        }
                    }
                });
            } else {
                this.fIsDestinationChanged = false;
            }
        }
        super.handleEvent(event);
    }

    protected void handleContainerBrowseButtonPressed() {
    }

    protected void handleSourceDirectoryBrowseButtonPressed() {
        String currentSource = this.directoryNameField.getText();
        DirectoryDialog dialog = new DirectoryDialog(this.directoryNameField.getShell(), 0x10002000);
        dialog.setText(Messages.ImportTraceWizard_SelectTraceDirectoryTitle);
        dialog.setMessage(Messages.ImportTraceWizard_SelectTraceDirectoryMessage);
        dialog.setFilterPath(ImportTraceWizardPage.getSourceDirectoryName(currentSource));
        String selectedDirectory = dialog.open();
        if (selectedDirectory != null) {
            if (ImportTraceWizardPage.getSourceDirectory(selectedDirectory) == null || selectedDirectory.equals(currentSource)) {
                return;
            }
            this.setErrorMessage(null);
            this.setSourceName(selectedDirectory);
        }
    }

    private File getSourceDirectory() {
        return ImportTraceWizardPage.getSourceDirectory(this.directoryNameField.getText());
    }

    private static File getSourceDirectory(String path) {
        File sourceDirectory = new File(ImportTraceWizardPage.getSourceDirectoryName(path));
        if (!sourceDirectory.exists() || !sourceDirectory.isDirectory()) {
            return null;
        }
        return sourceDirectory;
    }

    private static String getSourceDirectoryName(String sourceName) {
        Path result = new Path(sourceName.trim());
        result = result.getDevice() != null && result.segmentCount() == 0 ? result.addTrailingSeparator() : result.removeTrailingSeparator();
        return result.toOSString();
    }

    private void updateFromSourceField() {
        this.setSourceName(this.directoryNameField.getText());
        this.updateWidgetEnablements();
    }

    private void setSourceName(String path) {
        if (path.length() > 0) {
            String[] currentItems = this.directoryNameField.getItems();
            int selectionIndex = -1;
            int i = 0;
            while (i < currentItems.length) {
                if (currentItems[i].equals(path)) {
                    selectionIndex = i;
                }
                ++i;
            }
            if (selectionIndex < 0) {
                int oldLength = currentItems.length;
                String[] newItems = new String[oldLength + 1];
                System.arraycopy(currentItems, 0, newItems, 0, oldLength);
                newItems[oldLength] = path;
                this.directoryNameField.setItems(newItems);
                selectionIndex = oldLength;
            }
            this.directoryNameField.select(selectionIndex);
        }
        this.resetSelection();
    }

    private void resetSelection() {
        TraceFileSystemElement root = this.getFileSystemTree();
        this.fSelectionGroup.setRoot((Object)root);
    }

    private TraceFileSystemElement getFileSystemTree() {
        File sourceDirectory = this.getSourceDirectory();
        if (sourceDirectory == null) {
            return null;
        }
        return this.selectFiles(sourceDirectory, (IImportStructureProvider)FileSystemStructureProvider.INSTANCE);
    }

    private TraceFileSystemElement selectFiles(final Object rootFileSystemObject, final IImportStructureProvider structureProvider) {
        final TraceFileSystemElement[] results = new TraceFileSystemElement[1];
        BusyIndicator.showWhile((Display)this.getShell().getDisplay(), (Runnable)new Runnable(){

            @Override
            public void run() {
                results[0] = ImportTraceWizardPage.createRootElement(rootFileSystemObject, structureProvider);
            }
        });
        return results[0];
    }

    private static TraceFileSystemElement createRootElement(Object fileSystemObject, IImportStructureProvider provider) {
        boolean isContainer = provider.isFolder(fileSystemObject);
        String elementLabel = provider.getLabel(fileSystemObject);
        TraceFileSystemElement dummyParent = new TraceFileSystemElement("", null, true);
        dummyParent.setFileSystemObject(((File)fileSystemObject).getParentFile());
        dummyParent.setPopulated();
        TraceFileSystemElement result = new TraceFileSystemElement(elementLabel, dummyParent, isContainer);
        result.setFileSystemObject(fileSystemObject);
        result.getFiles();
        return dummyParent;
    }

    private final void createTraceTypeGroup(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        layout.makeColumnsEqualWidth = false;
        composite.setLayout((Layout)layout);
        composite.setFont(parent.getFont());
        GridData buttonData = new GridData(4, 4, true, false);
        composite.setLayoutData((Object)buttonData);
        Label typeLabel = new Label(composite, 0);
        typeLabel.setText(Messages.ImportTraceWizard_TraceType);
        typeLabel.setFont(parent.getFont());
        this.fTraceTypes = new Combo(composite, 2056);
        GridData data = new GridData(4, 4, true, false, 2, 1);
        this.fTraceTypes.setLayoutData((Object)data);
        this.fTraceTypes.setFont(parent.getFont());
        String[] availableTraceTypes = TmfTraceType.getAvailableTraceTypes();
        String[] traceTypeList = new String[availableTraceTypes.length + 1];
        traceTypeList[0] = AUTO_DETECT;
        int i = 0;
        while (i < availableTraceTypes.length) {
            traceTypeList[i + 1] = availableTraceTypes[i];
            ++i;
        }
        this.fTraceTypes.setItems(traceTypeList);
        this.fTraceTypes.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ImportTraceWizardPage.this.updateWidgetEnablements();
                boolean enabled = ImportTraceWizardPage.this.fTraceTypes.getText().equals(AUTO_DETECT);
                ImportTraceWizardPage.this.fImportUnrecognizedButton.setEnabled(enabled);
            }
        });
        this.fTraceTypes.select(0);
        this.fImportUnrecognizedButton = new Button(composite, 32);
        this.fImportUnrecognizedButton.setSelection(true);
        this.fImportUnrecognizedButton.setText(Messages.ImportTraceWizard_ImportUnrecognized);
    }

    protected void createOptionsGroupButtons(Group optionsGroup) {
        this.fOverwriteExistingResourcesCheckbox = new Button((Composite)optionsGroup, 32);
        this.fOverwriteExistingResourcesCheckbox.setFont(optionsGroup.getFont());
        this.fOverwriteExistingResourcesCheckbox.setText(Messages.ImportTraceWizard_OverwriteExistingTrace);
        this.fOverwriteExistingResourcesCheckbox.setSelection(false);
        this.fCreateLinksInWorkspaceButton = new Button((Composite)optionsGroup, 32);
        this.fCreateLinksInWorkspaceButton.setFont(optionsGroup.getFont());
        this.fCreateLinksInWorkspaceButton.setText(Messages.ImportTraceWizard_CreateLinksInWorkspace);
        this.fCreateLinksInWorkspaceButton.setSelection(true);
        this.fCreateLinksInWorkspaceButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ImportTraceWizardPage.this.updateWidgetEnablements();
            }
        });
        this.fPreserveFolderStructureButton = new Button((Composite)optionsGroup, 32);
        this.fPreserveFolderStructureButton.setFont(optionsGroup.getFont());
        this.fPreserveFolderStructureButton.setText(Messages.ImportTraceWizard_PreserveFolderStructure);
        this.fPreserveFolderStructureButton.setSelection(true);
        this.updateWidgetEnablements();
    }

    public boolean validateSourceGroup() {
        File sourceDirectory = this.getSourceDirectory();
        if (sourceDirectory == null) {
            this.setMessage(Messages.ImportTraceWizard_SelectTraceSourceEmpty);
            return false;
        }
        if (this.sourceConflictsWithDestination((IPath)new Path(sourceDirectory.getPath()))) {
            this.setMessage(null);
            this.setErrorMessage(this.getSourceConflictMessage());
            return false;
        }
        if (this.fSelectionGroup.getCheckedElementCount() == 0) {
            this.setMessage(null);
            this.setErrorMessage(Messages.ImportTraceWizard_SelectTraceNoneSelected);
            return false;
        }
        IContainer container = this.getSpecifiedContainer();
        if (container != null && container.isVirtual()) {
            if (Platform.getPreferencesService().getBoolean("org.eclipse.linuxtools.tmf.ui", "description.disableLinking", false, null)) {
                this.setMessage(null);
                this.setErrorMessage(Messages.ImportTraceWizard_CannotImportFilesUnderAVirtualFolder);
                return false;
            }
            if (this.fCreateLinksInWorkspaceButton == null || !this.fCreateLinksInWorkspaceButton.getSelection()) {
                this.setMessage(null);
                this.setErrorMessage(Messages.ImportTraceWizard_HaveToCreateLinksUnderAVirtualFolder);
                return false;
            }
        }
        this.setErrorMessage(null);
        return true;
    }

    protected void restoreWidgetValues() {
        super.restoreWidgetValues();
        IDialogSettings settings = this.getDialogSettings();
        boolean value = settings.get(IMPORT_WIZARD_IMPORT_UNRECOGNIZED_ID) == null ? true : settings.getBoolean(IMPORT_WIZARD_IMPORT_UNRECOGNIZED_ID);
        this.fImportUnrecognizedButton.setSelection(value);
        value = settings.get(IMPORT_WIZARD_PRESERVE_FOLDERS_ID) == null ? true : settings.getBoolean(IMPORT_WIZARD_PRESERVE_FOLDERS_ID);
        this.fPreserveFolderStructureButton.setSelection(value);
        String[] directoryNames = settings.getArray(IMPORT_WIZARD_ROOT_DIRECTORY_ID);
        if (directoryNames != null && directoryNames.length != 0) {
            int i = 0;
            while (i < directoryNames.length) {
                this.directoryNameField.add(directoryNames[i]);
                ++i;
            }
        }
    }

    protected void saveWidgetValues() {
        IDialogSettings settings = this.getDialogSettings();
        settings.put(IMPORT_WIZARD_IMPORT_UNRECOGNIZED_ID, this.fImportUnrecognizedButton.getSelection());
        settings.put(IMPORT_WIZARD_PRESERVE_FOLDERS_ID, this.fPreserveFolderStructureButton.getSelection());
        String[] directoryNames = settings.getArray(IMPORT_WIZARD_ROOT_DIRECTORY_ID);
        if (directoryNames == null) {
            directoryNames = new String[]{};
        }
        String[] items = this.directoryNameField.getItems();
        int i = 0;
        while (i < items.length) {
            directoryNames = this.addToHistory(directoryNames, items[i]);
            ++i;
        }
        settings.put(IMPORT_WIZARD_ROOT_DIRECTORY_ID, directoryNames);
    }

    public boolean finish() {
        block21: {
            String traceTypeName = this.fTraceTypes.getText();
            String traceId = null;
            if (!AUTO_DETECT.equals(traceTypeName)) {
                String[] tokens = traceTypeName.split(SEPARATOR, 2);
                if (tokens.length < 2) {
                    return false;
                }
                traceId = TmfTraceType.getTraceTypeId((String)tokens[0], (String)tokens[1]);
            }
            this.saveWidgetValues();
            Path baseSourceContainerPath = new Path(this.getSourceDirectory().getAbsolutePath());
            final TraceValidateAndImportOperation operation = new TraceValidateAndImportOperation(traceId, (IPath)baseSourceContainerPath, this.getContainerFullPath(), this.fImportUnrecognizedButton.getSelection(), this.fOverwriteExistingResourcesCheckbox.getSelection(), this.fCreateLinksInWorkspaceButton.getSelection(), this.fPreserveFolderStructureButton.getSelection());
            IStatus status = Status.OK_STATUS;
            try {
                this.getContainer().run(true, true, new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                        operation.run(monitor);
                        monitor.done();
                    }
                });
                status = operation.getStatus();
            }
            catch (InvocationTargetException e) {
                status = new Status(4, "org.eclipse.linuxtools.tmf.ui", Messages.ImportTraceWizard_ImportProblem, (Throwable)e);
                if (!status.isOK()) {
                    if (status.getSeverity() == 8) {
                        this.setMessage(Messages.ImportTraceWizard_ImportOperationCancelled);
                        this.setErrorMessage(null);
                    } else {
                        if (status.getException() != null) {
                            this.displayErrorDialog(String.valueOf(status.getMessage()) + ": " + status.getException());
                        }
                        this.setMessage(null);
                        this.setErrorMessage(Messages.ImportTraceWizard_ImportProblem);
                    }
                    return false;
                }
                break block21;
            }
            catch (InterruptedException e) {
                try {
                    status = Status.CANCEL_STATUS;
                    return (boolean)status;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    if (!status.isOK()) {
                        if (status.getSeverity() == 8) {
                            this.setMessage(Messages.ImportTraceWizard_ImportOperationCancelled);
                            this.setErrorMessage(null);
                        } else {
                            if (status.getException() != null) {
                                this.displayErrorDialog(String.valueOf(status.getMessage()) + ": " + status.getException());
                            }
                            this.setMessage(null);
                            this.setErrorMessage(Messages.ImportTraceWizard_ImportProblem);
                        }
                        return false;
                    }
                    break block21;
                }
            }
            if (!status.isOK()) {
                if (status.getSeverity() == 8) {
                    this.setMessage(Messages.ImportTraceWizard_ImportOperationCancelled);
                    this.setErrorMessage(null);
                } else {
                    if (status.getException() != null) {
                        this.displayErrorDialog(String.valueOf(status.getMessage()) + ": " + status.getException());
                    }
                    this.setMessage(null);
                    this.setErrorMessage(Messages.ImportTraceWizard_ImportProblem);
                }
                return false;
            }
        }
        this.setErrorMessage(null);
        return true;
    }

    private static enum ImportConfirmation {
        RENAME(Messages.ImportTraceWizard_ImportConfigurationRename),
        RENAME_ALL(Messages.ImportTraceWizard_ImportConfigurationRenameAll),
        OVERWRITE(Messages.ImportTraceWizard_ImportConfigurationOverwrite),
        OVERWRITE_ALL(Messages.ImportTraceWizard_ImportConfigurationOverwriteAll),
        SKIP(Messages.ImportTraceWizard_ImportConfigurationSkip),
        SKIP_ALL(Messages.ImportTraceWizard_ImportConfigurationSkipAll),
        CONTINUE("CONTINUE");

        private final String fInName;

        private ImportConfirmation(String name) {
            this.fInName = name;
        }

        public String getInName() {
            return this.fInName;
        }
    }

    private class ImportProvider
    implements IImportStructureProvider {
        private FileSystemStructureProvider provider = FileSystemStructureProvider.INSTANCE;

        ImportProvider() {
        }

        public String getLabel(Object element) {
            TraceFileSystemElement resource = (TraceFileSystemElement)((Object)element);
            return resource.getLabel();
        }

        public List getChildren(Object element) {
            TraceFileSystemElement resource = (TraceFileSystemElement)((Object)element);
            Object[] array = resource.getFiles().getChildren();
            ArrayList<Object> list = new ArrayList<Object>();
            int i = 0;
            while (i < array.length) {
                list.add(array[i]);
                ++i;
            }
            return list;
        }

        public InputStream getContents(Object element) {
            TraceFileSystemElement resource = (TraceFileSystemElement)((Object)element);
            return this.provider.getContents(resource.getFileSystemObject());
        }

        public String getFullPath(Object element) {
            TraceFileSystemElement resource = (TraceFileSystemElement)((Object)element);
            return this.provider.getFullPath(resource.getFileSystemObject());
        }

        public boolean isFolder(Object element) {
            TraceFileSystemElement resource = (TraceFileSystemElement)((Object)element);
            return resource.isDirectory();
        }
    }

    private static class TraceFileSystemElement
    extends FileSystemElement {
        private boolean fIsPopulated = false;
        private String fLabel = null;
        private IPath fDestinationContainerPath;

        public TraceFileSystemElement(String name, FileSystemElement parent, boolean isDirectory) {
            super(name, parent, isDirectory);
        }

        public void setDestinationContainerPath(IPath destinationContainerPath) {
            this.fDestinationContainerPath = destinationContainerPath;
        }

        public void setPopulated() {
            this.fIsPopulated = true;
        }

        public boolean isPopulated() {
            return this.fIsPopulated;
        }

        public AdaptableList getFiles() {
            if (!this.fIsPopulated) {
                this.populateElementChildren();
            }
            return super.getFiles();
        }

        public AdaptableList getFolders() {
            if (!this.fIsPopulated) {
                this.populateElementChildren();
            }
            return super.getFolders();
        }

        public void setLabel(String name) {
            this.fLabel = name;
        }

        public String getLabel() {
            if (this.fLabel == null) {
                File file = (File)this.getFileSystemObject();
                String name = file.getName();
                if (name.length() == 0) {
                    return file.getPath();
                }
                return name;
            }
            return this.fLabel;
        }

        public IPath getDestinationContainerPath() {
            return this.fDestinationContainerPath;
        }

        private void populateElementChildren() {
            FileSystemStructureProvider provider = FileSystemStructureProvider.INSTANCE;
            List allchildren = provider.getChildren(this.getFileSystemObject());
            File child2 = null;
            TraceFileSystemElement newelement = null;
            for (File child2 : allchildren) {
                newelement = new TraceFileSystemElement(provider.getLabel((Object)child2), this, provider.isFolder((Object)child2));
                newelement.setFileSystemObject(child2);
            }
            this.setPopulated();
        }
    }

    private class TraceValidateAndImportOperation {
        private IStatus fStatus;
        private String fTraceType;
        private IPath fDestinationContainerPath;
        private IPath fBaseSourceContainerPath;
        private boolean fImportUnrecognizedTraces;
        private boolean fLink;
        private boolean fPreserveFolderStructure;
        private ImportConfirmation fConfirmationMode = ImportConfirmation.SKIP;

        private TraceValidateAndImportOperation(String traceId, IPath baseSourceContainerPath, IPath destinationContainerPath, boolean doImport, boolean overwrite, boolean link, boolean preserveFolderStructure) {
            this.fTraceType = traceId;
            this.fBaseSourceContainerPath = baseSourceContainerPath;
            this.fDestinationContainerPath = destinationContainerPath;
            this.fImportUnrecognizedTraces = doImport;
            if (overwrite) {
                this.fConfirmationMode = ImportConfirmation.OVERWRITE_ALL;
            }
            this.fLink = link;
            this.fPreserveFolderStructure = preserveFolderStructure;
        }

        public void run(IProgressMonitor progressMonitor) {
            String currentPath = null;
            HashMap<String, TraceFileSystemElement> folderElements = new HashMap<String, TraceFileSystemElement>();
            try {
                final ArrayList fileSystemElements = new ArrayList();
                IElementFilter passThroughFilter = new IElementFilter(){

                    public void filterElements(Collection elements, IProgressMonitor monitor) {
                        fileSystemElements.addAll(elements);
                    }

                    public void filterElements(Object[] elements, IProgressMonitor monitor) {
                        int i = 0;
                        while (i < elements.length) {
                            fileSystemElements.add((TraceFileSystemElement)((Object)elements[i]));
                            ++i;
                        }
                    }
                };
                SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)progressMonitor, (int)1);
                ImportTraceWizardPage.this.fSelectionGroup.getAllCheckedListItems(passThroughFilter, (IProgressMonitor)subMonitor);
                ModalContext.checkCanceled((IProgressMonitor)subMonitor);
                Iterator fileSystemElementsIter = fileSystemElements.iterator();
                subMonitor = SubMonitor.convert((IProgressMonitor)progressMonitor, (int)fileSystemElements.size());
                while (fileSystemElementsIter.hasNext()) {
                    ModalContext.checkCanceled((IProgressMonitor)progressMonitor);
                    currentPath = null;
                    TraceFileSystemElement element = (TraceFileSystemElement)((Object)fileSystemElementsIter.next());
                    File fileResource = (File)element.getFileSystemObject();
                    String resourcePath = fileResource.getAbsolutePath();
                    element.setDestinationContainerPath(this.computeDestinationContainerPath(new Path(resourcePath)));
                    currentPath = resourcePath;
                    SubMonitor sub = subMonitor.newChild(1);
                    if (element.isDirectory()) {
                        if (folderElements.containsKey(resourcePath) || !this.isDirectoryTrace(element)) continue;
                        folderElements.put(resourcePath, element);
                        this.validateAndImportTrace(element, (IProgressMonitor)sub);
                        continue;
                    }
                    TraceFileSystemElement parentElement = (TraceFileSystemElement)element.getParent();
                    File parentFile = (File)parentElement.getFileSystemObject();
                    String parentPath = parentFile.getAbsolutePath();
                    parentElement.setDestinationContainerPath(this.computeDestinationContainerPath(new Path(parentPath)));
                    currentPath = parentPath;
                    if (folderElements.containsKey(parentPath)) continue;
                    if (this.isDirectoryTrace(parentElement)) {
                        folderElements.put(parentPath, parentElement);
                        this.validateAndImportTrace(parentElement, (IProgressMonitor)sub);
                        continue;
                    }
                    if (!fileResource.exists()) continue;
                    this.validateAndImportTrace(element, (IProgressMonitor)sub);
                }
                this.setStatus(Status.OK_STATUS);
            }
            catch (InterruptedException e) {
                this.setStatus(Status.CANCEL_STATUS);
            }
            catch (Exception e) {
                String errorMessage = String.valueOf(Messages.ImportTraceWizard_ImportProblem) + ": " + (currentPath != null ? currentPath : "");
                Activator.getDefault().logError(errorMessage, e);
                this.setStatus((IStatus)new Status(4, "org.eclipse.linuxtools.tmf.ui", errorMessage, (Throwable)e));
            }
        }

        private IPath computeDestinationContainerPath(Path resourcePath) {
            IPath destinationContainerPath = this.fDestinationContainerPath;
            if (this.fPreserveFolderStructure) {
                IPath sourceContainerPath = resourcePath.removeLastSegments(1);
                if (this.fBaseSourceContainerPath.equals((Object)resourcePath)) {
                    sourceContainerPath = resourcePath;
                }
                IPath relativeContainerPath = sourceContainerPath.makeRelativeTo(this.fBaseSourceContainerPath);
                destinationContainerPath = this.fDestinationContainerPath.append(relativeContainerPath);
            }
            return destinationContainerPath;
        }

        private void validateAndImportTrace(TraceFileSystemElement fileSystemElement, IProgressMonitor monitor) throws TmfTraceImportException, CoreException, InvocationTargetException, InterruptedException {
            IResource importedResource;
            File file = (File)fileSystemElement.getFileSystemObject();
            String path = file.getAbsolutePath();
            TraceTypeHelper traceTypeHelper = null;
            if (this.fTraceType == null) {
                try {
                    traceTypeHelper = TmfTraceTypeUIUtils.selectTraceType(path, null, null);
                }
                catch (TmfTraceImportException tmfTraceImportException) {
                    // empty catch block
                }
                if (traceTypeHelper == null) {
                    if (this.fImportUnrecognizedTraces) {
                        this.importResource(fileSystemElement, monitor);
                    }
                    return;
                }
            } else {
                boolean isDirectoryTraceType = TmfTraceType.isDirectoryTraceType((String)this.fTraceType);
                if (fileSystemElement.isDirectory() != isDirectoryTraceType) {
                    return;
                }
                traceTypeHelper = TmfTraceType.getTraceType((String)this.fTraceType);
                if (traceTypeHelper == null) {
                    throw new TmfTraceImportException(Messages.ImportTraceWizard_TraceTypeNotFound);
                }
                if (!traceTypeHelper.validate(path).isOK()) {
                    return;
                }
            }
            if ((importedResource = this.importResource(fileSystemElement, monitor)) != null) {
                TmfTraceTypeUIUtils.setTraceType(importedResource, traceTypeHelper);
            }
        }

        private IResource importResource(TraceFileSystemElement fileSystemElement, IProgressMonitor monitor) throws InvocationTargetException, InterruptedException, CoreException {
            ImportConfirmation mode = this.checkForNameClashes(fileSystemElement);
            switch (mode) {
                case RENAME: 
                case RENAME_ALL: {
                    this.rename(fileSystemElement);
                    break;
                }
                case OVERWRITE: 
                case OVERWRITE_ALL: {
                    this.delete(fileSystemElement, monitor);
                    break;
                }
                case CONTINUE: {
                    break;
                }
                default: {
                    return null;
                }
            }
            ArrayList<TraceFileSystemElement> subList = new ArrayList<TraceFileSystemElement>();
            FileSystemElement parentFolder = fileSystemElement.getParent();
            IPath containerPath = fileSystemElement.getDestinationContainerPath();
            IPath tracePath = containerPath.addTrailingSeparator().append(fileSystemElement.getLabel());
            if (fileSystemElement.isDirectory() && !this.fLink) {
                containerPath = tracePath;
                Object[] array = fileSystemElement.getFiles().getChildren();
                int i = 0;
                while (i < array.length) {
                    subList.add((TraceFileSystemElement)((Object)array[i]));
                    ++i;
                }
                parentFolder = fileSystemElement;
            } else {
                subList.add(fileSystemElement);
            }
            ImportProvider fileSystemStructureProvider = new ImportProvider();
            IOverwriteQuery myQueryImpl = new IOverwriteQuery(){

                public String queryOverwrite(String file) {
                    return "NOALL";
                }
            };
            monitor.setTaskName(String.valueOf(Messages.ImportTraceWizard_ImportOperationTaskName) + " " + ((File)fileSystemElement.getFileSystemObject()).getAbsolutePath());
            ImportOperation operation = new ImportOperation(containerPath, (Object)parentFolder, (IImportStructureProvider)fileSystemStructureProvider, myQueryImpl, subList);
            operation.setContext(ImportTraceWizardPage.this.getShell());
            operation.setCreateContainerStructure(false);
            operation.setOverwriteResources(false);
            operation.setCreateLinks(this.fLink);
            operation.setVirtualFolders(false);
            operation.run((IProgressMonitor)new SubProgressMonitor(monitor, 1, 4));
            File file = (File)fileSystemElement.getFileSystemObject();
            String sourceLocation = null;
            Object sourceResource = file.isDirectory() ? ResourcesPlugin.getWorkspace().getRoot().getContainerForLocation(Path.fromOSString((String)file.getAbsolutePath())) : ResourcesPlugin.getWorkspace().getRoot().getFileForLocation(Path.fromOSString((String)file.getAbsolutePath()));
            if (sourceResource != null && sourceResource.exists()) {
                sourceLocation = sourceResource.getPersistentProperty(TmfCommonConstants.SOURCE_LOCATION);
            }
            if (sourceLocation == null) {
                sourceLocation = URIUtil.toUnencodedString((URI)file.toURI());
            }
            IResource resource = ResourcesPlugin.getWorkspace().getRoot().findMember(tracePath);
            resource.setPersistentProperty(TmfCommonConstants.SOURCE_LOCATION, sourceLocation);
            return resource;
        }

        private boolean isDirectoryTrace(FileSystemElement fileSystemElement) {
            File file = (File)fileSystemElement.getFileSystemObject();
            String path = file.getAbsolutePath();
            return TmfTraceType.isDirectoryTrace((String)path);
        }

        private ImportConfirmation checkForNameClashes(TraceFileSystemElement fileSystemElement) throws InterruptedException {
            IPath tracePath = this.getInitialDestinationPath(fileSystemElement);
            if (this.getExistingTrace(tracePath) != null) {
                if (this.fConfirmationMode == ImportConfirmation.RENAME_ALL || this.fConfirmationMode == ImportConfirmation.OVERWRITE_ALL || this.fConfirmationMode == ImportConfirmation.SKIP_ALL) {
                    return this.fConfirmationMode;
                }
                int returnCode = this.promptForOverwrite(tracePath);
                if (returnCode < 0) {
                    throw new InterruptedException();
                }
                this.fConfirmationMode = ImportConfirmation.values()[returnCode];
                return this.fConfirmationMode;
            }
            return ImportConfirmation.CONTINUE;
        }

        private int promptForOverwrite(IPath tracePath) {
            final MessageDialog dialog = new MessageDialog(ImportTraceWizardPage.this.getContainer().getShell(), null, null, NLS.bind((String)Messages.ImportTraceWizard_TraceAlreadyExists, (Object)tracePath.makeRelativeTo(ImportTraceWizardPage.this.fTraceFolderElement.getProject().getPath())), 3, new String[]{ImportConfirmation.RENAME.getInName(), ImportConfirmation.RENAME_ALL.getInName(), ImportConfirmation.OVERWRITE.getInName(), ImportConfirmation.OVERWRITE_ALL.getInName(), ImportConfirmation.SKIP.getInName(), ImportConfirmation.SKIP_ALL.getInName()}, 4){

                protected int getShellStyle() {
                    return super.getShellStyle() | 0x10000000;
                }
            };
            final int[] returnValue = new int[1];
            ImportTraceWizardPage.this.getShell().getDisplay().syncExec(new Runnable(){

                @Override
                public void run() {
                    returnValue[0] = dialog.open();
                }
            });
            return returnValue[0];
        }

        private IPath getInitialDestinationPath(TraceFileSystemElement fileSystemElement) {
            IPath traceFolderPath = fileSystemElement.getDestinationContainerPath();
            return traceFolderPath.append(((File)fileSystemElement.getFileSystemObject()).getName());
        }

        private void rename(TraceFileSystemElement fileSystemElement) {
            String name;
            IResource resource;
            IPath tracePath = this.getInitialDestinationPath(fileSystemElement);
            TmfTraceElement trace = this.getExistingTrace(tracePath);
            if (trace == null) {
                return;
            }
            IContainer folder = (IContainer)trace.getParent().getResource();
            int i = 2;
            while ((resource = folder.findMember(name = String.valueOf(trace.getName()) + '(' + Integer.toString(i++) + ')')) != null) {
            }
            fileSystemElement.setLabel(name);
        }

        private void delete(TraceFileSystemElement fileSystemElement, IProgressMonitor monitor) throws CoreException {
            IPath tracePath = this.getInitialDestinationPath(fileSystemElement);
            TmfTraceElement trace = this.getExistingTrace(tracePath);
            if (trace == null) {
                return;
            }
            trace.delete(monitor);
        }

        private TmfTraceElement getExistingTrace(IPath tracePath) {
            List<TmfTraceElement> traces = ImportTraceWizardPage.this.fTraceFolderElement.getTraces();
            for (TmfTraceElement t : traces) {
                if (!t.getPath().equals((Object)tracePath)) continue;
                return t;
            }
            return null;
        }

        protected void setStatus(IStatus status) {
            this.fStatus = status;
        }

        public IStatus getStatus() {
            return this.fStatus;
        }
    }
}

