/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.tmf.ui.project.wizards.importtrace;

import java.io.File;
import java.text.DecimalFormat;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationStrategy;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.FocusCellHighlighter;
import org.eclipse.jface.viewers.FocusCellOwnerDrawHighlighter;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SWTFocusCellManager;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.jface.viewers.TreeViewerEditor;
import org.eclipse.jface.viewers.TreeViewerFocusCellManager;
import org.eclipse.linuxtools.internal.tmf.ui.Activator;
import org.eclipse.linuxtools.internal.tmf.ui.project.wizards.importtrace.AbstractImportTraceWizardPage;
import org.eclipse.linuxtools.internal.tmf.ui.project.wizards.importtrace.FileAndName;
import org.eclipse.linuxtools.internal.tmf.ui.project.wizards.importtrace.ImportTraceContentProvider;
import org.eclipse.linuxtools.internal.tmf.ui.project.wizards.importtrace.Messages;
import org.eclipse.linuxtools.tmf.core.project.model.TmfTraceType;
import org.eclipse.linuxtools.tmf.core.project.model.TraceValidationHelper;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;

public class ImportTraceWizardScanPage
extends AbstractImportTraceWizardPage {
    private static final int COL_WIDTH = 200;
    private static final int MAX_TRACES = 65536;
    private CheckboxTreeViewer traceTypeViewer;
    final ScanRunnable fRunnable = new ScanRunnable("Scan job");
    private final BlockingQueue<TraceValidationHelper> fTracesToScan = new ArrayBlockingQueue<TraceValidationHelper>(65536);
    private volatile boolean fCanRun = true;

    protected ImportTraceWizardScanPage(String name, IStructuredSelection selection) {
        super(name, selection);
    }

    public ImportTraceWizardScanPage(IWorkbench workbench, IStructuredSelection selection) {
        super(workbench, selection);
    }

    public void dispose() {
        this.fCanRun = false;
        this.fRunnable.done(Status.OK_STATUS);
        super.dispose();
    }

    @Override
    public void createControl(Composite parent) {
        super.createControl(parent);
        Composite control = (Composite)this.getControl();
        this.setTitle(Messages.ImportTraceWizardScanPageTitle);
        this.traceTypeViewer = new CheckboxTreeViewer(control, 32);
        this.traceTypeViewer.setContentProvider((IContentProvider)this.getBatchWizard().getScannedTraces());
        this.traceTypeViewer.getTree().setHeaderVisible(true);
        this.traceTypeViewer.getControl().setLayoutData((Object)new GridData(4, 4, true, true));
        this.traceTypeViewer.setInput((Object)this.getBatchWizard().getScannedTraces());
        this.traceTypeViewer.addCheckStateListener((ICheckStateListener)new ImportTraceCheckStateListener());
        TreeViewerFocusCellManager focusCellManager = new TreeViewerFocusCellManager((TreeViewer)this.traceTypeViewer, (FocusCellHighlighter)new FocusCellOwnerDrawHighlighter((ColumnViewer)this.traceTypeViewer));
        ColumnViewerEditorActivationStrategy actSupport = new ColumnViewerEditorActivationStrategy((ColumnViewer)this.traceTypeViewer){};
        TreeViewerEditor.create((TreeViewer)this.traceTypeViewer, (SWTFocusCellManager)focusCellManager, (ColumnViewerEditorActivationStrategy)actSupport, (int)58);
        TextCellEditor textCellEditor = new TextCellEditor((Composite)this.traceTypeViewer.getTree());
        TreeViewerColumn column = new TreeViewerColumn((TreeViewer)this.traceTypeViewer, 0);
        column.getColumn().setWidth(200);
        column.getColumn().setText(Messages.ImportTraceWizardTraceDisplayName);
        column.setLabelProvider((CellLabelProvider)new FirstColumnLabelProvider());
        column.setEditingSupport((EditingSupport)new ColumnEditorSupport((ColumnViewer)this.traceTypeViewer, textCellEditor));
        column = new TreeViewerColumn((TreeViewer)this.traceTypeViewer, 0);
        column.getColumn().setWidth(500);
        column.getColumn().setText(Messages.ImportTraceWizardImportCaption);
        column.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof FileAndName) {
                    FileAndName elem = (FileAndName)element;
                    return elem.getFile().getPath();
                }
                return null;
            }
        });
        column = new TreeViewerColumn((TreeViewer)this.traceTypeViewer, 0);
        column.getColumn().setWidth(80);
        column.getColumn().setText(Messages.ImportTraceWizardScanPageSize);
        column.getColumn().setAlignment(131072);
        column.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof FileAndName) {
                    FileAndName elem = (FileAndName)element;
                    long len = this.recurseSize(elem.getFile());
                    if (len > 0L) {
                        double sizeb10 = Math.log10(len);
                        DecimalFormat df = new DecimalFormat();
                        df.setMaximumFractionDigits(2);
                        df.setMinimumFractionDigits(0);
                        if (sizeb10 > 12.0) {
                            double tbSize = (double)len / 1024.0 / 1024.0 / 1024.0 / 1024.0;
                            return String.valueOf(df.format(tbSize)) + Messages.ImportTraceWizardScanPageTerabyte;
                        }
                        if (sizeb10 > 9.0) {
                            double gbSize = (double)len / 1024.0 / 1024.0 / 1024.0;
                            return String.valueOf(df.format(gbSize)) + Messages.ImportTraceWizardScanPageGigabyte;
                        }
                        if (sizeb10 > 6.0) {
                            double mbSize = (double)len / 1024.0 / 1024.0;
                            return String.valueOf(df.format(mbSize)) + Messages.ImportTraceWizardScanPageMegabyte;
                        }
                        if (sizeb10 > 3.0) {
                            double kbSize = (double)len / 1024.0;
                            return String.valueOf(df.format(kbSize)) + Messages.ImportTraceWizardScanPageKilobyte;
                        }
                    }
                    return String.valueOf(Long.toString(len)) + Messages.ImportTraceWizardScanPagebyte;
                }
                return null;
            }

            private long recurseSize(File file) {
                File[] listFiles;
                if (file.isFile() && file.canRead()) {
                    return file.length();
                }
                long size = 0L;
                if (file.exists() && file.isDirectory() && file.canRead() && (listFiles = file.listFiles()) != null) {
                    File[] fileArray = listFiles;
                    int n = listFiles.length;
                    int n2 = 0;
                    while (n2 < n) {
                        File child = fileArray[n2];
                        if (child.isFile() && child.canRead()) {
                            size += child.length();
                        } else if (child.isDirectory()) {
                            size += this.recurseSize(child);
                        } else {
                            Activator.getDefault().logError("Unknown \"file\" type for " + child + ' ' + child.toString());
                        }
                        ++n2;
                    }
                }
                return size;
            }
        });
        this.init();
        this.getBatchWizard().setTracesToScan(this.fTracesToScan);
        this.getBatchWizard().setTraceFolder(this.fTargetFolder);
        this.fRunnable.schedule();
        this.setErrorMessage(Messages.ImportTraceWizardScanPageSelectAtleastOne);
    }

    private void init() {
        Composite optionPane = (Composite)this.getControl();
        optionPane.setLayout((Layout)new GridLayout());
        optionPane.setLayoutData((Object)new GridData(16384, 128, true, true));
        Button fLink = new Button(optionPane, 16);
        fLink.setText(Messages.ImportTraceWizardLinkTraces);
        fLink.setSelection(true);
        fLink.setLayoutData((Object)new GridData());
        Button fCopy = new Button(optionPane, 16);
        fCopy.setText(Messages.ImportTraceWizardCopyTraces);
        fCopy.setLayoutData((Object)new GridData());
        RadioChooser linkedListener = new RadioChooser(fLink);
        fLink.addSelectionListener((SelectionListener)linkedListener);
        fCopy.addSelectionListener((SelectionListener)linkedListener);
        Button fOverwrite = new Button(optionPane, 32);
        fOverwrite.setText(Messages.ImportTraceWizardOverwriteTraces);
        fOverwrite.setLayoutData((Object)new GridData());
        fOverwrite.setSelection(true);
        fOverwrite.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ImportTraceWizardScanPage.this.getBatchWizard().setOverwrite(((Button)e.widget).getSelection());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    public void refresh() {
        final Control control = this.traceTypeViewer.getControl();
        if (!control.isDisposed()) {
            control.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (!control.isDisposed()) {
                        ImportTraceWizardScanPage.this.traceTypeViewer.refresh();
                    }
                }
            });
        }
    }

    private final class ColumnEditorSupport
    extends EditingSupport {
        private final TextCellEditor textCellEditor;

        private ColumnEditorSupport(ColumnViewer viewer, TextCellEditor textCellEditor) {
            super(viewer);
            this.textCellEditor = textCellEditor;
        }

        protected boolean canEdit(Object element) {
            return element instanceof FileAndName;
        }

        protected CellEditor getCellEditor(Object element) {
            return this.textCellEditor;
        }

        protected Object getValue(Object element) {
            if (element instanceof FileAndName) {
                return ((FileAndName)element).getName();
            }
            return null;
        }

        protected void setValue(Object element, Object value) {
            FileAndName fan = (FileAndName)element;
            fan.setName((String)value);
            ImportTraceWizardScanPage.this.getBatchWizard().updateConflicts();
            ImportTraceWizardScanPage.this.traceTypeViewer.update(element, null);
            ImportTraceWizardScanPage.this.traceTypeViewer.refresh();
        }
    }

    private final class FirstColumnLabelProvider
    extends ColumnLabelProvider {
        Image fConflict;

        private FirstColumnLabelProvider() {
        }

        public Image getImage(Object element) {
            FileAndName fan;
            if (element instanceof FileAndName && (fan = (FileAndName)element).isConflictingName()) {
                if (this.fConflict == null) {
                    this.fConflict = Activator.getDefault().getImageFromImageRegistry("icons/wizban/conflict_stat.gif");
                }
                return this.fConflict;
            }
            return null;
        }

        public String getText(Object element) {
            if (element instanceof FileAndName) {
                FileAndName elem = (FileAndName)element;
                return elem.getName();
            }
            if (element instanceof String) {
                return (String)element;
            }
            return null;
        }
    }

    private final class ImportTraceCheckStateListener
    implements ICheckStateListener {
        private ImportTraceCheckStateListener() {
        }

        public void checkStateChanged(CheckStateChangedEvent event) {
            CheckboxTreeViewer tv = (CheckboxTreeViewer)event.getSource();
            if (event.getElement() instanceof FileAndName) {
                FileAndName element = (FileAndName)event.getElement();
                if (event.getChecked()) {
                    ImportTraceWizardScanPage.this.getBatchWizard().addFileToImport(element);
                    ImportTraceWizardScanPage.this.traceTypeViewer.update((Object)element, null);
                } else {
                    ImportTraceWizardScanPage.this.getBatchWizard().removeFileToImport(element);
                    ImportTraceWizardScanPage.this.traceTypeViewer.update((Object)element, null);
                }
                this.maintainCheckIntegrity(tv, element);
            }
            if (event.getElement() instanceof String) {
                tv.setSubtreeChecked(event.getElement(), event.getChecked());
                Object[] children = ImportTraceWizardScanPage.this.getBatchWizard().getScannedTraces().getChildren(event.getElement());
                if (event.getChecked()) {
                    int i = 0;
                    while (i < children.length) {
                        FileAndName element = (FileAndName)children[i];
                        ImportTraceWizardScanPage.this.getBatchWizard().addFileToImport(element);
                        ImportTraceWizardScanPage.this.traceTypeViewer.update(children[i], null);
                        ++i;
                    }
                } else {
                    int i = 0;
                    while (i < children.length) {
                        ImportTraceWizardScanPage.this.getBatchWizard().removeFileToImport((FileAndName)children[i]);
                        ++i;
                    }
                }
            }
            ImportTraceWizardScanPage.this.getBatchWizard().updateConflicts();
            if (ImportTraceWizardScanPage.this.getBatchWizard().hasConflicts()) {
                ImportTraceWizardScanPage.this.setErrorMessage(Messages.ImportTraceWizardScanPageRenameError);
            } else if (!ImportTraceWizardScanPage.this.getBatchWizard().hasTracesToImport()) {
                ImportTraceWizardScanPage.this.setErrorMessage(Messages.ImportTraceWizardScanPageSelectAtleastOne);
            } else {
                ImportTraceWizardScanPage.this.setErrorMessage(null);
            }
            ImportTraceWizardScanPage.this.getWizard().getContainer().updateButtons();
            ImportTraceWizardScanPage.this.traceTypeViewer.update(event.getElement(), null);
        }

        private void maintainCheckIntegrity(CheckboxTreeViewer viewer, FileAndName element) {
            ImportTraceContentProvider scannedTraces = ImportTraceWizardScanPage.this.getBatchWizard().getScannedTraces();
            String parentElement = (String)scannedTraces.getParent(element);
            boolean allChecked = true;
            FileAndName[] siblings = scannedTraces.getSiblings(element);
            if (siblings != null) {
                FileAndName[] fileAndNameArray = siblings;
                int n = siblings.length;
                int n2 = 0;
                while (n2 < n) {
                    FileAndName child = fileAndNameArray[n2];
                    allChecked &= viewer.getChecked((Object)child);
                    ++n2;
                }
            }
            viewer.setChecked((Object)parentElement, allChecked);
        }
    }

    private final class RadioChooser
    implements SelectionListener {
        private final Button isLinked;

        public RadioChooser(Button desiredButton) {
            this.isLinked = desiredButton;
        }

        public void widgetSelected(SelectionEvent e) {
            Button widget = (Button)e.widget;
            ImportTraceWizardScanPage.this.getBatchWizard().setLinked(widget.equals(this.isLinked));
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }
    }

    private final class ScanRunnable
    extends Job {
        private IProgressMonitor fMonitor;

        public ScanRunnable(String name) {
            super(name);
            this.setSystem(true);
        }

        private synchronized IProgressMonitor getMonitor() {
            return this.fMonitor;
        }

        public IStatus run(IProgressMonitor monitor) {
            this.fMonitor = monitor;
            final Control control = ImportTraceWizardScanPage.this.traceTypeViewer.getControl();
            control.getDisplay().syncExec(new Runnable(){

                @Override
                public void run() {
                    ScanRunnable.this.fMonitor = (IProgressMonitor)SubMonitor.convert((IProgressMonitor)ScanRunnable.this.getMonitor());
                    ScanRunnable.this.getMonitor().setTaskName(String.valueOf(Messages.ImportTraceWizardPageScanScanning) + ' ');
                    ((SubMonitor)ScanRunnable.this.getMonitor()).setWorkRemaining(-1);
                }
            });
            while (ImportTraceWizardScanPage.this.fCanRun) {
                boolean updated = false;
                if (ImportTraceWizardScanPage.this.fTracesToScan.isEmpty() && !control.isDisposed()) {
                    control.getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            if (!control.isDisposed()) {
                                ScanRunnable.this.getMonitor().setTaskName(String.valueOf(Messages.ImportTraceWizardPageScanScanning) + ' ');
                                ScanRunnable.this.getMonitor().subTask(Messages.ImportTraceWizardPageScanDone);
                                ImportTraceWizardScanPage.this.setMessage(String.valueOf(Messages.ImportTraceWizardPageScanScanning) + ' ' + Messages.ImportTraceWizardPageScanDone);
                            }
                        }
                    });
                }
                try {
                    int prevVal;
                    int total;
                    int scanned;
                    int curVal;
                    boolean validCombo;
                    final TraceValidationHelper traceToScan = (TraceValidationHelper)ImportTraceWizardScanPage.this.fTracesToScan.take();
                    if (!ImportTraceWizardScanPage.this.getBatchWizard().hasScanned(traceToScan)) {
                        ImportTraceWizardScanPage.this.getBatchWizard().addResult(traceToScan, TmfTraceType.validate((TraceValidationHelper)traceToScan));
                    }
                    if (validCombo = ImportTraceWizardScanPage.this.getBatchWizard().getResult(traceToScan)) {
                        ImportTraceWizardScanPage.this.getBatchWizard().getScannedTraces().addCandidate(traceToScan.getTraceType(), new File(traceToScan.getTraceToScan()));
                        updated = true;
                    }
                    if ((curVal = (int)((double)(scanned = ImportTraceWizardScanPage.this.getBatchWizard().getNumberOfResults()) * 100.0 / (double)(total = scanned + ImportTraceWizardScanPage.this.fTracesToScan.size()))) != (prevVal = (int)((double)(scanned - 1) * 100.0 / (double)total))) {
                        updated = true;
                    }
                    if (updated && !control.isDisposed()) {
                        control.getDisplay().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                if (!control.isDisposed()) {
                                    ScanRunnable.this.getMonitor().setTaskName(String.valueOf(Messages.ImportTraceWizardPageScanScanning) + ' ');
                                    ScanRunnable.this.getMonitor().subTask(traceToScan.getTraceToScan());
                                    ScanRunnable.this.getMonitor().worked(1);
                                    ImportTraceWizardScanPage.this.setMessage(String.valueOf(Messages.ImportTraceWizardPageScanScanning) + ' ' + Integer.toString(curVal) + '%');
                                }
                            }
                        });
                    }
                    boolean editing = ImportTraceWizardScanPage.this.traceTypeViewer.isCellEditorActive();
                    if (!updated || editing || control.isDisposed()) continue;
                    control.getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            if (!control.isDisposed() && !ImportTraceWizardScanPage.this.traceTypeViewer.isCellEditorActive()) {
                                ImportTraceWizardScanPage.this.traceTypeViewer.refresh();
                            }
                        }
                    });
                }
                catch (InterruptedException e) {
                    return new Status(8, "org.eclipse.linuxtools.tmf.ui", new String());
                }
            }
            return Status.OK_STATUS;
        }
    }
}

