/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.tmf.ui.project.wizards.importtrace;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.linuxtools.tmf.core.project.model.TmfTraceType;
import org.eclipse.linuxtools.tmf.core.project.model.TraceTypeHelper;

public class TraceTypeContentProvider
implements ITreeContentProvider {
    private final List<String> fTraceCategory = new ArrayList<String>();
    private final Map<String, List<TraceTypeHelper>> fTraceType = new HashMap<String, List<TraceTypeHelper>>();

    public TraceTypeContentProvider() {
        this.fTraceType.clear();
        this.fTraceCategory.clear();
        for (String category : TmfTraceType.getTraceCategories()) {
            List value = TmfTraceType.getTraceTypes((String)category);
            if (value.isEmpty()) continue;
            this.fTraceCategory.add(category);
            this.fTraceType.put(category, value);
        }
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    public Object[] getElements(Object inputElement) {
        return this.fTraceCategory.toArray(new String[0]);
    }

    public Object[] getChildren(Object parentElement) {
        List<TraceTypeHelper> children;
        if (parentElement instanceof String && (children = this.fTraceType.get(parentElement)) != null) {
            return children.toArray(new TraceTypeHelper[0]);
        }
        return null;
    }

    public Object getParent(Object element) {
        if (element instanceof TraceTypeHelper) {
            for (String key : this.fTraceCategory) {
                List<TraceTypeHelper> traceSet = this.fTraceType.get(key);
                if (traceSet == null || !traceSet.contains(element)) continue;
                return key;
            }
        }
        return null;
    }

    public boolean hasChildren(Object element) {
        if (element instanceof String) {
            String key = (String)element;
            return this.fTraceType.containsKey(key);
        }
        return false;
    }
}

