/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.tmf.ui.project.wizards.tracepkg.importexport;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.linuxtools.internal.tmf.ui.project.wizards.tracepkg.importexport.ExportTracePackageWizard;
import org.eclipse.linuxtools.tmf.ui.project.model.TmfProjectElement;
import org.eclipse.linuxtools.tmf.ui.project.model.TmfTraceElement;
import org.eclipse.linuxtools.tmf.ui.project.model.TmfTraceFolder;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;

public class ExportTracePackageHandler
extends AbstractHandler {
    private boolean fEnabled = false;

    public Object execute(ExecutionEvent event) throws ExecutionException {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window == null) {
            return Boolean.FALSE;
        }
        ISelection currentSelection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        StructuredSelection sec = StructuredSelection.EMPTY;
        List<TmfTraceElement> selectedTraces = new ArrayList<TmfTraceElement>();
        if (currentSelection instanceof IStructuredSelection) {
            Object[] selectedElements;
            sec = (IStructuredSelection)currentSelection;
            Object[] objectArray = selectedElements = sec.toArray();
            int n = selectedElements.length;
            int n2 = 0;
            while (n2 < n) {
                Object selectedElement = objectArray[n2];
                if (selectedElement instanceof TmfTraceElement) {
                    TmfTraceElement tmfTraceElement = (TmfTraceElement)selectedElement;
                    selectedTraces.add(tmfTraceElement.getElementUnderTraceFolder());
                } else if (selectedElement instanceof TmfTraceFolder) {
                    TmfTraceFolder tmfTraceFolder = (TmfTraceFolder)selectedElement;
                    selectedTraces = tmfTraceFolder.getTraces();
                }
                ++n2;
            }
        }
        ExportTracePackageWizard w = new ExportTracePackageWizard(selectedTraces);
        w.init(PlatformUI.getWorkbench(), (IStructuredSelection)sec);
        WizardDialog dialog = new WizardDialog(window.getShell(), (IWizard)w);
        dialog.open();
        return null;
    }

    public boolean isEnabled() {
        return super.isEnabled() && this.fEnabled;
    }

    public void setEnabled(Object evaluationContext) {
        super.setEnabled(evaluationContext);
        this.fEnabled = true;
        Object s = HandlerUtil.getVariable((Object)evaluationContext, (String)"activeMenuSelection");
        if (s instanceof IStructuredSelection) {
            IStructuredSelection selection = (IStructuredSelection)s;
            Object[] selectedElements = selection.toArray();
            TmfProjectElement firstProject = null;
            Object[] objectArray = selectedElements;
            int n = selectedElements.length;
            int n2 = 0;
            while (n2 < n) {
                Object selectedElement = objectArray[n2];
                if (selectedElement instanceof TmfTraceElement) {
                    TmfTraceElement tmfTraceElement = (TmfTraceElement)selectedElement;
                    TmfProjectElement project = tmfTraceElement.getProject();
                    if (firstProject != null && !project.equals(firstProject)) {
                        this.fEnabled = false;
                    }
                    firstProject = project;
                }
                ++n2;
            }
        }
    }
}

