/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.tmf.ui.project.wizards.tracepkg.importexport;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.linuxtools.internal.tmf.ui.project.wizards.tracepkg.importexport.ExportTracePackageWizardPage;
import org.eclipse.linuxtools.internal.tmf.ui.project.wizards.tracepkg.importexport.Messages;
import org.eclipse.linuxtools.tmf.ui.project.model.TmfNavigatorContentProvider;
import org.eclipse.linuxtools.tmf.ui.project.model.TmfNavigatorLabelProvider;
import org.eclipse.linuxtools.tmf.ui.project.model.TmfProjectElement;
import org.eclipse.linuxtools.tmf.ui.project.model.TmfProjectRegistry;
import org.eclipse.linuxtools.tmf.ui.project.model.TmfTraceElement;
import org.eclipse.linuxtools.tmf.ui.project.model.TmfTraceFolder;
import org.eclipse.linuxtools.tmf.ui.project.model.TraceUtils;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class ExportTracePackageSelectTraceWizardPage
extends WizardPage {
    private static final String PAGE_NAME = "ExportTracePackageSelectTraceWizardPage";
    private IProject fSelectedProject;
    private Table fTraceTable;

    public ExportTracePackageSelectTraceWizardPage() {
        super(PAGE_NAME);
    }

    public void createControl(Composite parent) {
        Composite projectSelectionGroup = new Composite(parent, 0);
        projectSelectionGroup.setLayout((Layout)new GridLayout(2, true));
        projectSelectionGroup.setLayoutData((Object)new GridData(1808));
        projectSelectionGroup.setFont(parent.getFont());
        Label projectLabel = new Label(projectSelectionGroup, 0);
        projectLabel.setText(Messages.ExportTracePackageSelectTraceWizardPage_ProjectSelection);
        projectLabel.setLayoutData((Object)new GridData());
        Label configLabel = new Label(projectSelectionGroup, 0);
        configLabel.setText(Messages.ExportTracePackageSelectTraceWizardPage_TraceSelection);
        configLabel.setLayoutData((Object)new GridData());
        final Table projectTable = new Table(projectSelectionGroup, 2052);
        projectTable.setLayoutData((Object)new GridData(1808));
        TableViewer projectViewer = new TableViewer(projectTable);
        projectViewer.setContentProvider((IContentProvider)new TmfNavigatorContentProvider(){

            @Override
            public Object[] getElements(Object inputElement) {
                return (IProject[])inputElement;
            }
        });
        projectViewer.setLabelProvider((IBaseLabelProvider)new WorkbenchLabelProvider());
        projectViewer.setInput((Object)TraceUtils.getOpenedTmfProjects().toArray(new IProject[0]));
        this.fTraceTable = new Table(projectSelectionGroup, 2080);
        this.fTraceTable.setLayoutData((Object)new GridData(1808));
        final TableViewer traceViewer = new TableViewer(this.fTraceTable);
        traceViewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public void dispose() {
            }

            public Object[] getElements(Object inputElement) {
                if (inputElement instanceof TmfTraceElement[]) {
                    return (TmfTraceElement[])inputElement;
                }
                return null;
            }
        });
        traceViewer.setLabelProvider((IBaseLabelProvider)new ExportLabelProvider());
        this.fTraceTable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExportTracePackageSelectTraceWizardPage.this.getWizard().getContainer().updateButtons();
                ExportTracePackageSelectTraceWizardPage.this.updateNextPageData();
            }
        });
        projectTable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TableItem[] items = projectTable.getSelection();
                ExportTracePackageSelectTraceWizardPage.this.fSelectedProject = (IProject)items[0].getData();
                TmfProjectElement project = TmfProjectRegistry.getProject(ExportTracePackageSelectTraceWizardPage.this.fSelectedProject, true);
                TmfTraceFolder tracesFolder = project.getTracesFolder();
                List<TmfTraceElement> traces = tracesFolder.getTraces();
                TmfTraceElement[] array = traces.toArray(new TmfTraceElement[0]);
                traceViewer.setInput((Object)array);
                traceViewer.refresh();
                ExportTracePackageSelectTraceWizardPage.this.fTraceTable.select(0);
                ExportTracePackageSelectTraceWizardPage.this.fTraceTable.notifyListeners(13, new Event());
                ExportTracePackageSelectTraceWizardPage.this.getWizard().getContainer().updateButtons();
            }
        });
        Composite btComp = new Composite(projectSelectionGroup, 0);
        btComp.setLayout((Layout)new GridLayout(2, true));
        GridData gd = new GridData();
        gd.horizontalSpan = 2;
        gd.horizontalAlignment = 131072;
        btComp.setLayoutData((Object)gd);
        Button selectAll = new Button(btComp, 8);
        selectAll.setText(org.eclipse.linuxtools.internal.tmf.ui.project.dialogs.Messages.Dialog_SelectAll);
        selectAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TableItem[] items;
                TableItem[] tableItemArray = items = ExportTracePackageSelectTraceWizardPage.this.fTraceTable.getItems();
                int n = items.length;
                int n2 = 0;
                while (n2 < n) {
                    TableItem item = tableItemArray[n2];
                    item.setChecked(true);
                    ++n2;
                }
                ExportTracePackageSelectTraceWizardPage.this.getWizard().getContainer().updateButtons();
                ExportTracePackageSelectTraceWizardPage.this.updateNextPageData();
            }
        });
        Button deselectAll = new Button(btComp, 8);
        deselectAll.setText(org.eclipse.linuxtools.internal.tmf.ui.project.dialogs.Messages.Dialog_DeselectAll);
        deselectAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TableItem[] items;
                TableItem[] tableItemArray = items = ExportTracePackageSelectTraceWizardPage.this.fTraceTable.getItems();
                int n = items.length;
                int n2 = 0;
                while (n2 < n) {
                    TableItem item = tableItemArray[n2];
                    item.setChecked(false);
                    ++n2;
                }
                ExportTracePackageSelectTraceWizardPage.this.getWizard().getContainer().updateButtons();
                ExportTracePackageSelectTraceWizardPage.this.updateNextPageData();
            }
        });
        this.setControl((Control)projectSelectionGroup);
        this.setTitle(Messages.ExportTracePackageWizardPage_Title);
        this.setMessage(Messages.ExportTracePackageSelectTraceWizardPage_ChooseTrace);
    }

    private ArrayList<TmfTraceElement> getCheckedTraces() {
        TableItem[] items = this.fTraceTable.getItems();
        ArrayList<TmfTraceElement> traces = new ArrayList<TmfTraceElement>();
        TableItem[] tableItemArray = items;
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem item = tableItemArray[n2];
            if (item.getChecked()) {
                TmfTraceElement trace = (TmfTraceElement)item.getData();
                traces.add(trace);
            }
            ++n2;
        }
        return traces;
    }

    private void updateNextPageData() {
        ExportTracePackageWizardPage page = (ExportTracePackageWizardPage)this.getWizard().getPage("ExportTracePackageWizardPage");
        page.setSelectedTraces(this.getCheckedTraces());
    }

    public boolean canFlipToNextPage() {
        return this.getCheckedTraces().size() > 0;
    }

    private class ExportLabelProvider
    extends TmfNavigatorLabelProvider {
        private ExportLabelProvider() {
        }

        @Override
        public String getText(Object element) {
            if (element instanceof TmfTraceElement) {
                TmfTraceElement folder = (TmfTraceElement)element;
                return folder.getElementPath();
            }
            return super.getText(element);
        }
    }
}

