/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.tmf.ui.project.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.linuxtools.tmf.ui.project.model.ITmfProjectModelElement;
import org.eclipse.linuxtools.tmf.ui.project.model.TmfExperimentElement;
import org.eclipse.linuxtools.tmf.ui.project.model.TmfProjectElement;
import org.eclipse.linuxtools.tmf.ui.project.model.TmfProjectModelElement;
import org.eclipse.linuxtools.tmf.ui.properties.ReadOnlyTextPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource2;

public class TmfExperimentFolder
extends TmfProjectModelElement
implements IPropertySource2 {
    public static final String EXPER_FOLDER_NAME = "Experiments";
    private static final String sfInfoCategory = "Info";
    private static final String sfName = "name";
    private static final String sfPath = "path";
    private static final String sfLocation = "location";
    private static final ReadOnlyTextPropertyDescriptor sfNameDescriptor = new ReadOnlyTextPropertyDescriptor("name", "name");
    private static final ReadOnlyTextPropertyDescriptor sfPathDescriptor = new ReadOnlyTextPropertyDescriptor("path", "path");
    private static final ReadOnlyTextPropertyDescriptor sfLocationDescriptor = new ReadOnlyTextPropertyDescriptor("location", "location");
    private static final IPropertyDescriptor[] sfDescriptors = new IPropertyDescriptor[]{sfNameDescriptor, sfPathDescriptor, sfLocationDescriptor};

    static {
        sfNameDescriptor.setCategory(sfInfoCategory);
        sfPathDescriptor.setCategory(sfInfoCategory);
        sfLocationDescriptor.setCategory(sfInfoCategory);
    }

    public TmfExperimentFolder(String name, IFolder folder, TmfProjectElement parent) {
        super(name, (IResource)folder, parent);
        parent.addChild(this);
    }

    public IFolder getResource() {
        return (IFolder)this.fResource;
    }

    @Override
    void refreshChildren() {
        IFolder folder = this.getResource();
        HashMap<String, ITmfProjectModelElement> childrenMap = new HashMap<String, ITmfProjectModelElement>();
        for (ITmfProjectModelElement element : this.getChildren()) {
            childrenMap.put(element.getResource().getName(), element);
        }
        try {
            IResource[] members;
            IResource[] iResourceArray = members = folder.members();
            int n = members.length;
            int n2 = 0;
            while (n2 < n) {
                IResource resource = iResourceArray[n2];
                if (resource instanceof IFolder) {
                    IFolder expFolder = (IFolder)resource;
                    String name = resource.getName();
                    ITmfProjectModelElement element = (ITmfProjectModelElement)childrenMap.get(name);
                    if (element instanceof TmfExperimentElement) {
                        childrenMap.remove(name);
                    } else {
                        element = new TmfExperimentElement(name, expFolder, this);
                    }
                    ((TmfExperimentElement)element).refreshChildren();
                }
                ++n2;
            }
        }
        catch (CoreException members) {
            // empty catch block
        }
        for (ITmfProjectModelElement danglingChild : childrenMap.values()) {
            this.removeChild(danglingChild);
        }
    }

    public List<TmfExperimentElement> getExperiments() {
        List<ITmfProjectModelElement> children = this.getChildren();
        ArrayList<TmfExperimentElement> traces = new ArrayList<TmfExperimentElement>();
        for (ITmfProjectModelElement child : children) {
            if (!(child instanceof TmfExperimentElement)) continue;
            traces.add((TmfExperimentElement)child);
        }
        return traces;
    }

    public Object getEditableValue() {
        return null;
    }

    public IPropertyDescriptor[] getPropertyDescriptors() {
        return Arrays.copyOf(sfDescriptors, sfDescriptors.length);
    }

    public Object getPropertyValue(Object id) {
        if (sfName.equals(id)) {
            return this.getName();
        }
        if (sfPath.equals(id)) {
            return this.getPath().toString();
        }
        if (sfLocation.equals(id)) {
            return this.getLocation().toString();
        }
        return null;
    }

    public void resetPropertyValue(Object id) {
    }

    public void setPropertyValue(Object id, Object value) {
    }

    public boolean isPropertyResettable(Object id) {
        return false;
    }

    public boolean isPropertySet(Object id) {
        return false;
    }
}

