/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.tmf.ui.project.model;

import java.net.URI;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.linuxtools.internal.tmf.ui.Activator;
import org.eclipse.linuxtools.tmf.core.TmfCommonConstants;
import org.eclipse.linuxtools.tmf.core.event.ITmfEvent;
import org.eclipse.linuxtools.tmf.core.parsers.custom.CustomTxtEvent;
import org.eclipse.linuxtools.tmf.core.parsers.custom.CustomTxtTrace;
import org.eclipse.linuxtools.tmf.core.parsers.custom.CustomTxtTraceDefinition;
import org.eclipse.linuxtools.tmf.core.parsers.custom.CustomXmlEvent;
import org.eclipse.linuxtools.tmf.core.parsers.custom.CustomXmlTrace;
import org.eclipse.linuxtools.tmf.core.parsers.custom.CustomXmlTraceDefinition;
import org.eclipse.linuxtools.tmf.core.trace.ITmfTrace;
import org.eclipse.linuxtools.tmf.core.trace.ITmfTraceProperties;
import org.eclipse.linuxtools.tmf.core.trace.TmfTrace;
import org.eclipse.linuxtools.tmf.core.trace.TmfTraceManager;
import org.eclipse.linuxtools.tmf.ui.project.model.Messages;
import org.eclipse.linuxtools.tmf.ui.project.model.TmfCommonProjectElement;
import org.eclipse.linuxtools.tmf.ui.project.model.TmfExperimentElement;
import org.eclipse.linuxtools.tmf.ui.project.model.TmfExperimentFolder;
import org.eclipse.linuxtools.tmf.ui.project.model.TmfTraceFolder;
import org.eclipse.linuxtools.tmf.ui.properties.ReadOnlyTextPropertyDescriptor;
import org.eclipse.ui.IActionFilter;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource2;

public class TmfTraceElement
extends TmfCommonProjectElement
implements IActionFilter,
IPropertySource2 {
    public static final String BUNDLE = "bundle";
    public static final String IS_LINKED = "isLinked";
    private static final String sfResourcePropertiesCategory = Messages.TmfTraceElement_ResourceProperties;
    private static final String sfName = Messages.TmfTraceElement_Name;
    private static final String sfPath = Messages.TmfTraceElement_Path;
    private static final String sfLocation = Messages.TmfTraceElement_Location;
    private static final String sfEventType = Messages.TmfTraceElement_EventType;
    private static final String sfIsLinked = Messages.TmfTraceElement_IsLinked;
    private static final String sfSourceLocation = Messages.TmfTraceElement_SourceLocation;
    private static final String sfTracePropertiesCategory = Messages.TmfTraceElement_TraceProperties;
    private static final ReadOnlyTextPropertyDescriptor sfNameDescriptor = new ReadOnlyTextPropertyDescriptor(sfName, sfName);
    private static final ReadOnlyTextPropertyDescriptor sfPathDescriptor = new ReadOnlyTextPropertyDescriptor(sfPath, sfPath);
    private static final ReadOnlyTextPropertyDescriptor sfLocationDescriptor = new ReadOnlyTextPropertyDescriptor(sfLocation, sfLocation);
    private static final ReadOnlyTextPropertyDescriptor sfTypeDescriptor = new ReadOnlyTextPropertyDescriptor(sfEventType, sfEventType);
    private static final ReadOnlyTextPropertyDescriptor sfIsLinkedDescriptor = new ReadOnlyTextPropertyDescriptor(sfIsLinked, sfIsLinked);
    private static final ReadOnlyTextPropertyDescriptor sfSourceLocationDescriptor = new ReadOnlyTextPropertyDescriptor(sfSourceLocation, sfSourceLocation);
    private static final IPropertyDescriptor[] sfDescriptors = new IPropertyDescriptor[]{sfNameDescriptor, sfPathDescriptor, sfLocationDescriptor, sfTypeDescriptor, sfIsLinkedDescriptor, sfSourceLocationDescriptor};
    private static final Map<String, IConfigurationElement> sfTraceTypeAttributes;
    private static final Map<String, IConfigurationElement> sfTraceTypeUIAttributes;
    private static final Map<String, IConfigurationElement> sfTraceCategories;

    static {
        sfNameDescriptor.setCategory(sfResourcePropertiesCategory);
        sfPathDescriptor.setCategory(sfResourcePropertiesCategory);
        sfLocationDescriptor.setCategory(sfResourcePropertiesCategory);
        sfTypeDescriptor.setCategory(sfResourcePropertiesCategory);
        sfIsLinkedDescriptor.setCategory(sfResourcePropertiesCategory);
        sfSourceLocationDescriptor.setCategory(sfResourcePropertiesCategory);
        sfTraceTypeAttributes = new HashMap<String, IConfigurationElement>();
        sfTraceTypeUIAttributes = new HashMap<String, IConfigurationElement>();
        sfTraceCategories = new HashMap<String, IConfigurationElement>();
    }

    public static void init() {
        IConfigurationElement ce;
        IConfigurationElement[] config;
        IConfigurationElement[] iConfigurationElementArray = config = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.linuxtools.tmf.core.tracetype");
        int n = config.length;
        int n2 = 0;
        while (n2 < n) {
            ce = iConfigurationElementArray[n2];
            switch (ce.getName()) {
                case "type": {
                    String traceTypeId = ce.getAttribute("id");
                    sfTraceTypeAttributes.put(traceTypeId, ce);
                    break;
                }
                case "category": {
                    String categoryId = ce.getAttribute("id");
                    sfTraceCategories.put(categoryId, ce);
                }
            }
            ++n2;
        }
        iConfigurationElementArray = config = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.linuxtools.tmf.ui.tracetypeui");
        n = config.length;
        n2 = 0;
        while (n2 < n) {
            ce = iConfigurationElementArray[n2];
            String elemName = ce.getName();
            if ("type".equals(elemName)) {
                String traceType = ce.getAttribute("tracetype");
                sfTraceTypeUIAttributes.put(traceType, ce);
            }
            ++n2;
        }
    }

    public TmfTraceElement(String name, IResource trace, TmfTraceFolder parent) {
        super(name, trace, parent);
    }

    public TmfTraceElement(String name, IResource trace, TmfExperimentElement parent) {
        super(name, trace, parent);
    }

    @Override
    public ITmfTrace instantiateTrace() {
        block9: {
            IConfigurationElement ce;
            block10: {
                CustomTxtTraceDefinition def;
                int n;
                int n2;
                CustomTxtTraceDefinition[] customTxtTraceDefinitionArray;
                this.refreshSupplementaryFolder();
                if (this.getTraceType() == null) break block9;
                if (this.getTraceType().startsWith(CustomTxtTrace.class.getCanonicalName())) {
                    customTxtTraceDefinitionArray = CustomTxtTraceDefinition.loadAll();
                    n2 = customTxtTraceDefinitionArray.length;
                    n = 0;
                    while (n < n2) {
                        def = customTxtTraceDefinitionArray[n];
                        if (this.getTraceType().equals(String.valueOf(CustomTxtTrace.class.getCanonicalName()) + ":" + def.definitionName)) {
                            return new CustomTxtTrace(def);
                        }
                        ++n;
                    }
                }
                if (this.getTraceType().startsWith(CustomXmlTrace.class.getCanonicalName())) {
                    customTxtTraceDefinitionArray = CustomXmlTraceDefinition.loadAll();
                    n2 = customTxtTraceDefinitionArray.length;
                    n = 0;
                    while (n < n2) {
                        def = customTxtTraceDefinitionArray[n];
                        if (this.getTraceType().equals(String.valueOf(CustomXmlTrace.class.getCanonicalName()) + ":" + def.definitionName)) {
                            return new CustomXmlTrace((CustomXmlTraceDefinition)def);
                        }
                        ++n;
                    }
                }
                if ((ce = sfTraceTypeAttributes.get(this.getTraceType())) != null) break block10;
                return null;
            }
            try {
                ITmfTrace trace = (ITmfTrace)ce.createExecutableExtension("trace_type");
                return trace;
            }
            catch (CoreException e) {
                Activator.getDefault().logError("Error instantiating ITmfTrace object for trace " + this.getName(), e);
            }
        }
        return null;
    }

    public ITmfEvent instantiateEvent() {
        block9: {
            IConfigurationElement ce;
            block10: {
                CustomTxtTraceDefinition def;
                int n;
                int n2;
                CustomTxtTraceDefinition[] customTxtTraceDefinitionArray;
                if (this.getTraceType() == null) break block9;
                if (this.getTraceType().startsWith(CustomTxtTrace.class.getCanonicalName())) {
                    customTxtTraceDefinitionArray = CustomTxtTraceDefinition.loadAll();
                    n2 = customTxtTraceDefinitionArray.length;
                    n = 0;
                    while (n < n2) {
                        def = customTxtTraceDefinitionArray[n];
                        if (this.getTraceType().equals(String.valueOf(CustomTxtTrace.class.getCanonicalName()) + ":" + def.definitionName)) {
                            return new CustomTxtEvent(def);
                        }
                        ++n;
                    }
                }
                if (this.getTraceType().startsWith(CustomXmlTrace.class.getCanonicalName())) {
                    customTxtTraceDefinitionArray = CustomXmlTraceDefinition.loadAll();
                    n2 = customTxtTraceDefinitionArray.length;
                    n = 0;
                    while (n < n2) {
                        def = customTxtTraceDefinitionArray[n];
                        if (this.getTraceType().equals(String.valueOf(CustomXmlTrace.class.getCanonicalName()) + ":" + def.definitionName)) {
                            return new CustomXmlEvent((CustomXmlTraceDefinition)def);
                        }
                        ++n;
                    }
                }
                if ((ce = sfTraceTypeAttributes.get(this.getTraceType())) != null) break block10;
                return null;
            }
            try {
                ITmfEvent event = (ITmfEvent)ce.createExecutableExtension("event_type");
                return event;
            }
            catch (CoreException e) {
                Activator.getDefault().logError("Error instantiating ITmfEvent object for trace " + this.getName(), e);
            }
        }
        return null;
    }

    @Override
    public String getEditorId() {
        if (this.getTraceType() != null) {
            if (this.getTraceType().startsWith(CustomTxtTrace.class.getCanonicalName())) {
                return "org.eclipse.linuxtools.tmf.ui.editors.events";
            }
            if (this.getTraceType().startsWith(CustomXmlTrace.class.getCanonicalName())) {
                return "org.eclipse.linuxtools.tmf.ui.editors.events";
            }
            IConfigurationElement ce = sfTraceTypeUIAttributes.get(this.getTraceType());
            if (ce == null) {
                return null;
            }
            IConfigurationElement[] defaultEditorCE = ce.getChildren("defaultEditor");
            if (defaultEditorCE.length == 1) {
                return defaultEditorCE[0].getAttribute("id");
            }
        }
        return null;
    }

    @Override
    public IFile createBookmarksFile() throws CoreException {
        IFile file = this.getBookmarksFile();
        if (this.fResource instanceof IFolder) {
            return this.createBookmarksFile(this.getProject().getTracesFolder().getResource(), TmfTrace.class.getCanonicalName());
        }
        return file;
    }

    @Override
    public IFile getBookmarksFile() {
        IFile file = null;
        if (this.fResource instanceof IFile) {
            file = (IFile)this.fResource;
        } else if (this.fResource instanceof IFolder) {
            IFolder folder = (IFolder)this.fResource;
            file = folder.getFile(String.valueOf(this.getName()) + '_');
        }
        return file;
    }

    public TmfTraceElement getElementUnderTraceFolder() {
        if (this.getParent() instanceof TmfExperimentElement) {
            for (TmfTraceElement aTrace : this.getProject().getTracesFolder().getTraces()) {
                if (!aTrace.getElementPath().equals(this.getElementPath())) continue;
                return aTrace;
            }
        }
        return this;
    }

    @Override
    public String getTypeName() {
        return Messages.TmfTraceElement_TypeName;
    }

    public boolean testAttribute(Object target, String name, String value) {
        if (name.equals(IS_LINKED)) {
            boolean isLinked = this.getResource().isLinked();
            return Boolean.toString(isLinked).equals(value);
        }
        return false;
    }

    public Object getEditableValue() {
        return null;
    }

    private Map<String, String> getTraceProperties() {
        for (ITmfTrace openedTrace : TmfTraceManager.getInstance().getOpenedTraces()) {
            ITmfTrace[] iTmfTraceArray = TmfTraceManager.getTraceSet((ITmfTrace)openedTrace);
            int n = iTmfTraceArray.length;
            int n2 = 0;
            while (n2 < n) {
                ITmfTrace singleTrace = iTmfTraceArray[n2];
                if (this.getLocation().getPath().endsWith(singleTrace.getPath()) && singleTrace instanceof ITmfTraceProperties) {
                    ITmfTraceProperties traceProperties = (ITmfTraceProperties)singleTrace;
                    return traceProperties.getTraceProperties();
                }
                ++n2;
            }
        }
        return new HashMap<String, String>();
    }

    public IPropertyDescriptor[] getPropertyDescriptors() {
        Map<String, String> traceProperties = this.getTraceProperties();
        if (!traceProperties.isEmpty()) {
            IPropertyDescriptor[] propertyDescriptorArray = new IPropertyDescriptor[traceProperties.size() + sfDescriptors.length];
            int index = 0;
            for (Map.Entry<String, String> varName : traceProperties.entrySet()) {
                ReadOnlyTextPropertyDescriptor descriptor = new ReadOnlyTextPropertyDescriptor(String.valueOf(this.getName()) + "_" + varName.getKey(), varName.getKey());
                descriptor.setCategory(sfTracePropertiesCategory);
                propertyDescriptorArray[index] = descriptor;
                ++index;
            }
            int i = 0;
            while (i < sfDescriptors.length) {
                propertyDescriptorArray[index] = sfDescriptors[i];
                ++index;
                ++i;
            }
            return propertyDescriptorArray;
        }
        return Arrays.copyOf(sfDescriptors, sfDescriptors.length);
    }

    public Object getPropertyValue(Object id) {
        if (sfName.equals(id)) {
            return this.getName();
        }
        if (sfPath.equals(id)) {
            return this.getPath().toString();
        }
        if (sfLocation.equals(id)) {
            return URIUtil.toUnencodedString((URI)this.getLocation());
        }
        if (sfIsLinked.equals(id)) {
            return Boolean.valueOf(this.getResource().isLinked()).toString();
        }
        if (sfSourceLocation.equals(id)) {
            try {
                String sourceLocation = this.getElementUnderTraceFolder().getResource().getPersistentProperty(TmfCommonConstants.SOURCE_LOCATION);
                if (sourceLocation != null) {
                    return sourceLocation;
                }
            }
            catch (CoreException sourceLocation) {
                // empty catch block
            }
            return "";
        }
        if (sfEventType.equals(id)) {
            if (this.getTraceType() != null) {
                IConfigurationElement ce = sfTraceTypeAttributes.get(this.getTraceType());
                return ce != null ? String.valueOf(TmfTraceElement.getCategory(ce)) + " : " + ce.getAttribute("name") : "";
            }
            return "";
        }
        Map<String, String> traceProperties = this.getTraceProperties();
        if (id != null && !traceProperties.isEmpty()) {
            String key = (String)id;
            key = key.substring(this.getName().length() + 1);
            String value = traceProperties.get(key);
            return value;
        }
        return null;
    }

    private static String getCategory(IConfigurationElement ce) {
        IConfigurationElement category;
        String categoryId = ce.getAttribute("category");
        if (categoryId != null && (category = sfTraceCategories.get(categoryId)) != null) {
            return category.getAttribute("name");
        }
        return "[no category]";
    }

    public void resetPropertyValue(Object id) {
    }

    public void setPropertyValue(Object id, Object value) {
    }

    public boolean isPropertyResettable(Object id) {
        return false;
    }

    public boolean isPropertySet(Object id) {
        return false;
    }

    public TmfTraceElement copy(String newName) {
        TmfTraceFolder folder = (TmfTraceFolder)this.getParent();
        IResource res = super.copy(newName, false);
        for (TmfTraceElement trace : folder.getTraces()) {
            if (!trace.getResource().equals((Object)res)) continue;
            return trace;
        }
        return null;
    }

    @Override
    public void closeEditors() {
        super.closeEditors();
        if (this.getParent() instanceof TmfTraceFolder) {
            TmfExperimentFolder experimentsFolder = this.getProject().getExperimentsFolder();
            block0: for (TmfExperimentElement experiment : experimentsFolder.getExperiments()) {
                for (TmfTraceElement trace : experiment.getTraces()) {
                    if (!trace.getElementPath().equals(this.getElementPath())) continue;
                    experiment.closeEditors();
                    continue block0;
                }
            }
        } else if (this.getParent() instanceof TmfExperimentElement) {
            TmfExperimentElement experiment = (TmfExperimentElement)this.getParent();
            experiment.closeEditors();
        }
        System.gc();
    }

    public void delete(IProgressMonitor progressMonitor) throws CoreException {
        this.closeEditors();
        IPath path = this.fResource.getLocation();
        if (path != null) {
            if (this.getParent() instanceof TmfTraceFolder) {
                TmfExperimentFolder experimentFolder = this.getProject().getExperimentsFolder();
                for (TmfExperimentElement experiment : experimentFolder.getExperiments()) {
                    LinkedList<TmfTraceElement> toRemove = new LinkedList<TmfTraceElement>();
                    for (TmfTraceElement trace : experiment.getTraces()) {
                        if (!trace.getElementPath().equals(this.getElementPath())) continue;
                        toRemove.add(trace);
                    }
                    for (TmfTraceElement child : toRemove) {
                        experiment.removeTrace(child);
                    }
                }
                this.deleteSupplementaryFolder();
            } else if (this.getParent() instanceof TmfExperimentElement) {
                TmfExperimentElement experimentElement = (TmfExperimentElement)this.getParent();
                experimentElement.removeTrace(this);
            }
        }
        this.fResource.delete(true, progressMonitor);
    }
}

