/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.tmf.ui.project.wizards;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.linuxtools.tmf.ui.project.model.TmfTraceElement;
import org.eclipse.linuxtools.tmf.ui.project.wizards.Messages;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.SelectionStatusDialog;

public class RenameTraceDialog
extends SelectionStatusDialog {
    private final TmfTraceElement fTrace;
    private Text fNewTraceNameText;

    public RenameTraceDialog(Shell shell, TmfTraceElement trace) {
        super(shell);
        this.fTrace = trace;
        this.setTitle(Messages.RenameTraceDialog_DialogTitle);
        this.setStatusLineAboveButtons(true);
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(1808));
        this.createNewTraceNameGroup(composite);
        return composite;
    }

    private void createNewTraceNameGroup(Composite parent) {
        Font font = parent.getFont();
        Composite folderGroup = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        folderGroup.setLayout((Layout)layout);
        folderGroup.setLayoutData((Object)new GridData(768));
        Label oldTraceLabel = new Label(folderGroup, 0);
        oldTraceLabel.setFont(font);
        oldTraceLabel.setText(Messages.RenameTraceDialog_TraceName);
        Text oldTraceName = new Text(folderGroup, 2048);
        GridData data = new GridData(768);
        data.widthHint = 200;
        oldTraceName.setLayoutData((Object)data);
        oldTraceName.setFont(font);
        oldTraceName.setText(this.fTrace.getName());
        oldTraceName.setEnabled(false);
        Label newTaceLabel = new Label(folderGroup, 0);
        newTaceLabel.setFont(font);
        newTaceLabel.setText(Messages.RenameTraceDialog_TraceNewName);
        this.fNewTraceNameText = new Text(folderGroup, 2048);
        data = new GridData(768);
        data.widthHint = 200;
        this.fNewTraceNameText.setLayoutData((Object)data);
        this.fNewTraceNameText.setFont(font);
        this.fNewTraceNameText.addListener(24, new Listener(){

            public void handleEvent(Event event) {
                RenameTraceDialog.this.validateNewTraceName();
            }
        });
    }

    private void validateNewTraceName() {
        String newTraceName = this.fNewTraceNameText.getText();
        IWorkspace workspace = this.fTrace.getResource().getWorkspace();
        IStatus nameStatus = workspace.validateName(newTraceName, 2);
        if ("".equals(newTraceName)) {
            this.updateStatus((IStatus)new Status(4, "org.eclipse.linuxtools.tmf.ui", 4, Messages.Dialog_EmptyNameError, null));
            return;
        }
        if (!nameStatus.isOK()) {
            this.updateStatus(nameStatus);
            return;
        }
        IContainer parentFolder = this.fTrace.getResource().getParent();
        if (parentFolder.findMember(newTraceName) != null) {
            this.updateStatus((IStatus)new Status(4, "org.eclipse.linuxtools.tmf.ui", 4, Messages.Dialog_ExistingNameError, null));
            return;
        }
        this.updateStatus((IStatus)new Status(0, "org.eclipse.linuxtools.tmf.ui", ""));
    }

    protected void computeResult() {
    }

    public void create() {
        super.create();
        this.getButton(0).setEnabled(false);
    }

    protected void okPressed() {
        this.setSelectionResult(new String[]{this.fNewTraceNameText.getText()});
        super.okPressed();
    }
}

