/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.tmf.ui.views.histogram;

import java.util.Arrays;
import org.eclipse.linuxtools.tmf.ui.views.histogram.HistogramBucket;

public class HistogramScaledData {
    public static final int OUT_OF_RANGE_BUCKET = -1;
    public int fWidth;
    public int fHeight;
    public int fBarWidth;
    public HistogramBucket[] fData;
    public final int[] fLostEventsData;
    public long fBucketDuration;
    public long fMaxValue;
    public long fMaxCombinedValue;
    public int fSelectionBeginBucket;
    public int fSelectionEndBucket;
    public int fLastBucket;
    public double fScalingFactor;
    public double fScalingFactorCombined;
    public long fFirstBucketTime;
    public long fFirstEventTime;
    public static volatile boolean hideLostEvents = false;

    public HistogramScaledData(int width, int height, int barWidth) {
        this.fWidth = width;
        this.fHeight = height;
        this.fBarWidth = barWidth;
        this.fData = new HistogramBucket[width / this.fBarWidth];
        this.fLostEventsData = new int[width / this.fBarWidth];
        this.fBucketDuration = 1L;
        this.fMaxValue = 0L;
        this.fMaxCombinedValue = 0L;
        this.fSelectionBeginBucket = 0;
        this.fSelectionEndBucket = 0;
        this.fLastBucket = 0;
        this.fScalingFactor = 1.0;
        this.fScalingFactorCombined = 1.0;
        this.fFirstBucketTime = 0L;
    }

    public HistogramScaledData(HistogramScaledData other) {
        this.fWidth = other.fWidth;
        this.fHeight = other.fHeight;
        this.fBarWidth = other.fBarWidth;
        this.fData = Arrays.copyOf(other.fData, other.fData.length);
        this.fLostEventsData = Arrays.copyOf(other.fLostEventsData, other.fLostEventsData.length);
        this.fBucketDuration = other.fBucketDuration;
        this.fMaxValue = other.fMaxValue;
        this.fMaxCombinedValue = other.fMaxCombinedValue;
        this.fSelectionBeginBucket = other.fSelectionBeginBucket;
        this.fSelectionEndBucket = other.fSelectionEndBucket;
        this.fLastBucket = other.fLastBucket;
        this.fScalingFactor = other.fScalingFactor;
        this.fScalingFactorCombined = other.fScalingFactorCombined;
        this.fFirstBucketTime = other.fFirstBucketTime;
    }

    public long getFirstBucketTime() {
        return this.fFirstBucketTime;
    }

    public void setFirstBucketTime(long firstEventTime) {
        this.fFirstBucketTime = firstEventTime;
    }

    public long getLastBucketTime() {
        return this.getBucketStartTime(this.fLastBucket);
    }

    public long getBucketStartTime(int index) {
        return this.fFirstBucketTime + (long)index * this.fBucketDuration;
    }

    public long getBucketEndTime(int index) {
        return this.getBucketStartTime(index) + this.fBucketDuration;
    }
}

