/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.tmf.ui.views.statesystem;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.linuxtools.statesystem.core.ITmfStateSystem;
import org.eclipse.linuxtools.statesystem.core.exceptions.AttributeNotFoundException;
import org.eclipse.linuxtools.statesystem.core.exceptions.StateSystemDisposedException;
import org.eclipse.linuxtools.statesystem.core.exceptions.TimeRangeException;
import org.eclipse.linuxtools.statesystem.core.interval.ITmfStateInterval;
import org.eclipse.linuxtools.statesystem.core.statevalue.ITmfStateValue;
import org.eclipse.linuxtools.tmf.core.signal.TmfSignalHandler;
import org.eclipse.linuxtools.tmf.core.signal.TmfTimestampFormatUpdateSignal;
import org.eclipse.linuxtools.tmf.core.statesystem.ITmfAnalysisModuleWithStateSystems;
import org.eclipse.linuxtools.tmf.core.timestamp.TmfTimestamp;
import org.eclipse.linuxtools.tmf.core.trace.ITmfTrace;
import org.eclipse.linuxtools.tmf.core.trace.TmfTraceManager;
import org.eclipse.linuxtools.tmf.ui.viewers.tree.AbstractTmfTreeViewer;
import org.eclipse.linuxtools.tmf.ui.viewers.tree.ITmfTreeColumnDataProvider;
import org.eclipse.linuxtools.tmf.ui.viewers.tree.ITmfTreeViewerEntry;
import org.eclipse.linuxtools.tmf.ui.viewers.tree.TmfTreeColumnData;
import org.eclipse.linuxtools.tmf.ui.viewers.tree.TmfTreeViewerEntry;
import org.eclipse.linuxtools.tmf.ui.views.statesystem.Messages;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;

public class TmfStateSystemViewer
extends AbstractTmfTreeViewer {
    private static final String EMPTY_STRING = "";
    private boolean fFilterStatus = false;
    private static final int DEFAULT_AUTOEXPAND = 2;
    private static final int ATTRIBUTE_NAME_COL = 0;
    private static final int QUARK_COL = 1;
    private static final int VALUE_COL = 2;
    private static final int TYPE_COL = 3;
    private static final int START_TIME_COL = 4;
    private static final int END_TIME_COL = 5;
    private static final int ATTRIBUTE_FULLPATH_COL = 6;

    public TmfStateSystemViewer(Composite parent) {
        super(parent, false);
        this.setLabelProvider((IBaseLabelProvider)new StateSystemTreeLabelProvider());
        this.getTreeViewer().setAutoExpandLevel(2);
    }

    @Override
    protected ITmfTreeColumnDataProvider getColumnDataProvider() {
        return new ITmfTreeColumnDataProvider(){

            @Override
            public List<TmfTreeColumnData> getColumnData() {
                ArrayList<TmfTreeColumnData> columns = new ArrayList<TmfTreeColumnData>();
                TmfTreeColumnData column = new TmfTreeColumnData(Messages.TreeNodeColumnLabel);
                columns.add(column);
                column.setComparator(new ViewerComparator(){

                    public int compare(Viewer viewer, Object e1, Object e2) {
                        TmfTreeViewerEntry n1 = (TmfTreeViewerEntry)e1;
                        TmfTreeViewerEntry n2 = (TmfTreeViewerEntry)e2;
                        return n1.getName().compareTo(n2.getName());
                    }
                });
                columns.add(new TmfTreeColumnData(Messages.QuarkColumnLabel));
                columns.add(new TmfTreeColumnData(Messages.ValueColumnLabel));
                columns.add(new TmfTreeColumnData(Messages.TypeColumnLabel));
                columns.add(new TmfTreeColumnData(Messages.StartTimeColumLabel));
                columns.add(new TmfTreeColumnData(Messages.EndTimeColumLabel));
                columns.add(new TmfTreeColumnData(Messages.AttributePathColumnLabel));
                return columns;
            }
        };
    }

    @Override
    protected ITmfTreeViewerEntry updateElements(long start, long end, boolean selection) {
        if (this.getTrace() == null) {
            return null;
        }
        ITmfTreeViewerEntry root = this.getInput();
        if (!selection && root != null) {
            return null;
        }
        if (root == null || this.fFilterStatus) {
            root = this.buildEntries(start);
        } else if (root instanceof TmfTreeViewerEntry) {
            this.updateEntriesList(((TmfTreeViewerEntry)root).getChildren(), start);
        }
        return root;
    }

    private ITmfTreeViewerEntry buildEntries(long timestamp) {
        TmfTreeViewerEntry rootEntry = new TmfTreeViewerEntry(EMPTY_STRING);
        List<ITmfTreeViewerEntry> children = rootEntry.getChildren();
        ITmfTrace[] iTmfTraceArray = TmfTraceManager.getTraceSet((ITmfTrace)this.getTrace());
        int n = iTmfTraceArray.length;
        int n2 = 0;
        while (n2 < n) {
            ITmfTrace currentTrace = iTmfTraceArray[n2];
            if (currentTrace != null) {
                this.buildEntriesForTrace(currentTrace, timestamp, children);
            }
            ++n2;
        }
        return rootEntry;
    }

    private void updateEntriesList(List<ITmfTreeViewerEntry> entries, long timestamp) {
        ITmfTrace[] iTmfTraceArray = TmfTraceManager.getTraceSet((ITmfTrace)this.getTrace());
        int n = iTmfTraceArray.length;
        int n2 = 0;
        while (n2 < n) {
            ITmfTrace trace = iTmfTraceArray[n2];
            if (trace != null) {
                ITmfTreeViewerEntry traceEntry = null;
                for (ITmfTreeViewerEntry entry : entries) {
                    if (!entry.getName().equals(trace.getName())) continue;
                    traceEntry = entry;
                }
                if (traceEntry == null) {
                    traceEntry = this.buildEntriesForTrace(trace, timestamp, entries);
                }
                Iterable modules = trace.getAnalysisModulesOfClass(ITmfAnalysisModuleWithStateSystems.class);
                for (ITmfAnalysisModuleWithStateSystems module : modules) {
                    module.schedule();
                    for (ITmfStateSystem ss : module.getStateSystems()) {
                        if (ss == null) continue;
                        ITmfTreeViewerEntry ssEntry = null;
                        for (ITmfTreeViewerEntry iTmfTreeViewerEntry : traceEntry.getChildren()) {
                            if (!iTmfTreeViewerEntry.getName().equals(ss.getSSID())) continue;
                            ssEntry = iTmfTreeViewerEntry;
                        }
                        if (ssEntry == null) {
                            this.buildEntriesForStateSystem(ss, timestamp, (TmfTreeViewerEntry)traceEntry);
                            continue;
                        }
                        if (ssEntry.hasChildren()) {
                            this.updateEntriesForStateSystem(ss, timestamp, (TmfTreeViewerEntry)ssEntry);
                            continue;
                        }
                        this.fillEntriesForStateSystem(ss, timestamp, (TmfTreeViewerEntry)ssEntry);
                    }
                }
            }
            ++n2;
        }
    }

    @NonNull
    private ITmfTreeViewerEntry buildEntriesForTrace(@NonNull ITmfTrace trace, long timestamp, @NonNull List<ITmfTreeViewerEntry> rootEntries) {
        TmfTreeViewerEntry traceEntry = new TmfTreeViewerEntry(trace.getName());
        rootEntries.add(traceEntry);
        Iterable modules = trace.getAnalysisModulesOfClass(ITmfAnalysisModuleWithStateSystems.class);
        for (ITmfAnalysisModuleWithStateSystems module : modules) {
            module.schedule();
            for (ITmfStateSystem ss : module.getStateSystems()) {
                if (ss == null) continue;
                this.buildEntriesForStateSystem(ss, timestamp, traceEntry);
            }
        }
        return traceEntry;
    }

    private void buildEntriesForStateSystem(ITmfStateSystem ss, long timestamp, TmfTreeViewerEntry traceEntry) {
        TmfTreeViewerEntry ssEntry = new TmfTreeViewerEntry(ss.getSSID());
        traceEntry.addChild(ssEntry);
        this.fillEntriesForStateSystem(ss, timestamp, ssEntry);
    }

    private void fillEntriesForStateSystem(ITmfStateSystem ss, long timestamp, TmfTreeViewerEntry ssEntry) {
        try {
            this.addChildren(ss, ss.queryFullState(timestamp), -1, ssEntry, timestamp);
        }
        catch (StateSystemDisposedException | TimeRangeException throwable) {
            // empty catch block
        }
    }

    private void addChildren(ITmfStateSystem ss, List<ITmfStateInterval> fullState, int rootQuark, TmfTreeViewerEntry root, long timestamp) {
        try {
            Iterator iterator = ss.getSubAttributes(rootQuark, false).iterator();
            while (iterator.hasNext()) {
                int quark = (Integer)iterator.next();
                ITmfStateInterval interval = fullState.get(quark);
                StateSystemEntry entry = new StateSystemEntry(ss.getAttributeName(quark), quark, ss.getFullAttributePath(quark), interval.getStateValue(), new TmfTimestamp(interval.getStartTime(), -9), new TmfTimestamp(interval.getEndTime(), -9));
                this.addChildren(ss, fullState, quark, entry, timestamp);
                if (this.fFilterStatus && !entry.hasChildren() && interval.getStartTime() != timestamp) continue;
                root.addChild(entry);
            }
        }
        catch (AttributeNotFoundException e) {
            throw new RuntimeException();
        }
    }

    private void updateEntriesForStateSystem(ITmfStateSystem ss, long timestamp, TmfTreeViewerEntry ssEntry) {
        try {
            this.updateChildren(ss, ss.queryFullState(timestamp), ssEntry);
        }
        catch (StateSystemDisposedException stateSystemDisposedException) {
        }
        catch (TimeRangeException e) {
            this.markOutOfRange(ssEntry);
        }
    }

    private void updateChildren(ITmfStateSystem ss, List<ITmfStateInterval> fullState, ITmfTreeViewerEntry root) {
        for (ITmfTreeViewerEntry iTmfTreeViewerEntry : root.getChildren()) {
            if (!(iTmfTreeViewerEntry instanceof StateSystemEntry)) continue;
            StateSystemEntry ssEntry = (StateSystemEntry)iTmfTreeViewerEntry;
            ITmfStateInterval interval = fullState.get(ssEntry.getQuark());
            if (interval != null) {
                ssEntry.update(interval.getStateValue(), new TmfTimestamp(interval.getStartTime(), -9), new TmfTimestamp(interval.getEndTime(), -9));
            }
            this.updateChildren(ss, fullState, ssEntry);
        }
    }

    private void markOutOfRange(ITmfTreeViewerEntry root) {
        for (ITmfTreeViewerEntry iTmfTreeViewerEntry : root.getChildren()) {
            if (!(iTmfTreeViewerEntry instanceof StateSystemEntry)) continue;
            ((StateSystemEntry)iTmfTreeViewerEntry).setOutOfRange();
            this.markOutOfRange(iTmfTreeViewerEntry);
        }
    }

    public void changeFilterStatus() {
        boolean bl = this.fFilterStatus = !this.fFilterStatus;
        if (this.fFilterStatus) {
            this.getTreeViewer().setAutoExpandLevel(-1);
        } else {
            this.getTreeViewer().setAutoExpandLevel(2);
            this.clearContent();
        }
        this.updateContent(this.getSelectionBeginTime(), this.getSelectionEndTime(), true);
    }

    @TmfSignalHandler
    public void timestampFormatUpdated(TmfTimestampFormatUpdateSignal signal) {
        this.updateContent(this.getSelectionBeginTime(), this.getSelectionEndTime(), true);
    }

    private class StateSystemEntry
    extends TmfTreeViewerEntry {
        private final int fQuark;
        private final String fFullPath;
        @NonNull
        private TmfTimestamp fStart;
        @NonNull
        private TmfTimestamp fEnd;
        private ITmfStateValue fValue;
        private boolean fModified;
        private boolean fOutOfRange;

        public StateSystemEntry(String name, int quark, String fullPath, @NonNull ITmfStateValue value, @NonNull TmfTimestamp start, TmfTimestamp end) {
            super(name);
            this.fModified = false;
            this.fOutOfRange = false;
            this.fQuark = quark;
            this.fFullPath = fullPath;
            this.fStart = start;
            this.fEnd = end;
            this.fValue = value;
        }

        public int getQuark() {
            return this.fQuark;
        }

        public String getFullPath() {
            return this.fFullPath;
        }

        public String getStartTime() {
            if (this.fOutOfRange) {
                return TmfStateSystemViewer.EMPTY_STRING;
            }
            return this.fStart.toString();
        }

        public String getEndTime() {
            if (this.fOutOfRange) {
                return TmfStateSystemViewer.EMPTY_STRING;
            }
            return this.fEnd.toString();
        }

        public String getValue() {
            if (this.fOutOfRange) {
                return Messages.OutOfRangeMsg;
            }
            switch (this.fValue.getType()) {
                case INTEGER: 
                case LONG: 
                case DOUBLE: 
                case STRING: {
                    return this.fValue.toString();
                }
            }
            return TmfStateSystemViewer.EMPTY_STRING;
        }

        public String getType() {
            if (this.fOutOfRange) {
                return TmfStateSystemViewer.EMPTY_STRING;
            }
            switch (this.fValue.getType()) {
                case INTEGER: {
                    return Messages.TypeInteger;
                }
                case LONG: {
                    return Messages.TypeLong;
                }
                case DOUBLE: {
                    return Messages.TypeDouble;
                }
                case STRING: {
                    return Messages.TypeString;
                }
            }
            return TmfStateSystemViewer.EMPTY_STRING;
        }

        public boolean isModified() {
            return this.fModified;
        }

        public void update(ITmfStateValue value, @NonNull TmfTimestamp start, @NonNull TmfTimestamp end) {
            this.fModified = false;
            this.fOutOfRange = false;
            if (!start.equals((Object)this.fStart)) {
                this.fModified = true;
                this.fStart = start;
                this.fEnd = end;
                this.fValue = value;
            }
        }

        public void setOutOfRange() {
            this.fModified = false;
            this.fOutOfRange = true;
        }
    }

    protected static class StateSystemTreeLabelProvider
    extends AbstractTmfTreeViewer.TreeLabelProvider {
        protected StateSystemTreeLabelProvider() {
        }

        @Override
        public String getColumnText(Object element, int columnIndex) {
            if (element instanceof StateSystemEntry) {
                StateSystemEntry entry = (StateSystemEntry)element;
                switch (columnIndex) {
                    case 0: {
                        return entry.getName();
                    }
                    case 1: {
                        return String.valueOf(entry.getQuark());
                    }
                    case 2: {
                        return entry.getValue();
                    }
                    case 3: {
                        return entry.getType();
                    }
                    case 4: {
                        return entry.getStartTime();
                    }
                    case 5: {
                        return entry.getEndTime();
                    }
                    case 6: {
                        return entry.getFullPath();
                    }
                }
                return TmfStateSystemViewer.EMPTY_STRING;
            }
            return super.getColumnText(element, columnIndex);
        }

        @Override
        public Color getBackground(Object element, int columnIndex) {
            if (element instanceof StateSystemEntry && ((StateSystemEntry)element).isModified()) {
                return Display.getCurrent().getSystemColor(7);
            }
            return super.getBackground(element, columnIndex);
        }
    }
}

