/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.tmf.ui.views.uml2sd.dialogs;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.DialogSettings;
import org.eclipse.linuxtools.internal.tmf.ui.Activator;
import org.eclipse.linuxtools.tmf.ui.views.uml2sd.SDView;
import org.eclipse.linuxtools.tmf.ui.views.uml2sd.core.AsyncMessage;
import org.eclipse.linuxtools.tmf.ui.views.uml2sd.core.AsyncMessageReturn;
import org.eclipse.linuxtools.tmf.ui.views.uml2sd.core.GraphNode;
import org.eclipse.linuxtools.tmf.ui.views.uml2sd.core.Lifeline;
import org.eclipse.linuxtools.tmf.ui.views.uml2sd.core.Stop;
import org.eclipse.linuxtools.tmf.ui.views.uml2sd.core.SyncMessage;
import org.eclipse.linuxtools.tmf.ui.views.uml2sd.core.SyncMessageReturn;
import org.eclipse.linuxtools.tmf.ui.views.uml2sd.dialogs.Criteria;
import org.eclipse.linuxtools.tmf.ui.views.uml2sd.dialogs.TabContents;
import org.eclipse.linuxtools.tmf.ui.views.uml2sd.handlers.provider.ISDFindProvider;
import org.eclipse.linuxtools.tmf.ui.views.uml2sd.handlers.provider.ISDGraphNodeSupporter;
import org.eclipse.linuxtools.tmf.ui.views.uml2sd.util.Messages;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.TabFolder;

public class SearchFilterDialog
extends Dialog {
    protected static final String FIND_CRITERIA = "findCriteria";
    protected static final String FIND_EXPRESSION_LIST = "findExpressionList";
    protected static final String FILTER_CRITERIA = "filterCriteria";
    protected static final String FILTER_EXPRESSION_LIST = "filterExpressionList";
    protected static final int MAX_EXPRESSION_LIST = 7;
    private final SDView fSdView;
    private final TabFolder fTabFolder = null;
    private Criteria fCriteria = null;
    private final ISDGraphNodeSupporter fProvider;
    private String fOkText;
    private String fTitle;
    private String[] fExpressionList;
    private boolean fIsFind;

    public SearchFilterDialog(SDView view, ISDGraphNodeSupporter provider, boolean filter, int style) {
        super(view.getSDWidget().getShell());
        this.setShellStyle(0x860 | style);
        this.fProvider = provider;
        this.fSdView = view;
        this.fIsFind = !filter;
    }

    public Control createDialogArea(Composite arg0) {
        this.fExpressionList = this.fIsFind ? Activator.getDefault().getDialogSettings().getArray(FIND_EXPRESSION_LIST) : Activator.getDefault().getDialogSettings().getArray(FILTER_EXPRESSION_LIST);
        if (this.fExpressionList == null) {
            this.fExpressionList = new String[0];
        }
        return new TabContents(arg0, this.fProvider, this.getButton(0), this.fExpressionList);
    }

    public int open() {
        this.create();
        if (this.fCriteria == null) {
            this.loadCriteria();
        }
        if (this.fCriteria == null) {
            this.fCriteria = new Criteria();
            this.fCriteria.setLifeLineSelected(this.fProvider.isNodeSupported(0));
            this.fCriteria.setSyncMessageSelected(this.fProvider.isNodeSupported(1));
            this.fCriteria.setSyncMessageReturnSelected(this.fProvider.isNodeSupported(2));
            this.fCriteria.setAsyncMessageSelected(this.fProvider.isNodeSupported(3));
            this.fCriteria.setAsyncMessageReturnSelected(this.fProvider.isNodeSupported(4));
            this.fCriteria.setStopSelected(this.fProvider.isNodeSupported(5));
        }
        this.copyFromCriteria(this.fCriteria);
        if (this.fOkText != null) {
            this.getButton(0).setText(this.fOkText);
        } else {
            this.getButton(0).setText(Messages.SequenceDiagram_Find);
        }
        if (this.fIsFind) {
            this.getButton(1).setText(Messages.SequenceDiagram_Close);
        }
        Button okButton = this.getButton(0);
        ((TabContents)this.getDialogArea()).setOkButton(okButton);
        if (!(this.fCriteria != null && this.fCriteria.getExpression() != null && !this.fCriteria.getExpression().equals("") && (this.fCriteria.isAsyncMessageReturnSelected() || this.fCriteria.isAsyncMessageSelected() || this.fCriteria.isLifeLineSelected() || this.fCriteria.isStopSelected() || this.fCriteria.isSyncMessageReturnSelected() || this.fCriteria.isSyncMessageSelected()))) {
            okButton.setEnabled(false);
        }
        if (this.fTitle != null) {
            this.getShell().setText(this.fTitle);
        } else {
            this.getShell().setText(Messages.SequenceDiagram_SequenceDiagramFind);
        }
        this.getShell().pack();
        this.getShell().setLocation(this.getShell().getDisplay().getCursorLocation());
        this.fCriteria = null;
        return super.open();
    }

    protected void loadCriteria() {
        String CRITERIA = FIND_CRITERIA;
        if (!this.fIsFind) {
            CRITERIA = FILTER_CRITERIA;
        }
        DialogSettings section = (DialogSettings)Activator.getDefault().getDialogSettings().getSection(CRITERIA);
        List<GraphNode> selection = this.fSdView.getSDWidget().getSelection();
        if (selection == null || selection.size() != 1 || !this.fIsFind) {
            if (section != null) {
                this.fCriteria = new Criteria();
                this.fCriteria.load(section);
            }
        } else {
            GraphNode gn = selection.get(0);
            this.fCriteria = new Criteria();
            this.fCriteria.setExpression(gn.getName());
            this.fCriteria.setCaseSenstiveSelected(true);
            if (gn instanceof Lifeline && this.fProvider.isNodeSupported(0)) {
                this.fCriteria.setLifeLineSelected(true);
            } else if (gn instanceof SyncMessageReturn && this.fProvider.isNodeSupported(2)) {
                this.fCriteria.setSyncMessageReturnSelected(true);
            } else if ((gn instanceof SyncMessageReturn || gn instanceof SyncMessage) && this.fProvider.isNodeSupported(1)) {
                this.fCriteria.setSyncMessageSelected(true);
            } else if (gn instanceof AsyncMessageReturn && this.fProvider.isNodeSupported(4)) {
                this.fCriteria.setAsyncMessageReturnSelected(true);
            } else if ((gn instanceof AsyncMessageReturn || gn instanceof AsyncMessage) && this.fProvider.isNodeSupported(3)) {
                this.fCriteria.setAsyncMessageSelected(true);
            } else if (gn instanceof Stop && this.fProvider.isNodeSupported(5)) {
                this.fCriteria.setStopSelected(true);
            }
        }
    }

    public void okPressed() {
        this.copyToCriteria();
        if (!this.fIsFind) {
            this.saveCriteria();
            super.close();
        }
        if (this.fProvider != null && this.fProvider instanceof ISDFindProvider && this.fIsFind) {
            boolean result = ((ISDFindProvider)this.fProvider).find(this.fCriteria);
            TabContents content = this.getTabContents();
            content.setResult(result);
        }
    }

    public void cancelPressed() {
        if (this.fIsFind) {
            this.copyToCriteria();
            if (this.fProvider instanceof ISDFindProvider) {
                ((ISDFindProvider)this.fProvider).cancel();
            }
            this.saveCriteria();
        }
        super.cancelPressed();
    }

    public void saveCriteria() {
        DialogSettings settings;
        DialogSettings section;
        String CRITERIA = FIND_CRITERIA;
        String EXPRESSION_LIST = FIND_EXPRESSION_LIST;
        if (!this.fIsFind) {
            CRITERIA = FILTER_CRITERIA;
            EXPRESSION_LIST = FILTER_EXPRESSION_LIST;
        }
        if ((section = (DialogSettings)(settings = (DialogSettings)Activator.getDefault().getDialogSettings()).getSection(CRITERIA)) == null) {
            section = (DialogSettings)settings.addNewSection(CRITERIA);
        }
        this.fCriteria.save(section);
        if (this.fCriteria.getExpression().length() > 0) {
            ArrayList<String> list = new ArrayList<String>();
            int i = 0;
            while (i < this.fExpressionList.length) {
                list.add(this.fExpressionList[i]);
                ++i;
            }
            list.remove(this.fCriteria.getExpression());
            list.add(0, this.fCriteria.getExpression());
            int size = Math.min(list.size(), 7);
            String[] temp = new String[size];
            int i2 = 0;
            while (i2 < size) {
                temp[i2] = (String)list.get(i2);
                ++i2;
            }
            this.fExpressionList = temp;
            settings.put(EXPRESSION_LIST, this.fExpressionList);
        }
    }

    public Criteria getCriteria() {
        return this.fCriteria;
    }

    public void setCriteria(Criteria criteria) {
        this.fCriteria = criteria;
    }

    public void copyToCriteria() {
        this.fCriteria = new Criteria();
        TabContents content = this.getTabContents();
        this.fCriteria.setLifeLineSelected(content.isLifelineButtonSelected());
        this.fCriteria.setSyncMessageSelected(content.isSynMessageButtonSelected());
        this.fCriteria.setSyncMessageReturnSelected(content.isSynMessageReturnButtonSelected());
        this.fCriteria.setAsyncMessageSelected(content.isAsynMessageButtonSelected());
        this.fCriteria.setAsyncMessageReturnSelected(content.isAsynMessageReturnButtonSelected());
        this.fCriteria.setStopSelected(content.isStopButtonSelected());
        this.fCriteria.setCaseSenstiveSelected(content.isCaseSensitiveSelected());
        this.fCriteria.setExpression(content.getSearchText());
    }

    protected TabContents getTabContents() {
        TabContents content = null;
        content = this.fTabFolder == null ? (TabContents)this.getDialogArea() : (TabContents)this.fTabFolder.getSelection()[0].getControl();
        return content;
    }

    public void copyFromCriteria(Criteria from) {
        TabContents content = this.getTabContents();
        content.setLifelineButtonSelection(from.isLifeLineSelected());
        content.setSynMessageButtonSelection(from.isSyncMessageSelected());
        content.setSynMessageReturnButtonSelection(from.isSyncMessageReturnSelected());
        content.setAsynMessageButtonSelection(from.isAsyncMessageSelected());
        content.setAsynMessageReturnButtonSelection(from.isSyncMessageReturnSelected());
        content.setStopButtonSelection(from.isStopSelected());
        content.setCaseSensitiveSelection(from.isCaseSenstiveSelected());
        if (from.getExpression() != null) {
            content.setSearchText(from.getExpression());
        }
    }

    public void setOkText(String okText) {
        this.fOkText = okText;
    }

    public void setTitle(String title) {
        this.fTitle = title;
    }

    public String getOkText() {
        return this.fOkText;
    }

    protected void setIsFind(boolean flag) {
        this.fIsFind = flag;
    }

    public String getTitle() {
        return this.fTitle;
    }

    protected boolean isFind() {
        return this.fIsFind;
    }
}

