/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.tmf.ctf.core;

import org.eclipse.linuxtools.ctf.core.event.EventDefinition;
import org.eclipse.linuxtools.ctf.core.event.IEventDeclaration;
import org.eclipse.linuxtools.ctf.core.event.types.Definition;
import org.eclipse.linuxtools.ctf.core.event.types.IntegerDefinition;
import org.eclipse.linuxtools.tmf.core.timestamp.ITmfTimestamp;
import org.eclipse.linuxtools.tmf.core.timestamp.TmfTimeRange;
import org.eclipse.linuxtools.tmf.ctf.core.CtfTmfEvent;
import org.eclipse.linuxtools.tmf.ctf.core.CtfTmfLostEvent;
import org.eclipse.linuxtools.tmf.ctf.core.CtfTmfTimestamp;
import org.eclipse.linuxtools.tmf.ctf.core.CtfTmfTrace;

public final class CtfTmfEventFactory {
    private static final String NO_STREAM = "No stream";
    private static CtfTmfEvent nullEvent = null;

    private CtfTmfEventFactory() {
    }

    public static CtfTmfEvent createEvent(EventDefinition eventDef, String fileName, CtfTmfTrace originTrace) {
        String reference;
        IEventDeclaration eventDecl = eventDef.getDeclaration();
        long ts = eventDef.getTimestamp();
        CtfTmfTimestamp timestamp = originTrace.createTimestamp(originTrace.getCTFTrace().timestampCyclesToNanos(ts));
        int sourceCPU = eventDef.getCPU();
        String string = reference = fileName == null ? NO_STREAM : fileName;
        if (eventDecl.getName().equals("Lost event")) {
            Definition nbLostEventsDef = eventDef.getFields().getDefinition("Lost events");
            Definition durationDef = eventDef.getFields().getDefinition("duration");
            if (!(nbLostEventsDef instanceof IntegerDefinition) || !(durationDef instanceof IntegerDefinition)) {
                return CtfTmfEventFactory.getNullEvent();
            }
            long nbLostEvents = ((IntegerDefinition)nbLostEventsDef).getValue();
            long duration = ((IntegerDefinition)durationDef).getValue();
            CtfTmfTimestamp timestampEnd = new CtfTmfTimestamp(originTrace.getCTFTrace().timestampCyclesToNanos(ts) + duration);
            CtfTmfLostEvent lostEvent = new CtfTmfLostEvent(originTrace, -1L, reference, sourceCPU, eventDecl, new TmfTimeRange((ITmfTimestamp)timestamp, (ITmfTimestamp)timestampEnd), nbLostEvents, eventDef);
            return lostEvent;
        }
        CtfTmfEvent event = new CtfTmfEvent(originTrace, -1L, timestamp, reference, sourceCPU, eventDecl, eventDef);
        return event;
    }

    public static CtfTmfEvent getNullEvent() {
        if (nullEvent == null) {
            nullEvent = new CtfTmfEvent();
        }
        return nullEvent;
    }
}

