/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.tmf.ctf.core;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.linuxtools.ctf.core.event.types.ArrayDefinition;
import org.eclipse.linuxtools.ctf.core.event.types.Definition;
import org.eclipse.linuxtools.ctf.core.event.types.EnumDefinition;
import org.eclipse.linuxtools.ctf.core.event.types.FloatDefinition;
import org.eclipse.linuxtools.ctf.core.event.types.IntegerDeclaration;
import org.eclipse.linuxtools.ctf.core.event.types.IntegerDefinition;
import org.eclipse.linuxtools.ctf.core.event.types.SequenceDeclaration;
import org.eclipse.linuxtools.ctf.core.event.types.SequenceDefinition;
import org.eclipse.linuxtools.ctf.core.event.types.StringDefinition;
import org.eclipse.linuxtools.ctf.core.event.types.StructDefinition;
import org.eclipse.linuxtools.ctf.core.event.types.VariantDefinition;
import org.eclipse.linuxtools.tmf.core.event.ITmfEventField;
import org.eclipse.linuxtools.tmf.core.event.TmfEventField;
import org.eclipse.linuxtools.tmf.ctf.core.CTFArrayField;
import org.eclipse.linuxtools.tmf.ctf.core.CTFEnumField;
import org.eclipse.linuxtools.tmf.ctf.core.CTFFloatField;
import org.eclipse.linuxtools.tmf.ctf.core.CTFIntegerArrayField;
import org.eclipse.linuxtools.tmf.ctf.core.CTFIntegerField;
import org.eclipse.linuxtools.tmf.ctf.core.CTFStringField;
import org.eclipse.linuxtools.tmf.ctf.core.CTFStructField;
import org.eclipse.linuxtools.tmf.ctf.core.CTFVariantField;
import org.eclipse.linuxtools.tmf.ctf.core.CtfEnumPair;
import org.eclipse.linuxtools.tmf.ctf.core.Messages;

public abstract class CtfTmfEventField
extends TmfEventField {
    protected CtfTmfEventField(String name, Object value, ITmfEventField[] fields) {
        super(name.startsWith("_") ? name.substring(1) : name, value, fields);
    }

    public static CtfTmfEventField parseField(Definition fieldDef, String fieldName) {
        CtfTmfEventField field = null;
        if (fieldDef instanceof IntegerDefinition) {
            IntegerDefinition intDef = (IntegerDefinition)fieldDef;
            int base = intDef.getDeclaration().getBase();
            field = new CTFIntegerField(fieldName, intDef.getValue(), base, intDef.getDeclaration().isSigned());
        } else if (fieldDef instanceof EnumDefinition) {
            EnumDefinition enumDef = (EnumDefinition)fieldDef;
            field = new CTFEnumField(fieldName, new CtfEnumPair(enumDef.getValue(), enumDef.getIntegerValue()));
        } else if (fieldDef instanceof StringDefinition) {
            field = new CTFStringField(fieldName, ((StringDefinition)fieldDef).getValue());
        } else if (fieldDef instanceof FloatDefinition) {
            FloatDefinition floatDef = (FloatDefinition)fieldDef;
            field = new CTFFloatField(fieldName, floatDef.getValue());
        } else if (fieldDef instanceof ArrayDefinition) {
            ArrayDefinition arrayDef = (ArrayDefinition)fieldDef;
            if (arrayDef.getDeclaration().isString()) {
                field = new CTFStringField(fieldName, fieldDef.toString());
            } else {
                List definitions = arrayDef.getDefinitions();
                CtfTmfEventField[] elements = new CtfTmfEventField[definitions.size()];
                int i = 0;
                while (i < definitions.size()) {
                    CtfTmfEventField curField;
                    elements[i] = curField = CtfTmfEventField.parseField((Definition)definitions.get(i), String.valueOf(fieldName) + '[' + i + ']');
                    ++i;
                }
                field = new CTFArrayField(fieldName, elements);
            }
        } else if (fieldDef instanceof SequenceDefinition) {
            SequenceDefinition seqDef = (SequenceDefinition)fieldDef;
            SequenceDeclaration seqDecl = seqDef.getDeclaration();
            if (seqDef.getLength() == 0) {
                field = new CTFStringField(fieldName, "");
            } else if (seqDecl.isString()) {
                field = new CTFStringField(fieldName, seqDef.toString());
            } else if (seqDecl.getElementType() instanceof IntegerDeclaration) {
                long[] values = new long[seqDef.getLength()];
                int i = 0;
                while (i < seqDef.getLength()) {
                    values[i] = ((IntegerDefinition)seqDef.getElem(i)).getValue();
                    ++i;
                }
                field = new CTFIntegerArrayField(fieldName, values, ((IntegerDeclaration)seqDecl.getElementType()).getBase(), ((IntegerDeclaration)seqDecl.getElementType()).isSigned());
            }
        } else if (fieldDef instanceof StructDefinition) {
            StructDefinition strDef = (StructDefinition)fieldDef;
            ArrayList<CtfTmfEventField> list = new ArrayList<CtfTmfEventField>();
            for (String curFieldName : strDef.getFieldNames()) {
                list.add(CtfTmfEventField.parseField(strDef.getDefinition(curFieldName), curFieldName));
            }
            field = new CTFStructField(fieldName, list.toArray(new CtfTmfEventField[list.size()]));
        } else if (fieldDef instanceof VariantDefinition) {
            VariantDefinition varDef = (VariantDefinition)fieldDef;
            String curFieldName = varDef.getCurrentFieldName();
            Definition curFieldDef = varDef.getCurrentField();
            if (curFieldDef != null) {
                CtfTmfEventField subField = CtfTmfEventField.parseField(curFieldDef, curFieldName);
                field = new CTFVariantField(fieldName, subField);
            } else {
                field = new CTFStringField(curFieldName, "");
            }
        } else {
            field = new CTFStringField(fieldName, String.valueOf(Messages.CtfTmfEventField_UnsupportedType) + fieldDef.getClass().toString());
        }
        return field;
    }

    public String toString() {
        return String.valueOf(this.getName()) + '=' + this.getFormattedValue();
    }
}

