/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.lttng2.control.ui.views.dialogs;

import java.util.Arrays;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.linuxtools.internal.lttng2.control.ui.Activator;
import org.eclipse.linuxtools.internal.lttng2.control.ui.views.dialogs.IGetEventInfoDialog;
import org.eclipse.linuxtools.internal.lttng2.control.ui.views.messages.Messages;
import org.eclipse.linuxtools.internal.lttng2.control.ui.views.model.impl.TraceChannelComponent;
import org.eclipse.linuxtools.internal.lttng2.control.ui.views.model.impl.TraceDomainComponent;
import org.eclipse.linuxtools.internal.lttng2.control.ui.views.model.impl.TraceSessionComponent;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class GetEventInfoDialog
extends Dialog
implements IGetEventInfoDialog {
    public static final String TARGET_NEW_CONNECTION_ICON_FILE = "icons/elcl16/enable_event.gif";
    private CCombo fSessionsCombo = null;
    private CCombo fChannelsCombo = null;
    private Text fFilterText;
    private TraceSessionComponent[] fSessions;
    private boolean fIsKernel;
    private int fSessionIndex = 0;
    private TraceChannelComponent fChannel;
    private TraceChannelComponent[] fChannels;
    private String fFilterExpression;

    public GetEventInfoDialog(Shell shell) {
        super(shell);
        this.setShellStyle(0x10 | this.getShellStyle());
    }

    @Override
    public TraceSessionComponent getSession() {
        return this.fSessions[this.fSessionIndex];
    }

    @Override
    public TraceChannelComponent getChannel() {
        return this.fChannel;
    }

    @Override
    public void setIsKernel(boolean isKernel) {
        this.fIsKernel = isKernel;
    }

    @Override
    public void setSessions(TraceSessionComponent[] sessions) {
        this.fSessions = Arrays.copyOf(sessions, sessions.length);
    }

    @Override
    public String getFilterExpression() {
        return this.fFilterExpression;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.TraceControl_EnableEventsDialogTitle);
        newShell.setImage(Activator.getDefault().loadIcon(TARGET_NEW_CONNECTION_ICON_FILE));
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogComposite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(1, true);
        dialogComposite.setLayout((Layout)layout);
        dialogComposite.setLayoutData((Object)new GridData(1808));
        Group sessionsGroup = new Group(dialogComposite, 32);
        sessionsGroup.setText(Messages.TraceControl_EnableEventsSessionGroupName);
        layout = new GridLayout(1, true);
        sessionsGroup.setLayout((Layout)layout);
        GridData data = new GridData(768);
        sessionsGroup.setLayoutData((Object)data);
        this.fSessionsCombo = new CCombo((Composite)sessionsGroup, 8);
        this.fSessionsCombo.setToolTipText(Messages.TraceControl_EnableEventsSessionsTooltip);
        this.fSessionsCombo.setLayoutData((Object)new GridData(768));
        String[] items = new String[this.fSessions.length];
        int i = 0;
        while (i < items.length) {
            items[i] = String.valueOf(this.fSessions[i].getName());
            ++i;
        }
        this.fSessionsCombo.setItems(items);
        this.fSessionsCombo.setEnabled(this.fSessions.length > 0);
        Group channelsGroup = new Group(dialogComposite, 32);
        channelsGroup.setText(Messages.TraceControl_EnableEventsChannelGroupName);
        layout = new GridLayout(1, true);
        channelsGroup.setLayout((Layout)layout);
        data = new GridData(768);
        channelsGroup.setLayoutData((Object)data);
        this.fChannelsCombo = new CCombo((Composite)channelsGroup, 8);
        this.fChannelsCombo.setToolTipText(Messages.TraceControl_EnableEventsChannelsTooltip);
        this.fChannelsCombo.setLayoutData((Object)new GridData(768));
        this.fChannelsCombo.setEnabled(false);
        this.fSessionsCombo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                GetEventInfoDialog.this.fSessionIndex = GetEventInfoDialog.this.fSessionsCombo.getSelectionIndex();
                if (GetEventInfoDialog.this.fSessionIndex >= 0) {
                    TraceDomainComponent domain = null;
                    TraceDomainComponent[] domains = GetEventInfoDialog.this.fSessions[GetEventInfoDialog.this.fSessionIndex].getDomains();
                    int i = 0;
                    while (i < domains.length) {
                        if (domains[i].isKernel() == GetEventInfoDialog.this.fIsKernel) {
                            domain = domains[i];
                            break;
                        }
                        ++i;
                    }
                    if (domain != null) {
                        GetEventInfoDialog.this.fChannels = domain.getChannels();
                        String[] selectionItems = new String[GetEventInfoDialog.this.fChannels.length];
                        int i2 = 0;
                        while (i2 < selectionItems.length) {
                            selectionItems[i2] = String.valueOf(GetEventInfoDialog.this.fChannels[i2].getName());
                            ++i2;
                        }
                        GetEventInfoDialog.this.fChannelsCombo.setItems(selectionItems);
                        GetEventInfoDialog.this.fChannelsCombo.setEnabled(GetEventInfoDialog.this.fChannels.length > 0);
                    } else {
                        GetEventInfoDialog.this.fChannelsCombo.setItems(new String[0]);
                        GetEventInfoDialog.this.fChannelsCombo.setEnabled(false);
                        GetEventInfoDialog.this.fChannels = null;
                    }
                    GetEventInfoDialog.this.fChannelsCombo.getParent().getParent().layout();
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        if (this.fSessions[0].isEventFilteringSupported() && !this.fIsKernel) {
            Group filterMainGroup = new Group(dialogComposite, 32);
            filterMainGroup.setText(Messages.TraceControl_EnableEventsFilterGroupName);
            layout = new GridLayout(2, false);
            filterMainGroup.setLayout((Layout)layout);
            data = new GridData(768);
            filterMainGroup.setLayoutData((Object)data);
            this.fFilterText = new Text((Composite)filterMainGroup, 16384);
            this.fFilterText.setToolTipText(Messages.TraceControl_EnableEventsFilterTooltip);
            data = new GridData(768);
            this.fFilterText.setLayoutData((Object)data);
        }
        this.getShell().setMinimumSize(new Point(300, 200));
        return dialogComposite;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 1, "&Cancel", true);
        this.createButton(parent, 0, "&Ok", true);
    }

    protected void okPressed() {
        String tempFilter;
        if (this.fSessionsCombo.getSelectionIndex() < 0) {
            MessageDialog.openError((Shell)this.getShell(), (String)Messages.TraceControl_EnableEventsDialogTitle, (String)Messages.TraceControl_EnableEventsNoSessionError);
            return;
        }
        this.fSessionIndex = this.fSessionsCombo.getSelectionIndex();
        this.fChannel = null;
        if (this.fChannels != null && this.fChannelsCombo.getSelectionIndex() >= 0) {
            this.fChannel = this.fChannels[this.fChannelsCombo.getSelectionIndex()];
        }
        this.fFilterExpression = null;
        if (this.fSessions[0].isEventFilteringSupported() && !this.fIsKernel && !(tempFilter = this.fFilterText.getText()).isEmpty() && !tempFilter.matches("\\s*")) {
            this.fFilterExpression = tempFilter;
        }
        super.okPressed();
    }
}

