/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.lttng2.control.ui.views.handlers;

import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.linuxtools.internal.lttng2.control.core.model.IChannelInfo;
import org.eclipse.linuxtools.internal.lttng2.control.core.model.TraceSessionState;
import org.eclipse.linuxtools.internal.lttng2.control.ui.views.handlers.BaseEnableChannelHandler;
import org.eclipse.linuxtools.internal.lttng2.control.ui.views.handlers.CommandParameter;
import org.eclipse.linuxtools.internal.lttng2.control.ui.views.handlers.DomainCommandParameter;
import org.eclipse.linuxtools.internal.lttng2.control.ui.views.model.impl.TraceDomainComponent;
import org.eclipse.linuxtools.internal.lttng2.control.ui.views.model.impl.TraceSessionComponent;
import org.eclipse.ui.IWorkbenchPage;

public class EnableChannelOnDomainHandler
extends BaseEnableChannelHandler {
    @Override
    public void enableChannel(CommandParameter param, List<String> channelNames, IChannelInfo info, boolean isKernel, IProgressMonitor monitor) throws ExecutionException {
        if (param instanceof DomainCommandParameter) {
            ((DomainCommandParameter)param).getDomain().enableChannels(channelNames, info, monitor);
        }
    }

    @Override
    public TraceDomainComponent getDomain(CommandParameter param) {
        if (param instanceof DomainCommandParameter) {
            return ((DomainCommandParameter)param).getDomain();
        }
        return null;
    }

    public boolean isEnabled() {
        IWorkbenchPage page = this.getWorkbenchPage();
        if (page == null) {
            return false;
        }
        TraceDomainComponent domain = null;
        TraceSessionComponent session = null;
        ISelection selection = page.getSelection("org.eclipse.linuxtools.internal.lttng2.ui.views.control");
        if (selection instanceof StructuredSelection) {
            StructuredSelection structered = (StructuredSelection)selection;
            for (Object element : structered) {
                TraceDomainComponent tmpDomain;
                if (!(element instanceof TraceDomainComponent) || (session = (TraceSessionComponent)(tmpDomain = (TraceDomainComponent)element).getParent()).getSessionState() != TraceSessionState.INACTIVE || session.isDestroyed()) continue;
                domain = tmpDomain;
            }
        }
        boolean isEnabled = domain != null;
        this.fLock.lock();
        try {
            this.fParam = null;
            if (isEnabled) {
                this.fParam = new DomainCommandParameter(session, domain);
            }
        }
        finally {
            this.fLock.unlock();
        }
        return isEnabled;
    }
}

