/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.proxy.packet;

import java.io.IOException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.ptp.proxy.command.IProxyCommand;
import org.eclipse.ptp.proxy.event.IProxyEvent;
import org.eclipse.ptp.proxy.messages.Messages;
import org.eclipse.ptp.proxy.util.ProtocolUtil;
import org.eclipse.ptp.proxy.util.VarInt;
import org.eclipse.ptp.proxy.util.compression.IDecoder;
import org.eclipse.ptp.proxy.util.compression.IEncoder;
import org.eclipse.ptp.proxy.util.compression.huffmancoder.HuffmanByteCompress;
import org.eclipse.ptp.proxy.util.compression.huffmancoder.HuffmanByteUncompress;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProxyPacket {
    private static final int PACKET_LENGTH_SIZE = 4;
    private static final int SMALL_PACKET = 100;
    private static final int LARGE_PACKET = 8192;
    private static final int COMPRESSION_DIFF = 100;
    private static final int COMPRESSION_UPDATE = 262144;
    private static final int COMPRESSION_FLAG = 64;
    private static final int COMPRESSION_TABLE_FLAG = 16;
    private boolean debug = false;
    private int fPacketFlags = 0;
    private int fPacketID;
    private int fPacketTransID;
    private String[] fPacketArgs;
    private HuffmanByteCompress compressor;
    private HuffmanByteUncompress uncompressor;
    private final Charset fCharset = Charset.forName("ISO-8859-1");
    private final CharsetEncoder encoder = this.fCharset.newEncoder();
    private final CharsetDecoder decoder = this.fCharset.newDecoder();

    public ProxyPacket() {
    }

    public ProxyPacket(IDecoder uncomp) {
        this();
        if (!(uncomp instanceof HuffmanByteUncompress)) {
            throw new RuntimeException(Messages.getString("ProxyPacket_6"));
        }
        this.uncompressor = (HuffmanByteUncompress)uncomp;
    }

    public ProxyPacket(IEncoder comp) {
        this();
        if (!(comp instanceof HuffmanByteCompress)) {
            throw new RuntimeException(Messages.getString("ProxyPacket_6"));
        }
        this.compressor = (HuffmanByteCompress)comp;
    }

    public ProxyPacket(IProxyCommand cmd) {
        this();
        this.fPacketID = cmd.getCommandID();
        this.fPacketTransID = cmd.getTransactionID();
        this.fPacketArgs = cmd.getArguments();
    }

    public ProxyPacket(IProxyCommand cmd, IDecoder uncomp) {
        this(cmd);
        if (!(uncomp instanceof HuffmanByteUncompress)) {
            throw new RuntimeException(Messages.getString("ProxyPacket_6"));
        }
        this.uncompressor = (HuffmanByteUncompress)uncomp;
    }

    public ProxyPacket(IProxyCommand cmd, IEncoder comp) {
        this(cmd);
        if (!(comp instanceof HuffmanByteCompress)) {
            throw new RuntimeException(Messages.getString("ProxyPacket_6"));
        }
        this.compressor = (HuffmanByteCompress)comp;
    }

    public ProxyPacket(IProxyEvent event) {
        this();
        this.fPacketID = event.getEventID();
        this.fPacketTransID = event.getTransactionID();
        this.fPacketArgs = event.getAttributes();
        if (this.fPacketArgs == null) {
            this.fPacketArgs = new String[0];
        }
    }

    public ProxyPacket(IProxyEvent event, IDecoder uncomp) {
        this(event);
        if (!(uncomp instanceof HuffmanByteUncompress)) {
            throw new RuntimeException(Messages.getString("ProxyPacket_6"));
        }
        this.uncompressor = (HuffmanByteUncompress)uncomp;
    }

    public ProxyPacket(IProxyEvent event, IEncoder comp) {
        this(event);
        if (!(comp instanceof HuffmanByteCompress)) {
            throw new RuntimeException(Messages.getString("ProxyPacket_6"));
        }
        this.compressor = (HuffmanByteCompress)comp;
    }

    public CharsetDecoder decoder() {
        return this.decoder;
    }

    public CharsetEncoder encoder() {
        return this.encoder;
    }

    public String[] getArgs() {
        return this.fPacketArgs;
    }

    public int getID() {
        return this.fPacketID;
    }

    public int getTransID() {
        return this.fPacketTransID;
    }

    public boolean read(ReadableByteChannel channel) throws IOException {
        VarInt val;
        int len;
        ByteBuffer lengthBytes = ByteBuffer.allocate(4);
        if (this.fullRead(channel, lengthBytes) < 0) {
            return false;
        }
        try {
            len = lengthBytes.getInt();
        }
        catch (BufferUnderflowException bufferUnderflowException) {
            System.out.println("BAD PACKET LENGTH");
            throw new IOException(Messages.getString("ProxyPacket_0"));
        }
        ByteBuffer packetBytes = ByteBuffer.allocate(len);
        if (this.fullRead(channel, packetBytes) < 0) {
            return false;
        }
        if (this.debug) {
            System.out.println("RECEIVE:[" + len + "] -> " + Thread.currentThread().getName());
        }
        this.fPacketFlags = packetBytes.get();
        if ((this.fPacketFlags & 0x40) != 0) {
            if (this.debug) {
                System.out.println("Received compressed packet.");
            }
            if (this.uncompressor == null) {
                throw new IOException(Messages.getString("ProxyPacket_5"));
            }
            if ((this.fPacketFlags & 0x10) != 0) {
                this.uncompressor.notifyFrequencyUpdate();
            }
            packetBytes = this.uncompressor.apply(packetBytes.slice());
        }
        if (!(val = new VarInt(packetBytes)).isValid()) {
            throw new IOException(Messages.getString("ProxyPacket_1"));
        }
        this.fPacketID = val.getValue();
        val = new VarInt(packetBytes);
        if (!val.isValid()) {
            throw new IOException(Messages.getString("ProxyPacket_3"));
        }
        this.fPacketTransID = val.getValue();
        val = new VarInt(packetBytes);
        if (!val.isValid()) {
            throw new IOException(Messages.getString("ProxyPacket_4"));
        }
        int packetNumArgs = val.getValue();
        this.fPacketArgs = new String[packetNumArgs];
        int i = 0;
        while (i < packetNumArgs) {
            switch (packetBytes.get()) {
                default: 
            }
            this.fPacketArgs[i] = ProtocolUtil.decodeStringAttributeType(packetBytes, this.decoder);
            ++i;
        }
        return true;
    }

    public void send(WritableByteChannel channel) throws IOException {
        ArrayList<ByteBuffer> buffers = new ArrayList<ByteBuffer>();
        buffers.add(ByteBuffer.allocate(4));
        buffers.add(ByteBuffer.allocate(1));
        buffers.add(new VarInt(this.fPacketID).getBytes());
        buffers.add(new VarInt(this.fPacketTransID).getBytes());
        buffers.add(new VarInt(this.fPacketArgs.length).getBytes());
        String[] stringArray = this.fPacketArgs;
        int n = this.fPacketArgs.length;
        int n2 = 0;
        while (n2 < n) {
            String arg = stringArray[n2];
            ProtocolUtil.encodeStringAttributeType(buffers, arg, this.fCharset);
            ++n2;
        }
        int len = 0;
        for (ByteBuffer b : buffers) {
            len += b.remaining();
        }
        buffers.get(0).putInt(len - 4).rewind();
        buffers.get(1).put((byte)this.fPacketFlags).rewind();
        if (this.debug) {
            System.out.println("SEND -> " + Thread.currentThread().getName());
        }
        if (len > 100 && this.compressor != null) {
            buffers = this.compressPacket(buffers, len);
            len = buffers.get(0).getInt() + 4;
            buffers.get(0).rewind();
        }
        this.fullWrite(channel, buffers, len);
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    private ArrayList<ByteBuffer> compressPacket(ArrayList<ByteBuffer> buffers, int len) {
        ByteBuffer bb = ByteBuffer.allocate(len);
        boolean updated = false;
        if (this.compressor == null) {
            return buffers;
        }
        int flagByte = buffers.get(1).get();
        buffers.get(1).rewind();
        List<ByteBuffer> subList = buffers.subList(2, buffers.size());
        for (ByteBuffer b : subList) {
            bb.put(b);
            b.rewind();
        }
        int limit = bb.limit();
        int tableUpdateCount = this.compressor.getBytesAccumulated();
        if (tableUpdateCount > 262144 && (len > 8192 || tableUpdateCount > 524288)) {
            this.compressor.updateHuffmanTable();
        }
        updated = this.compressor.getIncludeTableFlag();
        ByteBuffer compressedPacket = this.compressor.apply(bb);
        if (limit - compressedPacket.limit() > 100 || updated) {
            flagByte |= 0x40;
            if (updated) {
                flagByte |= 0x10;
            }
            compressedPacket.rewind();
            buffers = new ArrayList(3);
            buffers.add(ByteBuffer.allocate(4));
            buffers.add(ByteBuffer.allocate(1));
            buffers.add(compressedPacket);
            buffers.get(0).putInt(compressedPacket.limit() + 1).rewind();
            buffers.get(1).put((byte)flagByte).rewind();
            if (this.debug) {
                System.out.println("Original size: " + bb.limit());
                System.out.println("New size:" + compressedPacket.limit());
            }
        }
        return buffers;
    }

    private int fullRead(ReadableByteChannel channel, ByteBuffer buf) throws IOException {
        int n;
        int len = buf.remaining();
        buf.clear();
        while ((n = channel.read(buf)) < len) {
            if (n <= 0) break;
            len -= n;
        }
        buf.flip();
        return n;
    }

    private void fullWrite(WritableByteChannel channel, List<ByteBuffer> bufs, long len) throws IOException {
        long n;
        ByteBuffer bb = ByteBuffer.allocate((int)len);
        for (ByteBuffer b : bufs) {
            bb.put(b);
        }
        bb.flip();
        while ((n = (long)channel.write(bb)) < len) {
            if (n >= 0L) continue;
            throw new IOException(Messages.getString("ProxyPacket_2"));
        }
    }

    public static int[] getDefaultHuffmanTable() {
        int[] frequencyTable = new int[]{422, 420, 418, 416, 414, 412, 410, 408, 406, 404, 402, 400, 398, 396, 394, 392, 390, 388, 386, 384, 382, 380, 378, 376, 374, 372, 370, 368, 366, 364, 362, 1802, 450, 448, 446, 444, 442, 440, 438, 436, 434, 432, 430, 428, 426, 424, 1652, 1550, 1500, 1450, 1400, 1350, 1300, 1250, 1200, 1150, 1100, 1050, 1000, 950, 900, 850, 800, 750, 4500, 2950, 2900, 2850, 4400, 2800, 2750, 2700, 4300, 2700, 2650, 2600, 2550, 2500, 4200, 2450, 2400, 2350, 2300, 2250, 2200, 2150, 2100, 2050, 2000, 1950, 1900, 1850, 1800, 500, 1700, 1650, 5000, 4000, 3950, 3900, 4900, 3850, 3800, 3750, 4800, 3700, 3650, 3600, 3550, 3500, 4700, 3450, 3400, 3350, 3300, 3250, 4600, 3200, 3150, 3100, 3050, 3000, 750, 700, 650, 600, 550, 360, 358, 356, 354, 352, 350, 348, 346, 344, 342, 340, 338, 336, 334, 332, 330, 328, 326, 324, 322, 320, 318, 316, 314, 312, 310, 308, 306, 304, 302, 300, 298, 296, 294, 292, 290, 288, 286, 284, 282, 280, 278, 276, 274, 272, 270, 268, 266, 264, 262, 260, 258, 256, 254, 252, 250, 248, 246, 244, 242, 240, 238, 236, 234, 232, 230, 228, 226, 224, 222, 220, 218, 216, 214, 212, 210, 208, 206, 204, 202, 200, 198, 196, 194, 192, 190, 188, 186, 184, 182, 180, 178, 176, 174, 172, 170, 168, 166, 164, 162, 160, 158, 156, 154, 152, 150, 148, 146, 144, 142, 140, 138, 136, 134, 132, 130, 128, 126, 124, 122, 120, 118, 116, 114, 112, 110, 108, 106, 104};
        return frequencyTable;
    }
}

