/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.remote.ui.dialogs;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.operation.ModalContext;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.wizard.ProgressMonitorPart;
import org.eclipse.remote.core.IRemoteConnection;
import org.eclipse.remote.internal.ui.messages.Messages;
import org.eclipse.remote.ui.widgets.RemoteResourceBrowserWidget;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class RemoteResourceBrowser
extends Dialog
implements IRunnableContext {
    public static final String EMPTY_STRING = "";
    public static final int FILE_BROWSER = 1;
    public static final int DIRECTORY_BROWSER = 2;
    private static final int widthHint = 400;
    private Button fOkButton;
    private RemoteResourceBrowserWidget fResourceBrowserWidget;
    private ProgressMonitorPart fProgressMonitor;
    private int fBrowserType;
    private String fDialogTitle;
    private boolean fShowHiddenCheckbox = true;
    private boolean fShowNewFolderButton = true;
    private boolean fShowConnections = false;
    private boolean fShowLocalSelection = false;
    private String fInitialPath;
    private IRemoteConnection fConnection;
    private int fBrowserStyle = 4;

    public RemoteResourceBrowser(Shell parent, int style) {
        super(parent);
        this.setShellStyle(0x10 | this.getShellStyle());
        if (style != 0) {
            this.fBrowserStyle = style;
        }
        this.setTitle(Messages.RemoteResourceBrowser_resourceTitle);
        this.setType(3);
    }

    protected Button createButton(Composite parent, int id, String label, boolean defaultButton) {
        Button button = super.createButton(parent, id, label, defaultButton);
        if (id == 0) {
            this.fOkButton = button;
        }
        return button;
    }

    protected Control createContents(Composite parent) {
        Control contents = super.createContents(parent);
        if (this.fDialogTitle == null) {
            if (this.fBrowserType == 2) {
                this.setTitle(Messages.RemoteResourceBrowser_directoryTitle);
            } else if (this.fBrowserType == 1) {
                this.setTitle(Messages.RemoteResourceBrowser_fileTitle);
            }
        } else {
            this.setTitle(this.fDialogTitle);
        }
        if (this.fConnection != null) {
            this.fResourceBrowserWidget.setConnection(this.fConnection);
        }
        if (this.fInitialPath != null) {
            this.fResourceBrowserWidget.setInitialPath(this.fInitialPath);
        }
        this.updateDialog();
        return contents;
    }

    protected Control createDialogArea(Composite parent) {
        Composite main = (Composite)super.createDialogArea(parent);
        GridData gd = new GridData(4, 4, true, true);
        gd.widthHint = 400;
        main.setLayoutData((Object)gd);
        main.setLayout((Layout)new GridLayout(1, true));
        int options = 0;
        if (this.fConnection == null || this.fShowConnections) {
            options |= 0x40;
        }
        options = this.fBrowserType == 2 ? (options |= 2) : (this.fBrowserType == 1 ? (options |= 1) : (options |= 3));
        if (this.fShowHiddenCheckbox) {
            options |= 0x10;
        }
        if (this.fShowNewFolderButton) {
            options |= 0x20;
        }
        if (this.fShowLocalSelection) {
            options |= 4;
        }
        this.fResourceBrowserWidget = new RemoteResourceBrowserWidget(main, this.fBrowserStyle, options);
        this.fResourceBrowserWidget.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                RemoteResourceBrowser.this.updateDialog();
            }
        });
        this.fResourceBrowserWidget.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
                RemoteResourceBrowser.this.getShell().setDefaultButton(null);
            }

            public void focusLost(FocusEvent e) {
                RemoteResourceBrowser.this.getShell().setDefaultButton(RemoteResourceBrowser.this.fOkButton);
            }
        });
        this.fResourceBrowserWidget.setLayoutData(new GridData(4, 4, true, true));
        if (this.fConnection != null) {
            this.fResourceBrowserWidget.setConnection(this.fConnection);
        }
        Composite monitorComposite = new Composite(main, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 2;
        monitorComposite.setLayout((Layout)layout);
        monitorComposite.setLayoutData((Object)new GridData(768));
        this.fProgressMonitor = new ProgressMonitorPart(monitorComposite, (Layout)new GridLayout(), true);
        GridData gridData = new GridData(4, 128, true, true);
        this.fProgressMonitor.setLayoutData((Object)gridData);
        monitorComposite.setVisible(false);
        this.fResourceBrowserWidget.setRunnableContext(this);
        return main;
    }

    public IRemoteConnection getConnection() {
        if (this.fResourceBrowserWidget != null) {
            return this.fResourceBrowserWidget.getConnection();
        }
        return null;
    }

    public IFileStore getResource() {
        if (this.fResourceBrowserWidget != null && this.fResourceBrowserWidget.getResources().size() > 0) {
            return this.fResourceBrowserWidget.getResources().get(0);
        }
        return null;
    }

    public List<IFileStore> getResources() {
        if (this.fResourceBrowserWidget != null) {
            return this.fResourceBrowserWidget.getResources();
        }
        return new ArrayList<IFileStore>();
    }

    public void run(boolean fork, boolean cancelable, IRunnableWithProgress runnable) throws InvocationTargetException, InterruptedException {
        this.fProgressMonitor.attachToCancelComponent(null);
        this.fProgressMonitor.getParent().setVisible(true);
        try {
            ModalContext.run((IRunnableWithProgress)runnable, (boolean)fork, (IProgressMonitor)this.fProgressMonitor, (Display)this.getShell().getDisplay());
        }
        finally {
            this.fProgressMonitor.getParent().setVisible(false);
            this.fProgressMonitor.removeFromCancelComponent(null);
        }
    }

    public void setConnection(IRemoteConnection connection) {
        this.fConnection = connection;
    }

    public void setInitialPath(String path) {
        this.fInitialPath = path;
    }

    public void setTitle(String title) {
        Shell shell;
        this.fDialogTitle = title;
        if (this.fDialogTitle == null) {
            this.fDialogTitle = EMPTY_STRING;
        }
        if ((shell = this.getShell()) != null && !shell.isDisposed()) {
            shell.setText(this.fDialogTitle);
        }
    }

    public void setType(int type) {
        this.fBrowserType = type;
    }

    public void showConnections(boolean enable) {
        this.fShowConnections = enable;
    }

    public void showHiddenCheckbox(boolean showHidden) {
        this.fShowHiddenCheckbox = showHidden;
    }

    public void showLocalSelection(boolean showLocalSelection) {
        this.fShowLocalSelection = showLocalSelection;
    }

    public void showNewFolderButton(boolean showNewFolderButton) {
        this.fShowNewFolderButton = showNewFolderButton;
    }

    private void updateDialog() {
        if (this.fOkButton != null) {
            boolean enabled;
            IFileStore resource = this.getResource();
            boolean bl = enabled = this.getConnection() != null && resource != null;
            if (enabled && this.fBrowserType == 1) {
                enabled &= !resource.fetchInfo().isDirectory();
            }
            this.fOkButton.setEnabled(enabled);
        }
    }
}

