/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.remote.remotetools.core;

import java.util.Map;
import org.eclipse.ptp.internal.remote.remotetools.core.RemoteToolsConnection;
import org.eclipse.ptp.internal.remote.remotetools.core.RemoteToolsConnectionManager;
import org.eclipse.ptp.internal.remote.remotetools.core.RemoteToolsServices;
import org.eclipse.ptp.remotetools.environment.EnvironmentPlugin;
import org.eclipse.ptp.remotetools.environment.core.TargetElement;
import org.eclipse.remote.core.IRemoteConnection;
import org.eclipse.remote.core.IRemoteConnectionWorkingCopy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RemoteToolsConnectionWorkingCopy
extends RemoteToolsConnection
implements IRemoteConnectionWorkingCopy {
    private final RemoteToolsConnection fConnection;
    private String fName;
    private boolean fIsDirty;

    public RemoteToolsConnectionWorkingCopy(RemoteToolsConnection conn) {
        super(conn.getName(), new TargetElement(RemoteToolsServices.getTargetTypeElement(), conn.getName(), conn.getTargetControl().getConfig().getAttributes(), EnvironmentPlugin.getDefault().getEnvironmentUniqueID()), conn.getRemoteServices());
        this.fConnection = conn;
        this.fName = conn.getName();
        this.fIsDirty = false;
    }

    @Override
    public String getAddress() {
        return this.getTargetControl().getConfig().getConnectionAddress();
    }

    @Override
    public Map<String, String> getAttributes() {
        return this.getTargetControl().getConfig().getAttributes().getAttributesAsMap();
    }

    @Override
    public String getName() {
        return this.fName;
    }

    public IRemoteConnection getOriginal() {
        return this.fConnection;
    }

    @Override
    public int getPort() {
        return this.getTargetControl().getConfig().getConnectionPort();
    }

    @Override
    public String getUsername() {
        return this.getTargetControl().getConfig().getLoginUsername();
    }

    @Override
    public IRemoteConnectionWorkingCopy getWorkingCopy() {
        return this;
    }

    public boolean isDirty() {
        return this.fIsDirty;
    }

    public IRemoteConnection save() {
        this.fConnection.getTargetElement().setAttributes(this.getTargetControl().getConfig().getAttributes());
        if (!this.fName.equals(this.fConnection.getName())) {
            this.fConnection.setName(this.fName);
        }
        ((RemoteToolsConnectionManager)this.fConnection.getRemoteServices().getConnectionManager()).addConnection(this.fConnection);
        this.fIsDirty = false;
        return this.fConnection;
    }

    public void setAddress(String address) {
        this.fIsDirty = true;
        this.getTargetControl().getConfig().setConnectionAddress(address);
    }

    public void setAttribute(String key, String value) {
        this.fIsDirty = true;
        this.getTargetControl().getConfig().setAttribute(key, value);
    }

    @Override
    public void setName(String name) {
        this.fIsDirty = true;
        this.fName = name;
    }

    public void setPassword(String password) {
        this.fIsDirty = true;
        this.getTargetControl().getConfig().setLoginPassword(password);
    }

    public void setPort(int port) {
        this.fIsDirty = true;
        this.getTargetControl().getConfig().setConnectionPort(port);
    }

    public void setTimeout(int timeout) {
        this.fIsDirty = true;
        this.getTargetControl().getConfig().setConnectionTimeout(timeout);
    }

    public void setUsername(String userName) {
        this.fIsDirty = true;
        this.getTargetControl().getConfig().setLoginUsername(userName);
    }
}

