/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.rdt.core;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.cdt.core.parser.IScannerInfo;

public class RemoteScannerInfo
implements IScannerInfo,
Serializable {
    private static final long serialVersionUID = 1L;
    private Map<String, String> symbols;
    private List<String> includePaths;

    public RemoteScannerInfo() {
        this.symbols = new HashMap<String, String>();
        this.includePaths = new ArrayList<String>();
    }

    public RemoteScannerInfo(IScannerInfo scannerInfo) {
        this.symbols = new HashMap<String, String>(scannerInfo.getDefinedSymbols());
        String[] includePathsArray = scannerInfo.getIncludePaths();
        int k = 0;
        while (k < includePathsArray.length) {
            includePathsArray[k] = includePathsArray[k].replaceAll("\\\\", "/");
            ++k;
        }
        this.includePaths = new ArrayList<String>(Arrays.asList(includePathsArray));
    }

    public RemoteScannerInfo(Map<String, String> macroDefinitions, String[] includes) {
        this(macroDefinitions, includes == null ? null : Arrays.asList(includes));
    }

    public RemoteScannerInfo(Map<String, String> macroDefinitions, List<String> includes) {
        this();
        if (macroDefinitions != null) {
            this.symbols = macroDefinitions;
        }
        if (includes != null) {
            this.includePaths.clear();
            for (String includePath : includes) {
                this.includePaths.add(includePath.replaceAll("\\\\", "/"));
            }
        }
    }

    public Map<String, String> getDefinedSymbols() {
        return Collections.unmodifiableMap(this.symbols);
    }

    public String[] getIncludePaths() {
        String[] paths = this.includePaths.toArray(new String[this.includePaths.size()]);
        int i = 0;
        while (i < paths.length) {
            paths[i] = paths[i].replace('\\', '/');
            ++i;
        }
        return paths;
    }

    public String toString() {
        return this.includePaths + " " + this.symbols;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.includePaths == null ? 0 : this.includePaths.hashCode());
        result = 31 * result + (this.symbols == null ? 0 : this.symbols.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RemoteScannerInfo other = (RemoteScannerInfo)obj;
        if (this.includePaths == null ? other.includePaths != null : !this.includePaths.equals(other.includePaths)) {
            return false;
        }
        return !(this.symbols == null ? other.symbols != null : !this.symbols.equals(other.symbols));
    }
}

