/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.rdt.core.typehierarchy;

import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.core.model.IWorkingCopy;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.ptp.internal.rdt.core.model.ModelAdapter;
import org.eclipse.ptp.internal.rdt.core.model.Scope;
import org.eclipse.ptp.internal.rdt.core.serviceproviders.AbstractRemoteService;
import org.eclipse.ptp.internal.rdt.core.subsystems.ICIndexSubsystem;
import org.eclipse.ptp.internal.rdt.core.typehierarchy.ITypeHierarchyService;
import org.eclipse.ptp.internal.rdt.core.typehierarchy.THGraph;
import org.eclipse.rse.core.subsystems.IConnectorService;

public class RemoteTypeHierarchyService
extends AbstractRemoteService
implements ITypeHierarchyService {
    public RemoteTypeHierarchyService(IConnectorService connectorService) {
        super(connectorService);
    }

    public RemoteTypeHierarchyService(ICIndexSubsystem subsystem) {
        super(subsystem);
    }

    @Override
    public THGraph computeGraph(Scope scope, ICElement input, IProgressMonitor monitor) throws CoreException, InterruptedException {
        ICIndexSubsystem subsystem = this.getSubSystem();
        subsystem.checkAllProjects(monitor);
        ICElement element = ModelAdapter.adaptElement(null, input, 0, true);
        return subsystem.computeTypeGraph(scope, element, monitor);
    }

    @Override
    public ICElement[] findInput(Scope scope, ICElement input, IProgressMonitor monitor) {
        ICElement element;
        ICIndexSubsystem subsystem = this.getSubSystem();
        IProject project = input.getCProject().getProject();
        subsystem.checkProject(project, monitor);
        try {
            element = ModelAdapter.adaptElement(null, input, 0, true);
        }
        catch (CModelException cModelException) {
            return null;
        }
        return subsystem.findTypeHierarchyInput(scope, element);
    }

    @Override
    public ICElement[] findInput(Scope scope, ICProject project, IWorkingCopy workingCopy, int selectionStart, int selectionLength, IProgressMonitor monitor) throws CoreException {
        ITranslationUnit unit = this.adaptWorkingCopy(workingCopy);
        ICIndexSubsystem subsystem = this.getSubSystem();
        subsystem.checkProject(project.getProject(), monitor);
        return subsystem.findTypeHierarchyInput(scope, unit, selectionStart, selectionLength);
    }
}

