/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.etfw.tau.ui;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.ptp.etfw.tau.ui.messages.Messages;
import org.eclipse.ptp.internal.etfw.RemoteBuildLaunchUtils;
import org.eclipse.ptp.rm.jaxb.control.ui.AbstractWidget;
import org.eclipse.ptp.rm.jaxb.control.ui.IWidgetDescriptor;
import org.eclipse.ptp.rm.jaxb.core.IVariableMap;
import org.eclipse.remote.core.IRemoteConnection;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;

public class TAUMakefileCombo
extends AbstractWidget {
    private static final String LIB_FOLDER = "lib";
    private static final String PPROF = "pprof";
    private static final String TAU = "tau";
    private static final String TRUE_SELECTION = "true";
    private static final String MPI_OPTION = "use_mpi";
    private static final String CALLPATH_OPTION = "use_callpath_profiling";
    private static final String OPARI_OPTION = "use_opari";
    private static final String OpenMP_OPTION = "use_openmp";
    private static final String PAPI_OPTION = "use_papi_library";
    private static final String TRACE_OPTION = "use_tau_tracing";
    private static final String PDT_OPTION = "use_tau_with_PDT";
    private final Map<String, String> translateBoolean;
    private final IRemoteConnection remoteConnection;
    private final Combo combo;
    private final RemoteBuildLaunchUtils blt;
    private IVariableMap map;
    private String selectedMakefile;
    protected LinkedHashSet<String> allopts = null;
    protected LinkedHashSet<String> selopts = null;
    private IFileStore taulib = null;
    private LinkedHashSet<String> allmakefiles = null;
    boolean refreshing = false;
    final Job job = new Job(Messages.TAUMakefileCombo_UpdatingMakefileList){

        protected IStatus run(IProgressMonitor monitor) {
            TAUMakefileCombo.this.refreshing = true;
            TAUMakefileCombo.this.initMakefiles();
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    TAUMakefileCombo.this.updateMakefileCombo();
                    (this).TAUMakefileCombo.this.refreshing = false;
                }
            });
            return Status.OK_STATUS;
        }
    };

    public TAUMakefileCombo(Composite parent, IWidgetDescriptor wd) {
        super(parent, wd);
        this.translateBoolean = new HashMap<String, String>();
        this.translateBoolean.put(MPI_OPTION, "mpi");
        this.translateBoolean.put(CALLPATH_OPTION, "callpath");
        this.translateBoolean.put(OPARI_OPTION, "opari");
        this.translateBoolean.put(OpenMP_OPTION, "openmp");
        this.translateBoolean.put(PAPI_OPTION, "papi");
        this.translateBoolean.put(TRACE_OPTION, "trace");
        this.translateBoolean.put(PDT_OPTION, "pdt");
        this.remoteConnection = wd.getRemoteConnection();
        this.blt = new RemoteBuildLaunchUtils(this.remoteConnection);
        this.setLayout((Layout)new GridLayout(1, false));
        this.combo = new Combo((Composite)this, 8);
        this.combo.setItems(new String[]{Messages.TAUMakefileCombo_BuildingMakefileList});
        this.combo.select(0);
        this.combo.setEnabled(false);
        this.combo.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                TAUMakefileCombo.this.job.cancel();
            }
        });
        if (this.allmakefiles == null) {
            this.job.setUser(true);
            this.job.schedule();
        }
    }

    public void setEnabled(boolean enabled) {
        if (!this.refreshing) {
            this.refreshing = true;
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    TAUMakefileCombo.this.initMakefiles();
                    TAUMakefileCombo.this.updateMakefileCombo();
                    TAUMakefileCombo.this.refreshing = false;
                }
            });
        }
    }

    public void setSelectedMakefile(String makefile) {
        this.selectedMakefile = makefile;
    }

    public String getSelectedMakefile() {
        return this.selectedMakefile;
    }

    private void updateMakefileCombo() {
        if (this.combo == null || this.combo.isDisposed()) {
            return;
        }
        List<String> options = this.populateOptions();
        int preDex = -1;
        ArrayList<String> makefiles = new ArrayList<String>();
        makefiles.add("");
        int i = 1;
        for (String name : this.allmakefiles) {
            int optionTypes = 0;
            for (String option : options) {
                if (!name.contains(option)) continue;
                ++optionTypes;
            }
            if (optionTypes != options.size()) continue;
            makefiles.add(name);
            if (this.selectedMakefile != null && this.selectedMakefile.endsWith(name)) {
                preDex = i;
            }
            ++i;
        }
        String[] items = makefiles.toArray(new String[0]);
        this.combo.setItems(items);
        this.combo.setEnabled(true);
        if (items.length > 1) {
            if (preDex > 0) {
                this.combo.select(preDex);
            } else {
                this.combo.select(1);
            }
            this.combo.notifyListeners(13, null);
        }
        this.getParent().layout(true);
    }

    private List<String> populateOptions() {
        ArrayList<String> options = new ArrayList<String>();
        this.addOption(MPI_OPTION, options);
        this.addOption(CALLPATH_OPTION, options);
        this.addOption(OPARI_OPTION, options);
        this.addOption(OpenMP_OPTION, options);
        this.addOption(PAPI_OPTION, options);
        this.addOption(TRACE_OPTION, options);
        this.addOption(PDT_OPTION, options);
        return options;
    }

    private void addOption(String variable, List<String> options) {
        String option;
        if (this.map != null && this.map.get(variable) != null && (option = this.map.get(variable).getValue().toString()).equals(TRUE_SELECTION)) {
            options.add(this.translateBoolean.get(variable));
        }
    }

    private void initMakefiles() {
        this.allmakefiles = new LinkedHashSet();
        String binpath = this.blt.getToolPath(TAU);
        IFileStore bindir = null;
        if (binpath == null || binpath.length() == 0) {
            binpath = this.blt.checkToolEnvPath(PPROF);
            if (binpath != null && binpath.length() > 0) {
                bindir = this.blt.getFile(binpath);
            }
        } else {
            bindir = this.blt.getFile(binpath);
        }
        List<IFileStore> mfiles = this.testTAUEnv(bindir);
        this.allopts = new LinkedHashSet();
        String name = null;
        if (mfiles == null) {
            return;
        }
        int i = 0;
        while (i < mfiles.size()) {
            name = mfiles.get(i).getName();
            this.allmakefiles.add(name);
            this.allopts.addAll(Arrays.asList(name.split("-")));
            ++i;
        }
        this.allopts.remove("Makefile.tau");
    }

    private List<IFileStore> testTAUEnv(IFileStore bindir) {
        if (bindir == null || !bindir.fetchInfo().exists()) {
            return null;
        }
        this.taulib = bindir.getParent().getChild(LIB_FOLDER);
        IFileStore[] mfiles = null;
        ArrayList<IFileStore> tmfiles = null;
        if (this.taulib.fetchInfo().exists()) {
            try {
                mfiles = this.taulib.childStores(0, null);
                tmfiles = new ArrayList<IFileStore>();
                IFileStore[] iFileStoreArray = mfiles;
                int n = mfiles.length;
                int n2 = 0;
                while (n2 < n) {
                    IFileStore mfile = iFileStoreArray[n2];
                    IFileInfo finf = mfile.fetchInfo();
                    if (!finf.isDirectory() && finf.getName().startsWith("Makefile.tau")) {
                        tmfiles.add(mfile);
                    }
                    ++n2;
                }
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
        return tmfiles;
    }

    public Combo getCombo() {
        return this.combo;
    }

    public String getSelection() {
        String selection = "";
        String makefilePath = "";
        if (this.taulib != null && this.combo.getSelectionIndex() != -1) {
            selection = this.combo.getItem(this.combo.getSelectionIndex());
            makefilePath = String.valueOf(this.taulib.toURI().getPath()) + "/" + selection;
        }
        return makefilePath;
    }

    public void setConfiguration(ILaunchConfiguration configuration) {
        if (this.blt != null && this.blt.getConfig() == null) {
            this.blt.setConfig(configuration);
            if (!this.refreshing) {
                this.job.setUser(true);
                this.job.schedule();
            }
        }
    }

    public void setVariableMap(IVariableMap map) {
        this.map = map;
    }
}

