/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.rdt.ui.util;

import java.net.URI;
import org.eclipse.cdt.core.EFSExtensionProvider;
import org.eclipse.cdt.utils.EFSExtensionManager;
import org.eclipse.core.resources.IProject;
import org.eclipse.ptp.rdt.core.serviceproviders.IIndexServiceProvider;
import org.eclipse.ptp.services.core.IService;
import org.eclipse.ptp.services.core.IServiceConfiguration;
import org.eclipse.ptp.services.core.IServiceProvider;
import org.eclipse.ptp.services.core.ServiceModelManager;

public class PathReplacer {
    public static URI replacePath(IProject project, URI u, String path) {
        if (PathReplacer.isLocalServiceConfiguration(project) && u.getScheme().equals("file")) {
            return new EFSExtensionProvider(){}.createNewURIFromPath(u, path);
        }
        return EFSExtensionManager.getDefault().createNewURIFromPath(u, path);
    }

    private static boolean isLocalServiceConfiguration(IProject project) {
        IService indexingService;
        IServiceConfiguration serviceConfig;
        IServiceProvider serviceProvider;
        ServiceModelManager smm = ServiceModelManager.getInstance();
        if (smm.isConfigured(project) && (serviceProvider = (serviceConfig = smm.getActiveConfiguration(project)).getServiceProvider(indexingService = smm.getService("org.eclipse.ptp.rdt.core.CIndexingService"))) instanceof IIndexServiceProvider) {
            return !((IIndexServiceProvider)serviceProvider).isRemote();
        }
        return false;
    }
}

