/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.remote.rse.core;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.ptp.internal.remote.rse.core.RSEAdapterCorePlugin;
import org.eclipse.ptp.internal.remote.rse.core.RSEConnectionManager;
import org.eclipse.ptp.internal.remote.rse.core.messages.Messages;
import org.eclipse.remote.core.AbstractRemoteServices;
import org.eclipse.remote.core.IRemoteConnectionManager;
import org.eclipse.remote.core.IRemoteServices;
import org.eclipse.remote.core.IRemoteServicesDescriptor;
import org.eclipse.rse.core.RSECorePlugin;
import org.eclipse.rse.core.model.ISystemRegistry;

public class RSEServices
extends AbstractRemoteServices {
    private ISystemRegistry fRegistry = null;
    private IRemoteConnectionManager fConnMgr = null;
    private boolean fInitialized;

    public RSEServices(IRemoteServicesDescriptor descriptor) {
        super(descriptor);
    }

    private void checkInitialize() {
        this.fRegistry = RSECorePlugin.getTheSystemRegistry();
        if (this.fRegistry == null) {
            return;
        }
        if (!RSECorePlugin.isInitComplete((int)0)) {
            return;
        }
        if (!RSECorePlugin.getThePersistenceManager().isRestoreComplete()) {
            return;
        }
        this.fConnMgr = new RSEConnectionManager(this.fRegistry, (IRemoteServices)this);
        this.fInitialized = true;
    }

    public int getCapabilities() {
        return 5;
    }

    public IRemoteConnectionManager getConnectionManager() {
        if (!this.fInitialized) {
            return null;
        }
        if (this.fConnMgr == null) {
            this.fConnMgr = new RSEConnectionManager(this.fRegistry, (IRemoteServices)this);
        }
        return this.fConnMgr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean initialize(IProgressMonitor monitor) {
        if (!this.fInitialized) {
            RSEAdapterCorePlugin.log(new Exception("RSE Initialized!"));
            SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)10);
            progress.setTaskName(Messages.RSEServices_Initializing_RSE_services);
            while (!this.fInitialized && !progress.isCanceled()) {
                progress.setWorkRemaining(9);
                this.checkInitialize();
                if (!this.fInitialized) {
                    try {
                        RSEServices rSEServices = this;
                        synchronized (rSEServices) {
                            ((Object)((Object)this)).wait(500L);
                        }
                    }
                    catch (InterruptedException interruptedException) {}
                }
                progress.worked(1);
            }
        }
        return this.fInitialized;
    }
}

