/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.rdt.core;

import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.cdtvariables.CdtVariableException;
import org.eclipse.cdt.core.cdtvariables.ICdtVariableManager;
import org.eclipse.cdt.core.language.settings.providers.ILanguageSettingsChangeEvent;
import org.eclipse.cdt.core.language.settings.providers.ILanguageSettingsChangeListener;
import org.eclipse.cdt.core.language.settings.providers.LanguageSettingsManager;
import org.eclipse.cdt.core.parser.ExtendedScannerInfo;
import org.eclipse.cdt.core.parser.IScannerInfo;
import org.eclipse.cdt.core.parser.IScannerInfoChangeListener;
import org.eclipse.cdt.core.parser.IScannerInfoProvider;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.core.settings.model.ICLanguageSettingEntry;
import org.eclipse.cdt.core.settings.model.ICMacroEntry;
import org.eclipse.cdt.core.settings.model.ICPathEntry;
import org.eclipse.cdt.core.settings.model.ICProjectDescription;
import org.eclipse.cdt.core.settings.model.util.CDataUtil;
import org.eclipse.cdt.internal.core.language.settings.providers.LanguageSettingsProvidersSerializer;
import org.eclipse.cdt.internal.core.settings.model.CProjectDescriptionManager;
import org.eclipse.cdt.internal.core.settings.model.SettingsModelMessages;
import org.eclipse.cdt.utils.EFSExtensionManager;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;

public class LanguageSettingsScannerInfoProvider_Hack
implements IScannerInfoProvider,
ILanguageSettingsChangeListener {
    private static final String FRAMEWORK_PRIVATE_HEADERS_INCLUDE = "/__framework__.framework/PrivateHeaders/__header__";
    private static final String FRAMEWORK_HEADERS_INCLUDE = "/__framework__.framework/Headers/__header__";
    private static final ExtendedScannerInfo DUMMY_SCANNER_INFO = new ExtendedScannerInfo();
    private static List<String> C_IDS = Arrays.asList("org.eclipse.cdt.core.gcc", "org.eclipse.cdt.core.lrparser.xlc.c");
    private static List<String> CPP_IDS = Arrays.asList("org.eclipse.cdt.core.g++", "org.eclipse.cdt.core.lrparser.xlc.cpp");
    private Map<IResource, List<IScannerInfoChangeListener>> listenersMap = null;

    public ExtendedScannerInfo getScannerInformation(IResource rc) {
        IProject project = rc.getProject();
        if (project == null) {
            return DUMMY_SCANNER_INFO;
        }
        ICProjectDescription prjDescription = CProjectDescriptionManager.getInstance().getProjectDescription(project, false);
        if (prjDescription == null) {
            return DUMMY_SCANNER_INFO;
        }
        ICConfigurationDescription cfgDescription = prjDescription.getDefaultSettingConfiguration();
        if (cfgDescription == null) {
            return DUMMY_SCANNER_INFO;
        }
        ArrayList languageIds = LanguageSettingsManager.getLanguages((IResource)rc, (ICConfigurationDescription)cfgDescription);
        HashSet allLanguageIds = new HashSet();
        allLanguageIds.addAll(languageIds);
        for (String id : languageIds) {
            if (CPP_IDS.contains(id)) {
                allLanguageIds.addAll(CPP_IDS);
                continue;
            }
            if (!C_IDS.contains(id)) continue;
            allLanguageIds.addAll(C_IDS);
        }
        languageIds = new ArrayList(allLanguageIds);
        if (languageIds.isEmpty()) {
            String msg = NLS.bind((String)SettingsModelMessages.getString((String)"LanguageSettingsScannerInfoProvider.UnableToDetermineLanguage"), (Object)rc.toString());
            Status status = new Status(2, "org.eclipse.cdt.core", msg, (Throwable)new Exception());
            CCorePlugin.log((IStatus)status);
            return DUMMY_SCANNER_INFO;
        }
        LinkedHashSet<ICLanguageSettingEntry> includePathEntries = new LinkedHashSet<ICLanguageSettingEntry>();
        LinkedHashSet<ICLanguageSettingEntry> includePathLocalEntries = new LinkedHashSet<ICLanguageSettingEntry>();
        LinkedHashSet<ICLanguageSettingEntry> includeFileEntries = new LinkedHashSet<ICLanguageSettingEntry>();
        LinkedHashSet<ICLanguageSettingEntry> macroFileEntries = new LinkedHashSet<ICLanguageSettingEntry>();
        LinkedHashSet macroEntries = new LinkedHashSet();
        for (String langId : languageIds) {
            List incSys = LanguageSettingsProvidersSerializer.getSystemSettingEntriesByKind((ICConfigurationDescription)cfgDescription, (IResource)rc, (String)langId, (int)1);
            includePathEntries.addAll(incSys);
            List incLocal = LanguageSettingsProvidersSerializer.getLocalSettingEntriesByKind((ICConfigurationDescription)cfgDescription, (IResource)rc, (String)langId, (int)1);
            includePathLocalEntries.addAll(incLocal);
            List incFiles = LanguageSettingsProvidersSerializer.getSettingEntriesByKind((ICConfigurationDescription)cfgDescription, (IResource)rc, (String)langId, (int)2);
            includeFileEntries.addAll(incFiles);
            List macroFiles = LanguageSettingsProvidersSerializer.getSettingEntriesByKind((ICConfigurationDescription)cfgDescription, (IResource)rc, (String)langId, (int)8);
            macroFileEntries.addAll(macroFiles);
            List macros = LanguageSettingsProvidersSerializer.getSettingEntriesByKind((ICConfigurationDescription)cfgDescription, (IResource)rc, (String)langId, (int)4);
            macroEntries.addAll(macros);
        }
        String[] includePaths = this.convertToLocations(includePathEntries, cfgDescription);
        String[] includePathsLocal = this.convertToLocations(includePathLocalEntries, cfgDescription);
        String[] includeFiles = this.convertToLocations(includeFileEntries, cfgDescription);
        String[] macroFiles = this.convertToLocations(macroFileEntries, cfgDescription);
        HashMap<String, String> definedMacros = new HashMap<String, String>();
        for (ICLanguageSettingEntry entry : macroEntries) {
            ICMacroEntry macroEntry = (ICMacroEntry)entry;
            String name = macroEntry.getName();
            String value = macroEntry.getValue();
            definedMacros.put(name, value);
        }
        return new ExtendedScannerInfo(definedMacros, includePaths, macroFiles, includeFiles, includePathsLocal);
    }

    private String expandVariables(String pathStr, ICConfigurationDescription cfgDescription) {
        try {
            ICdtVariableManager varManager = CCorePlugin.getDefault().getCdtVariableManager();
            pathStr = varManager.resolveValue(pathStr, "", null, cfgDescription);
        }
        catch (Exception e) {
            CCorePlugin.log((Throwable)e);
        }
        return pathStr;
    }

    private static IPath getBuildCWD(ICConfigurationDescription cfgDescription) {
        IPath buildCWD = cfgDescription.getBuildSetting().getBuilderCWD();
        if (buildCWD == null) {
            IProject project = cfgDescription.getProjectDescription().getProject();
            buildCWD = project.getLocation();
        } else {
            ICdtVariableManager mngr = CCorePlugin.getDefault().getCdtVariableManager();
            try {
                String buildPathString = buildCWD.toString();
                buildPathString = mngr.resolveValue(buildPathString, "", null, cfgDescription);
                if (!buildPathString.isEmpty()) {
                    buildCWD = new Path(buildPathString);
                } else {
                    IProject project = cfgDescription.getProjectDescription().getProject();
                    URI locationURI = project.getLocationURI();
                    String path = EFSExtensionManager.getDefault().getPathFromURI(locationURI);
                    buildCWD = new Path(path);
                }
            }
            catch (CdtVariableException e) {
                CCorePlugin.log((Throwable)e);
            }
        }
        buildCWD = buildCWD.addTrailingSeparator();
        return buildCWD;
    }

    private static String resolveEntry(String location, ICConfigurationDescription cfgDescription) {
        IPath buildCWD;
        String device;
        Path locPath;
        ICdtVariableManager varManager = CCorePlugin.getDefault().getCdtVariableManager();
        try {
            location = varManager.resolveValue(location, "", null, cfgDescription);
        }
        catch (CdtVariableException e) {
            CCorePlugin.log((Throwable)e);
        }
        if (File.separatorChar != '/') {
            location = location.replace('/', File.separatorChar);
        }
        if ((locPath = new Path(location)).isAbsolute() && locPath.getDevice() == null && (device = (buildCWD = LanguageSettingsScannerInfoProvider_Hack.getBuildCWD(cfgDescription)).getDevice()) != null) {
            location = String.valueOf(device) + location;
        }
        if (!locPath.isAbsolute()) {
            buildCWD = LanguageSettingsScannerInfoProvider_Hack.getBuildCWD(cfgDescription);
            location = String.valueOf(buildCWD.addTrailingSeparator().toOSString()) + location;
        }
        return location;
    }

    private String toOSString(String loc) {
        if (File.separatorChar != '/') {
            loc = loc.replace('/', File.separatorChar);
        }
        return loc;
    }

    private String[] convertToLocations(LinkedHashSet<ICLanguageSettingEntry> entriesPath, ICConfigurationDescription cfgDescription) {
        ArrayList<String> locations = new ArrayList<String>(entriesPath.size());
        for (ICLanguageSettingEntry entry : entriesPath) {
            String expandedPath;
            ICPathEntry entryPath = (ICPathEntry)entry;
            if (entryPath.isValueWorkspacePath()) {
                ICLanguageSettingEntry[] entries = new ICLanguageSettingEntry[]{entry};
                if (!entry.isResolved()) {
                    entries = CDataUtil.resolveEntries((ICLanguageSettingEntry[])entries, (ICConfigurationDescription)cfgDescription);
                }
                ICLanguageSettingEntry[] iCLanguageSettingEntryArray = entries;
                int n = entries.length;
                int n2 = 0;
                while (n2 < n) {
                    ICLanguageSettingEntry resolved = iCLanguageSettingEntryArray[n2];
                    IPath loc = ((ICPathEntry)resolved).getLocation();
                    if (loc != null) {
                        if (LanguageSettingsScannerInfoProvider_Hack.checkBit(resolved.getFlags(), 64)) {
                            locations.add(loc.append(FRAMEWORK_HEADERS_INCLUDE).toOSString());
                            locations.add(loc.append(FRAMEWORK_PRIVATE_HEADERS_INCLUDE).toOSString());
                        } else {
                            locations.add(loc.toOSString());
                        }
                    }
                    ++n2;
                }
                continue;
            }
            String loc = entryPath.getName();
            if (entryPath.isResolved()) {
                locations.add(loc);
                continue;
            }
            if ((loc = LanguageSettingsScannerInfoProvider_Hack.resolveEntry(loc, cfgDescription)) == null) continue;
            if (LanguageSettingsScannerInfoProvider_Hack.checkBit(entryPath.getFlags(), 64)) {
                locations.add(this.toOSString(String.valueOf(loc) + FRAMEWORK_HEADERS_INCLUDE));
                locations.add(this.toOSString(String.valueOf(loc) + FRAMEWORK_PRIVATE_HEADERS_INCLUDE));
                continue;
            }
            locations.add(this.toOSString(loc));
            String unresolvedPath = entryPath.getName();
            if (new Path(unresolvedPath).isAbsolute() || (expandedPath = this.expandVariables(unresolvedPath, cfgDescription)).isEmpty() || new Path(expandedPath).isAbsolute()) continue;
            locations.add(this.toOSString(expandedPath));
        }
        return locations.toArray(new String[locations.size()]);
    }

    private static boolean checkBit(int flags, int bit) {
        return (flags & bit) == bit;
    }

    public void subscribe(IResource resource, IScannerInfoChangeListener listener) {
        IProject project;
        List<IScannerInfoChangeListener> list;
        if (resource == null || listener == null) {
            return;
        }
        if (this.listenersMap == null) {
            this.listenersMap = Collections.synchronizedMap(new HashMap());
        }
        if ((list = this.listenersMap.get(project = resource.getProject())) == null) {
            list = new Vector<IScannerInfoChangeListener>();
            this.listenersMap.put((IResource)project, list);
        }
        if (!list.contains(listener)) {
            list.add(listener);
        }
    }

    public void unsubscribe(IResource resource, IScannerInfoChangeListener listener) {
        List<IScannerInfoChangeListener> list;
        if (resource == null || listener == null) {
            return;
        }
        IProject project = resource.getProject();
        if (this.listenersMap != null && (list = this.listenersMap.get(project)) != null) {
            list.remove(listener);
        }
    }

    public void handleEvent(ILanguageSettingsChangeEvent event) {
        ICProjectDescription prjDescription;
        if (this.listenersMap == null || this.listenersMap.isEmpty()) {
            return;
        }
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(event.getProjectName());
        if (project != null && (prjDescription = CCorePlugin.getDefault().getProjectDescription(project)) != null) {
            ICConfigurationDescription indexedCfgDescription = prjDescription.getDefaultSettingConfiguration();
            String indexedCfgId = indexedCfgDescription.getId();
            String[] stringArray = event.getConfigurationDescriptionIds();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String cfgId = stringArray[n2];
                if (cfgId.equals(indexedCfgId)) {
                    for (Map.Entry<IResource, List<IScannerInfoChangeListener>> entry : this.listenersMap.entrySet()) {
                        IResource rc = entry.getKey();
                        List<IScannerInfoChangeListener> listeners = this.listenersMap.get(rc);
                        if (listeners == null || listeners.isEmpty()) continue;
                        ExtendedScannerInfo info = this.getScannerInformation(rc);
                        for (IScannerInfoChangeListener listener : listeners) {
                            listener.changeNotification(rc, (IScannerInfo)info);
                        }
                    }
                    break;
                }
                ++n2;
            }
        }
    }
}

