/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.rdt.core.miners;

import java.util.EmptyStackException;
import java.util.Stack;
import org.eclipse.cdt.core.dom.ast.IASTFileLocation;
import org.eclipse.cdt.core.dom.ast.IASTPreprocessorElifStatement;
import org.eclipse.cdt.core.dom.ast.IASTPreprocessorElseStatement;
import org.eclipse.cdt.core.dom.ast.IASTPreprocessorEndifStatement;
import org.eclipse.cdt.core.dom.ast.IASTPreprocessorIfStatement;
import org.eclipse.cdt.core.dom.ast.IASTPreprocessorIfdefStatement;
import org.eclipse.cdt.core.dom.ast.IASTPreprocessorIfndefStatement;
import org.eclipse.cdt.core.dom.ast.IASTPreprocessorStatement;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;

public class RemoteInactiveHighlightingHandler {
    public static String collectInactiveCodePositions(IASTTranslationUnit translationUnit) {
        String result;
        IASTPreprocessorStatement[] preprocStmts;
        if (translationUnit == null) {
            return "";
        }
        String fileName = translationUnit.getFilePath();
        if (fileName == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        int inactiveCodeStart = -1;
        boolean inInactiveCode = false;
        Stack<Boolean> inactiveCodeStack = new Stack<Boolean>();
        IASTPreprocessorStatement[] iASTPreprocessorStatementArray = preprocStmts = translationUnit.getAllPreprocessorStatements();
        int n = preprocStmts.length;
        int n2 = 0;
        while (n2 < n) {
            IASTPreprocessorStatement statement = iASTPreprocessorStatementArray[n2];
            IASTFileLocation floc = statement.getFileLocation();
            if (floc != null && fileName.equals(floc.getFileName())) {
                int inactiveCodeEnd;
                if (statement instanceof IASTPreprocessorIfStatement) {
                    IASTPreprocessorIfStatement ifStmt = (IASTPreprocessorIfStatement)statement;
                    inactiveCodeStack.push(inInactiveCode);
                    if (!ifStmt.taken() && !inInactiveCode) {
                        inactiveCodeStart = floc.getNodeOffset();
                        inInactiveCode = true;
                    }
                } else if (statement instanceof IASTPreprocessorIfdefStatement) {
                    IASTPreprocessorIfdefStatement ifdefStmt = (IASTPreprocessorIfdefStatement)statement;
                    inactiveCodeStack.push(inInactiveCode);
                    if (!ifdefStmt.taken() && !inInactiveCode) {
                        inactiveCodeStart = floc.getNodeOffset();
                        inInactiveCode = true;
                    }
                } else if (statement instanceof IASTPreprocessorIfndefStatement) {
                    IASTPreprocessorIfndefStatement ifndefStmt = (IASTPreprocessorIfndefStatement)statement;
                    inactiveCodeStack.push(inInactiveCode);
                    if (!ifndefStmt.taken() && !inInactiveCode) {
                        inactiveCodeStart = floc.getNodeOffset();
                        inInactiveCode = true;
                    }
                } else if (statement instanceof IASTPreprocessorElseStatement) {
                    IASTPreprocessorElseStatement elseStmt = (IASTPreprocessorElseStatement)statement;
                    if (!elseStmt.taken() && !inInactiveCode) {
                        inactiveCodeStart = floc.getNodeOffset();
                        inInactiveCode = true;
                    } else if (elseStmt.taken() && inInactiveCode) {
                        inactiveCodeEnd = floc.getNodeOffset();
                        RemoteInactiveHighlightingHandler.addHighlightPosition(sb, inactiveCodeStart, inactiveCodeEnd, false);
                        inInactiveCode = false;
                    }
                } else if (statement instanceof IASTPreprocessorElifStatement) {
                    IASTPreprocessorElifStatement elifStmt = (IASTPreprocessorElifStatement)statement;
                    if (!elifStmt.taken() && !inInactiveCode) {
                        inactiveCodeStart = floc.getNodeOffset();
                        inInactiveCode = true;
                    } else if (elifStmt.taken() && inInactiveCode) {
                        inactiveCodeEnd = floc.getNodeOffset();
                        RemoteInactiveHighlightingHandler.addHighlightPosition(sb, inactiveCodeStart, inactiveCodeEnd, false);
                        inInactiveCode = false;
                    }
                } else if (statement instanceof IASTPreprocessorEndifStatement) {
                    try {
                        boolean wasInInactiveCode = (Boolean)inactiveCodeStack.pop();
                        if (inInactiveCode && !wasInInactiveCode) {
                            inactiveCodeEnd = floc.getNodeOffset() + floc.getNodeLength();
                            RemoteInactiveHighlightingHandler.addHighlightPosition(sb, inactiveCodeStart, inactiveCodeEnd, true);
                        }
                        inInactiveCode = wasInInactiveCode;
                    }
                    catch (EmptyStackException emptyStackException) {}
                }
            }
            ++n2;
        }
        if (inInactiveCode) {
            int inactiveCodeEnd = Integer.MAX_VALUE;
            RemoteInactiveHighlightingHandler.addHighlightPosition(sb, inactiveCodeStart, inactiveCodeEnd, true);
        }
        if ((result = sb.toString()).startsWith(",")) {
            result = result.substring(1);
        }
        return result;
    }

    private static void addHighlightPosition(StringBuilder sb, int start, int end, boolean inclusive) {
        sb.append(String.format(",%d,%d,%b", start, end, inclusive));
    }
}

