/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.rdt.core.miners;

import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class ScopeManager {
    private static final String DEFAULT_SCHEME = "rse";
    private Map<String, ScopeData> fScopeNamesToScopeDataMap = new TreeMap<String, ScopeData>();
    private Map<String, String> fFilePathToScopeNameMap = new TreeMap<String, String>();
    private static ScopeManager fInstance = null;

    private ScopeManager() {
    }

    public static synchronized ScopeManager getInstance() {
        if (fInstance == null) {
            fInstance = new ScopeManager();
        }
        return fInstance;
    }

    public synchronized void addScope(String scopeName, String scheme, String host, Set<String> files, String rootPath, String mappedPath) {
        ScopeData data = new ScopeData();
        data.scheme = scheme;
        data.host = host;
        data.rootPath = rootPath;
        data.mappedPath = mappedPath;
        data.files = files;
        this.fScopeNamesToScopeDataMap.put(scopeName, data);
        for (String filename : files) {
            this.fFilePathToScopeNameMap.put(filename, scopeName);
        }
    }

    public synchronized void removeScope(String name) {
        this.fScopeNamesToScopeDataMap.remove(name);
    }

    public synchronized Set<String> getFilesForScope(String name) {
        return this.fScopeNamesToScopeDataMap.get((Object)name).files;
    }

    public void addFileToScope(String scope, String scheme, String host, String filename, String rootPath, String mappedPath) {
        ScopeData data = this.fScopeNamesToScopeDataMap.get(scope);
        if (data == null) {
            data = new ScopeData();
            data.files = new TreeSet<String>();
            data.files.add(filename);
            data.scheme = scheme;
            data.host = host;
            data.rootPath = rootPath;
            data.mappedPath = mappedPath;
            this.fScopeNamesToScopeDataMap.put(scope, data);
        } else {
            Set<String> scopeFiles = data.files;
            if (scopeFiles == null) {
                data.files = scopeFiles = new TreeSet<String>();
            }
            scopeFiles.add(filename);
        }
        this.fFilePathToScopeNameMap.put(filename, scope);
    }

    public void removeFileFromScope(String scope, String filename) {
        Set<String> scopeFiles = this.getFilesForScope(scope);
        if (scopeFiles != null) {
            scopeFiles.remove(filename);
        }
        this.fFilePathToScopeNameMap.remove(filename);
    }

    public Set<String> getAllScopes() {
        return this.fScopeNamesToScopeDataMap.keySet();
    }

    public Set<String> getScopesForFile(String filename) {
        TreeSet<String> resultSet = new TreeSet<String>();
        IPath path = Path.fromOSString((String)filename);
        String canonicalPath = path.toOSString();
        if (canonicalPath.startsWith("//")) {
            canonicalPath = canonicalPath.substring(1);
        }
        Set<String> allScopes = this.getAllScopes();
        Set<String> scopeFiles = null;
        for (String scopeName : allScopes) {
            scopeFiles = this.getFilesForScope(scopeName);
            if (!scopeFiles.contains(canonicalPath)) continue;
            resultSet.add(scopeName);
        }
        return resultSet;
    }

    public String getScopeForFile(String filename) {
        return this.fFilePathToScopeNameMap.get(filename);
    }

    public String getSchemeForScope(String scopeName) {
        ScopeData data = this.fScopeNamesToScopeDataMap.get(scopeName);
        if (data == null) {
            return DEFAULT_SCHEME;
        }
        return data.scheme;
    }

    public String getSchemeForFile(String filename) {
        String scope = this.getScopeForFile(filename);
        if (scope != null) {
            return this.getSchemeForScope(scope);
        }
        return DEFAULT_SCHEME;
    }

    public String getMappedPathForFile(String filename) {
        String scope = this.getScopeForFile(filename);
        if (scope == null) {
            return filename;
        }
        ScopeData sd = this.fScopeNamesToScopeDataMap.get(scope);
        String scopeMappedPath = sd.mappedPath;
        String scopeRootPath = sd.rootPath;
        if (scopeMappedPath == null || scopeRootPath == null) {
            return null;
        }
        Path scopePath = new Path(scopeRootPath);
        Path mappedScopePath = new Path(scopeMappedPath);
        Path filePath = new Path(filename);
        if (scopePath.isPrefixOf((IPath)filePath)) {
            int numSegments = filePath.matchingFirstSegments((IPath)scopePath);
            IPath fileMappedPath = mappedScopePath.append(filePath.removeFirstSegments(numSegments));
            return fileMappedPath.toString();
        }
        return null;
    }

    public String getHostForFile(String path, String defaultHost) {
        String scope = this.getScopeForFile(path);
        if (scope == null) {
            return defaultHost;
        }
        ScopeData sd = this.fScopeNamesToScopeDataMap.get(scope);
        return sd.host;
    }

    public String getRootPath(String scopeName) {
        ScopeData sd = this.fScopeNamesToScopeDataMap.get(scopeName);
        return sd.rootPath;
    }

    public class ScopeData {
        public String scheme;
        public String host;
        public String mappedPath;
        public String rootPath;
        public Set<String> files;
    }
}

