/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.autotools.ui.editors.automake;

import org.eclipse.cdt.internal.autotools.ui.editors.automake.AutomakeEditorFactory;
import org.eclipse.cdt.internal.autotools.ui.editors.automake.BadDirective;
import org.eclipse.cdt.internal.autotools.ui.editors.automake.IDirective;
import org.eclipse.cdt.internal.autotools.ui.editors.automake.IMakefile;
import org.eclipse.cdt.internal.autotools.ui.editors.automake.IParent;
import org.eclipse.core.runtime.AssertionFailedException;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.quickassist.IQuickFixableAnnotation;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.AnnotationModel;
import org.eclipse.ui.IEditorInput;

public class AutomakeErrorHandler {
    public static final String AUTOMAKE_ERROR_MARKER_ID = "org.eclipse.cdt.autotools.ui.parsefileerror";
    private IDocument document;
    private AnnotationModel fAnnotationModel;
    public static final String CDT_ANNOTATION_INFO = "org.eclipse.cdt.ui.info";
    public static final String CDT_ANNOTATION_WARNING = "org.eclipse.cdt.ui.warning";
    public static final String CDT_ANNOTATION_ERROR = "org.eclipse.cdt.ui.error";

    public AutomakeErrorHandler(IEditorInput input) {
        this.document = AutomakeEditorFactory.getDefault().getAutomakefileDocumentProvider().getDocument(input);
        this.fAnnotationModel = (AnnotationModel)AutomakeEditorFactory.getDefault().getAutomakefileDocumentProvider().getAnnotationModel(input);
    }

    public void update(IMakefile makefile) {
        this.removeExistingMarkers();
        this.checkChildren(makefile);
    }

    private void checkChildren(IParent parent) {
        IDirective[] directives = parent.getDirectives();
        int i = 0;
        while (i < directives.length) {
            IDirective directive = directives[i];
            if (directive instanceof IParent) {
                this.checkChildren((IParent)directive);
            } else if (directive instanceof BadDirective) {
                int lineNumber = directive.getStartLine();
                Integer charStart = this.getCharOffset(lineNumber - 1, 0);
                Integer charEnd = (int)this.getCharOffset(directive.getEndLine() - 1, -1);
                String annotationType = CDT_ANNOTATION_ERROR;
                AutomakeAnnotation annotation = new AutomakeAnnotation(annotationType, true, "Bad directive");
                Position p = new Position(charStart.intValue(), charEnd - charStart);
                this.fAnnotationModel.addAnnotation((Annotation)annotation, p);
            }
            ++i;
        }
    }

    public void removeExistingMarkers() {
        this.fAnnotationModel.removeAllAnnotations();
    }

    private Integer getCharOffset(int lineNumber, int columnNumber) {
        try {
            if (columnNumber >= 0) {
                return this.document.getLineOffset(lineNumber) + columnNumber;
            }
            return this.document.getLineOffset(lineNumber) + this.document.getLineLength(lineNumber);
        }
        catch (BadLocationException e) {
            e.printStackTrace();
            return null;
        }
    }

    private static class AutomakeAnnotation
    extends Annotation
    implements IQuickFixableAnnotation {
        public AutomakeAnnotation(String annotationType, boolean persist, String message) {
            super(annotationType, persist, message);
        }

        public void setQuickFixable(boolean state) {
        }

        public boolean isQuickFixableStateSet() {
            return true;
        }

        public boolean isQuickFixable() throws AssertionFailedException {
            return false;
        }
    }
}

