/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.gdb.service.command;

import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.cdt.dsf.gdb.internal.GdbPlugin;
import org.eclipse.cdt.dsf.gdb.internal.Messages;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;

public class CustomTimeoutsMap
extends HashMap<String, Integer> {
    private static final long serialVersionUID = -8281280275781904870L;

    public CustomTimeoutsMap() {
    }

    public CustomTimeoutsMap(CustomTimeoutsMap map) {
        super(map);
    }

    public String getMemento() {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry entry : this.entrySet()) {
            sb.append((String)entry.getKey());
            sb.append(',');
            sb.append((Integer)entry.getValue());
            sb.append(';');
        }
        return sb.toString();
    }

    public void initializeFromMemento(String memento) {
        this.clear();
        StringTokenizer st = new StringTokenizer(memento, ";");
        MultiStatus ms = new MultiStatus("org.eclipse.cdt.dsf.gdb", 0, Messages.CustomTimeoutsMap_Error_initializing_custom_timeouts, null);
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            String[] tokenParts = token.split(",");
            if (tokenParts.length == 2 && tokenParts[0].length() > 0 && tokenParts[1].length() > 0) {
                try {
                    this.put(tokenParts[0], Integer.valueOf(tokenParts[1]));
                }
                catch (NumberFormatException numberFormatException) {
                    ms.add((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", String.format(Messages.CustomTimeoutsMap_Invalid_custom_timeout_value, tokenParts[0])));
                }
                continue;
            }
            ms.add((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", Messages.CustomTimeoutsMap_Invalid_custom_timeout_data));
        }
        if (!ms.isOK()) {
            GdbPlugin.getDefault().getLog().log((IStatus)ms);
        }
    }
}

