/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.lttng2.control.ui.views.handlers;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.linuxtools.internal.lttng2.control.core.model.TraceEnablement;
import org.eclipse.linuxtools.internal.lttng2.control.ui.views.handlers.BaseControlViewHandler;
import org.eclipse.linuxtools.internal.lttng2.control.ui.views.messages.Messages;
import org.eclipse.linuxtools.internal.lttng2.control.ui.views.model.impl.TraceChannelComponent;
import org.eclipse.linuxtools.internal.lttng2.control.ui.views.model.impl.TraceControlComponent;
import org.eclipse.linuxtools.internal.lttng2.control.ui.views.model.impl.TraceEventComponent;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public abstract class ChangeEventStateHandler
extends BaseControlViewHandler {
    protected Parameter fParam;

    protected abstract TraceEnablement getNewState();

    protected abstract void changeState(TraceChannelComponent var1, List<String> var2, IProgressMonitor var3) throws ExecutionException;

    public Object execute(ExecutionEvent event) throws ExecutionException {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window == null) {
            return false;
        }
        this.fLock.lock();
        try {
            final Parameter param = new Parameter(this.fParam);
            Job job = new Job(Messages.TraceControl_ChangeChannelStateJob){

                protected IStatus run(IProgressMonitor monitor) {
                    ExecutionException error = null;
                    TraceControlComponent session = null;
                    try {
                        boolean isAll = false;
                        if (param.getChannel() != null) {
                            session = param.getChannel().getSession();
                            ArrayList<String> eventNames = new ArrayList<String>();
                            List<TraceEventComponent> events = param.getEvents();
                            for (TraceEventComponent traceEvent : events) {
                                if ("*".equals(traceEvent.getName())) {
                                    isAll = true;
                                    continue;
                                }
                                eventNames.add(traceEvent.getName());
                            }
                            if (isAll) {
                                ChangeEventStateHandler.this.changeState(param.getChannel(), null, monitor);
                            }
                            if (!eventNames.isEmpty()) {
                                ChangeEventStateHandler.this.changeState(param.getChannel(), eventNames, monitor);
                            }
                            for (TraceEventComponent ev : events) {
                                ev.setState(ChangeEventStateHandler.this.getNewState());
                            }
                        }
                    }
                    catch (ExecutionException e) {
                        error = e;
                    }
                    if (session != null) {
                        session.fireComponentChanged(session);
                    }
                    if (error != null) {
                        return new Status(4, "org.eclipse.linuxtools.lttng2.control.ui", Messages.TraceControl_ChangeEventStateFailure, (Throwable)error);
                    }
                    return Status.OK_STATUS;
                }
            };
            job.setUser(true);
            job.schedule();
        }
        finally {
            this.fLock.unlock();
        }
        return null;
    }

    public boolean isEnabled() {
        IWorkbenchPage page = this.getWorkbenchPage();
        if (page == null) {
            return false;
        }
        ISelection selection = page.getSelection("org.eclipse.linuxtools.internal.lttng2.ui.views.control");
        TraceChannelComponent channel = null;
        ArrayList<TraceEventComponent> events = new ArrayList<TraceEventComponent>();
        if (selection instanceof StructuredSelection) {
            StructuredSelection structered = (StructuredSelection)selection;
            String sessionName = null;
            String channelName = null;
            for (Object element : structered) {
                if (!(element instanceof TraceEventComponent)) continue;
                TraceEventComponent event = (TraceEventComponent)element;
                if (sessionName == null) {
                    sessionName = String.valueOf(event.getSessionName());
                }
                if (channel == null) {
                    channel = (TraceChannelComponent)event.getParent();
                }
                if (channelName == null) {
                    channelName = event.getChannelName();
                }
                if (!sessionName.equals(event.getSessionName()) || !channelName.equals(event.getChannelName()) || channel.isKernel() != event.isKernel()) {
                    events.clear();
                    break;
                }
                if (event.getState() == this.getNewState()) continue;
                events.add(event);
            }
        }
        boolean isEnabled = !events.isEmpty();
        this.fLock.lock();
        try {
            this.fParam = null;
            if (isEnabled) {
                this.fParam = new Parameter(channel, events);
            }
        }
        finally {
            this.fLock.unlock();
        }
        return isEnabled;
    }

    protected static class Parameter {
        private final TraceChannelComponent fChannel;
        private final List<TraceEventComponent> fEvents = new ArrayList<TraceEventComponent>();

        public Parameter(TraceChannelComponent channel, List<TraceEventComponent> events) {
            this.fChannel = channel;
            this.fEvents.addAll(events);
        }

        public Parameter(Parameter other) {
            this(other.fChannel, other.fEvents);
        }

        public TraceChannelComponent getChannel() {
            return this.fChannel;
        }

        public List<TraceEventComponent> getEvents() {
            return this.fEvents;
        }
    }
}

