/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.lttng2.control.ui.views.property;

import java.util.ArrayList;
import org.eclipse.linuxtools.internal.lttng2.control.ui.views.messages.Messages;
import org.eclipse.linuxtools.internal.lttng2.control.ui.views.model.impl.TraceSessionComponent;
import org.eclipse.linuxtools.internal.lttng2.control.ui.views.property.BasePropertySource;
import org.eclipse.linuxtools.tmf.ui.properties.ReadOnlyTextPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertyDescriptor;

public class TraceSessionPropertySource
extends BasePropertySource {
    public static final String TRACE_SESSION_NAME_PROPERTY_ID = "trace.session.name";
    public static final String TRACE_SESSION_PATH_PROPERTY_ID = "trace.session.path";
    public static final String TRACE_SESSION_STATE_PROPERTY_ID = "trace.session.state";
    public static final String TRACE_SNAPSHOT_PATH_PROPERTY_ID = "trace.snapshot.path";
    public static final String TRACE_SNAPSHOT_NAME_PROPERTY_ID = "trace.snapshot.name";
    public static final String TRACE_SNAPSHOT_ID_PROPERTY_ID = "trace.snapshot.id";
    public static final String TRACE_SESSION_NAME_PROPERTY_NAME = Messages.TraceControl_SessionNamePropertyName;
    public static final String TRACE_SESSION_PATH_PROPERTY_NAME = Messages.TraceControl_SessionPathPropertyName;
    public static final String TRACE_SESSION_STATE_PROPERTY_NAME = Messages.TraceControl_StatePropertyName;
    public static final String TRACE_SNAPSHOT_PATH_PROPERTY_NAME = Messages.TraceControl_SnapshotPathPropertyName;
    public static final String TRACE_SNAPSHOT_NAME_PROPERTY_NAME = Messages.TraceControl_SnapshotNamePropertyName;
    public static final String TRACE_SNAPSHOT_ID_PROPERTY_NAME = Messages.TraceControl_SnapshotIdPropertyName;
    private final TraceSessionComponent fSession;

    public TraceSessionPropertySource(TraceSessionComponent component) {
        this.fSession = component;
    }

    @Override
    public IPropertyDescriptor[] getPropertyDescriptors() {
        ArrayList<ReadOnlyTextPropertyDescriptor> list = new ArrayList<ReadOnlyTextPropertyDescriptor>();
        list.add(new ReadOnlyTextPropertyDescriptor((Object)TRACE_SESSION_NAME_PROPERTY_ID, TRACE_SESSION_NAME_PROPERTY_NAME));
        list.add(new ReadOnlyTextPropertyDescriptor((Object)TRACE_SESSION_STATE_PROPERTY_ID, TRACE_SESSION_STATE_PROPERTY_NAME));
        if (this.fSession.isSnapshotSession()) {
            list.add(new ReadOnlyTextPropertyDescriptor((Object)TRACE_SNAPSHOT_NAME_PROPERTY_ID, TRACE_SNAPSHOT_NAME_PROPERTY_NAME));
            list.add(new ReadOnlyTextPropertyDescriptor((Object)TRACE_SNAPSHOT_PATH_PROPERTY_ID, TRACE_SNAPSHOT_PATH_PROPERTY_NAME));
            list.add(new ReadOnlyTextPropertyDescriptor((Object)TRACE_SNAPSHOT_ID_PROPERTY_ID, TRACE_SNAPSHOT_ID_PROPERTY_NAME));
        } else {
            list.add(new ReadOnlyTextPropertyDescriptor((Object)TRACE_SESSION_PATH_PROPERTY_ID, TRACE_SESSION_PATH_PROPERTY_NAME));
        }
        return list.toArray(new IPropertyDescriptor[list.size()]);
    }

    @Override
    public Object getPropertyValue(Object id) {
        if (TRACE_SESSION_NAME_PROPERTY_ID.equals(id)) {
            return this.fSession.getName();
        }
        if (TRACE_SESSION_PATH_PROPERTY_ID.equals(id)) {
            return this.fSession.getSessionPath();
        }
        if (TRACE_SESSION_STATE_PROPERTY_ID.equals(id)) {
            return this.fSession.getSessionState().name();
        }
        if (TRACE_SNAPSHOT_PATH_PROPERTY_ID.equals(id)) {
            return this.fSession.isSnapshotSession() ? this.fSession.getSnapshotInfo().getSnapshotPath() : "";
        }
        if (TRACE_SNAPSHOT_NAME_PROPERTY_ID.equals(id)) {
            return this.fSession.isSnapshotSession() ? this.fSession.getSnapshotInfo().getName() : "";
        }
        if (TRACE_SNAPSHOT_ID_PROPERTY_ID.equals(id)) {
            return this.fSession.isSnapshotSession() ? Integer.valueOf(this.fSession.getSnapshotInfo().getId()) : "";
        }
        return null;
    }
}

